/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.util;

import org.apache.vinci.transport.util.Base64FormatException;

public class Base64Converter {
    public static final int LINE_LENGTH = 70;
    private static final byte[] B64_CODE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    private Base64Converter() {
    }

    public static byte[] convertBinaryToBase64(byte[] from) {
        return Base64Converter.convertBinaryToBase64(from, from.length, true);
    }

    public static String convertStringToBase64String(String convert_me) {
        return new String(Base64Converter.convertBinaryToBase64(convert_me.getBytes()));
    }

    public static String convertBase64StringToString(String base64) throws Base64FormatException {
        return new String(Base64Converter.convertBase64ToBinary(base64.getBytes()));
    }

    public static byte[] convertBinaryToBase64(byte[] from, int count, boolean line_breaks) {
        int size = Base64Converter.calculateBase64OutputSize(count, line_breaks);
        byte[] tmp = new byte[size];
        int used = 0;
        for (int done = 0; done < count; done += 3) {
            Base64Converter.b64encodeOctet(tmp, used, from, done, count - done);
            used += 4;
        }
        if (line_breaks) {
            byte[] to = new byte[size];
            int pos = 0;
            for (int breaks = 0; breaks < used; breaks += 70) {
                int length = used - breaks;
                if (length > 70) {
                    length = 70;
                }
                System.arraycopy(tmp, breaks, to, pos, length);
                pos += length;
                to[pos++] = 10;
            }
            return to;
        }
        return tmp;
    }

    public static int calculateBase64OutputSize(int input_size, boolean line_breaks) {
        int q = input_size / 3;
        if (input_size % 3 != 0) {
            ++q;
        }
        q *= 4;
        if (line_breaks) {
            q += q / 70 + (q % 70 == 0 ? 0 : 1);
        }
        return q;
    }

    public static byte[] convertBase64ToBinary(byte[] input) throws Base64FormatException {
        return Base64Converter.convertBase64ToBinary(input, input.length);
    }

    public static byte[] convertBase64ToBinary(byte[] input, int input_size) throws Base64FormatException {
        int output_size = Base64Converter.calculateBinaryOutputSize(input, input_size);
        byte[] output = new byte[output_size];
        int pos = 0;
        int i = 0;
        while (pos + 4 <= input_size) {
            pos = Base64Converter.b64decodeOctet(input, pos, output, 3 * i, input_size);
            ++i;
        }
        return output;
    }

    public static int calculateBinaryOutputSize(byte[] input, int input_size) throws Base64FormatException {
        int output_size = 0;
        int i = 0;
        while (i + 4 <= input_size) {
            i = Base64Converter.consumeInvalidDigits(input, i, input_size);
            ++i;
            i = Base64Converter.consumeInvalidDigits(input, i, input_size);
            ++i;
            if (input[i = Base64Converter.consumeInvalidDigits(input, i, input_size)] == 61) {
                ++output_size;
                break;
            }
            ++i;
            if (input[i = Base64Converter.consumeInvalidDigits(input, i, input_size)] == 61) {
                output_size += 2;
                break;
            }
            ++i;
            output_size += 3;
        }
        return output_size;
    }

    private static int consumeInvalidDigits(byte[] in, int off, int max_offset) throws Base64FormatException {
        if (off >= max_offset) {
            throw new Base64FormatException("short read");
        }
        while (!Base64Converter.b64validDigit(in[off])) {
            if (++off < max_offset) continue;
            throw new Base64FormatException("short read");
        }
        return off;
    }

    private static int b64decodeOctet(byte[] in, int in_offset, byte[] out, int out_offset, int max_offset) throws Base64FormatException {
        int B;
        int A2;
        in_offset = Base64Converter.consumeInvalidDigits(in, in_offset, max_offset);
        if ((A2 = in[in_offset++]) < 0) {
            throw new Base64FormatException();
        }
        in_offset = Base64Converter.consumeInvalidDigits(in, in_offset, max_offset);
        if ((B = in[in_offset++]) < 0) {
            throw new Base64FormatException();
        }
        in_offset = Base64Converter.consumeInvalidDigits(in, in_offset, max_offset);
        int C2 = in[in_offset++];
        in_offset = Base64Converter.consumeInvalidDigits(in, in_offset, max_offset);
        int D = in[in_offset++];
        A2 = Base64Converter.b64decodeDigit(A2);
        A2 <<= 2;
        B = Base64Converter.b64decodeDigit(B);
        out[out_offset] = (byte)(A2 |= B >> 4);
        B <<= 4;
        if ((C2 = Base64Converter.b64decodeDigit(C2)) < 0) {
            return max_offset;
        }
        out[out_offset + 1] = (byte)(B |= C2 >> 2);
        C2 <<= 6;
        if ((D = Base64Converter.b64decodeDigit(D)) < 0) {
            return max_offset;
        }
        out[out_offset + 2] = (byte)(C2 |= D);
        return in_offset;
    }

    private static int b64decodeDigit(int c) {
        if (c >= 65 && c <= 90) {
            return c - 65;
        }
        if (c >= 97 && c <= 122) {
            return c - 97 + 26;
        }
        if (c >= 48 && c <= 57) {
            return c - 48 + 52;
        }
        if (c == 43) {
            return 62;
        }
        if (c == 47) {
            return 63;
        }
        if (c == 61) {
            return -2;
        }
        return -1;
    }

    private static boolean b64validDigit(byte a) {
        if (a >= 65 && a <= 90) {
            return true;
        }
        if (a >= 97 && a <= 122) {
            return true;
        }
        if (a >= 48 && a <= 57) {
            return true;
        }
        return a == 47 || a == 43 || a == 61;
    }

    private static void b64encodeOctet(byte[] to, int to_offset, byte[] from, int from_offset, int count) {
        int A2 = 0;
        int B = 0;
        int C2 = 0;
        int D = 0;
        int tmp = 0;
        A2 = from[from_offset];
        if (A2 < 0) {
            A2 += 256;
        }
        A2 >>= 2;
        B = from[from_offset];
        if (B < 0) {
            B += 256;
        }
        B &= 3;
        B <<= 4;
        if (count > 1) {
            tmp = from[from_offset + 1] < 0 ? from[from_offset + 1] + 256 : from[from_offset + 1];
            B |= tmp >> 4;
            C2 = from[from_offset + 1];
            if (C2 < 0) {
                C2 += 256;
            }
            C2 &= 0xF;
            C2 <<= 2;
        }
        if (count > 2) {
            tmp = from[from_offset + 2] < 0 ? from[from_offset + 2] + 256 : from[from_offset + 2];
            C2 |= tmp >> 6;
            D = from[from_offset + 2];
            if (D < 0) {
                D += 256;
            }
            D &= 0x3F;
        }
        to[to_offset] = Base64Converter.b64codes(A2);
        to[to_offset + 1] = Base64Converter.b64codes(B);
        to[to_offset + 2] = count > 1 ? Base64Converter.b64codes(C2) : (byte)61;
        to[to_offset + 3] = count > 2 ? Base64Converter.b64codes(D) : (byte)61;
    }

    private static byte b64codes(int which) {
        if (which < 0) {
            which += 256;
        }
        return B64_CODE[which];
    }
}

