/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.vns.service;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.vinci.transport.vns.service.Service;

public class ServiceStack {
    String name;
    Stack stack;
    int toplevel;

    public ServiceStack(String name) {
        this.name = name;
        this.reinit();
    }

    public void reinit() {
        this.stack = new Stack();
        this.toplevel = 0;
    }

    public static int getAbsLevel(String level) {
        if (level == null || level.trim().toLowerCase().equals("none")) {
            level = "-1";
        }
        if ((level = level.toLowerCase().trim()).equals("all")) {
            return -2;
        }
        if (level.equals("new") || level.equals("next")) {
            return 0;
        }
        int mylevel = Integer.parseInt(level);
        if (mylevel == -1) {
            return -1;
        }
        if (mylevel < 0) {
            return 0;
        }
        return mylevel;
    }

    public int absLevel(String level) {
        if (level == null || level.trim().toLowerCase().equals("none")) {
            level = "-1";
        }
        if ((level = level.toLowerCase().trim()).equals("all")) {
            return -2;
        }
        if (level.equals("new") || level.equals("next")) {
            return this.toplevel;
        }
        int mylevel = Integer.parseInt(level);
        if (mylevel == -1) {
            return -1;
        }
        if (mylevel < 0) {
            return Math.max(0, this.toplevel + mylevel);
        }
        return mylevel;
    }

    public int absLevel(int i) {
        return this.absLevel("" + i);
    }

    private int actualLevel(int level) {
        if (level < -1) {
            return -1;
        }
        return level + 1;
    }

    public void expand(int level) {
        while (this.stack.size() <= level) {
            this.stack.push(null);
        }
        if (this.toplevel < level) {
            this.toplevel = level;
        }
    }

    public Service[] get(String mylevel) {
        int level = this.absLevel(mylevel);
        ArrayList result = new ArrayList();
        if (level == -2) {
            for (int i = 0; i < this.stack.size(); ++i) {
                if (this.stack.get(i) == null) continue;
                result.addAll((ArrayList)this.stack.get(i));
            }
        } else {
            level = this.actualLevel(level);
            this.expand(level);
            level = Math.min(level, this.toplevel);
            if (level == 0) {
                if (this.stack.get(level) != null) {
                    result.addAll((ArrayList)this.stack.get(level));
                }
                if (result.size() < 1) {
                    level = Math.max(level, this.toplevel);
                }
            }
            while (level >= 1) {
                if (this.stack.get(level) != null) {
                    result.addAll((ArrayList)this.stack.get(level));
                    break;
                }
                --level;
            }
        }
        Service[] res = new Service[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            res[i] = (Service)result.get(i);
        }
        return res;
    }

    public Object[] get(int mylevel) {
        return this.get("" + mylevel);
    }

    public void makeConsistent(Service S) {
        if (S.actualLevel < -1) {
            S.level = "" + this.absLevel(S.level);
            S.actualLevel = this.actualLevel(Integer.parseInt(S.level));
            if (S.level.equals("-2")) {
                S.level = "all";
            }
            S.update();
        }
    }

    public void add(Service S) {
        this.makeConsistent(S);
        int mylevel = S.actualLevel;
        this.expand(mylevel);
        if (this.stack.get(mylevel) == null) {
            ArrayList<Service> v = new ArrayList<Service>();
            v.add(S);
            this.stack.setElementAt(v, mylevel);
        } else {
            ArrayList v = (ArrayList)this.stack.get(mylevel);
            v.add(S);
        }
        ServiceStack.pr("Added " + S.toString());
    }

    public boolean update(Service S) {
        if (S.level == null) {
            ServiceStack.pr("No level specified");
            return false;
        }
        this.makeConsistent(S);
        int mylevel = S.actualLevel;
        if (this.stack.get(mylevel) == null) {
            ServiceStack.pr("No services found at specified level");
            return false;
        }
        ArrayList v = (ArrayList)this.stack.get(mylevel);
        for (int i = 0; i < v.size(); ++i) {
            Service temp = (Service)v.get(i);
            if (!temp.equals(S)) continue;
            S.minport = temp.minport;
            S.maxport = temp.maxport;
            S.port = temp.port;
            S.level = temp.level;
            v.set(i, S);
            ServiceStack.pr("Update of " + S.toString() + " successful");
            return true;
        }
        ServiceStack.pr("No matching service found");
        return false;
    }

    public boolean isEmpty(String level) {
        return this.isEmpty(this.absLevel(level));
    }

    public boolean isEmpty(int level) {
        if (this.stack.size() == 0) {
            return true;
        }
        if (level == -2) {
            return false;
        }
        int mylevel = Math.min(this.actualLevel(level), this.toplevel);
        if (level == -1) {
            mylevel = this.stack.size() - 1;
        }
        while (mylevel >= 0) {
            if (this.stack.get(mylevel) != null) {
                return false;
            }
            --mylevel;
        }
        return true;
    }

    public Object[] delete(Service S) {
        ArrayList<Service> dellist = new ArrayList<Service>();
        ArrayList<Service> newlist = new ArrayList<Service>();
        if (S.level == null) {
            Object[] result = this.get("None");
            this.reinit();
            return result;
        }
        this.makeConsistent(S);
        int mylevel = S.actualLevel;
        if (this.stack.get(mylevel) == null) {
            return dellist.toArray();
        }
        ArrayList srv = (ArrayList)this.stack.get(mylevel);
        ServiceStack.pr("Deleting : " + S);
        for (int i = 0; i < srv.size(); ++i) {
            Service temp = (Service)srv.get(i);
            ServiceStack.pr("Checking : " + temp);
            if (!temp.toString().equals(S.toString())) {
                newlist.add(temp);
                continue;
            }
            ServiceStack.pr("Delete match : " + temp.toString());
            dellist.add(temp);
        }
        if (newlist.size() == 0) {
            this.stack.set(mylevel, null);
            while (this.toplevel > 0 && this.stack.get(this.toplevel) == null) {
                --this.toplevel;
            }
        } else {
            this.stack.setElementAt(newlist, mylevel);
        }
        return dellist.toArray();
    }

    public static String pr(String s2) {
        System.err.println(s2);
        return s2;
    }
}

