/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.vns.service;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ServiceTree {
    Object value = null;
    Hashtable children;

    public ServiceTree() {
        this.value = null;
        this.children = new Hashtable();
    }

    public ServiceTree(Object o) {
        this.value = o;
        this.children = new Hashtable();
    }

    public void setitem(String key, Object value) {
        StringTokenizer str = new StringTokenizer(key, ".");
        ServiceTree at = this;
        while (str.hasMoreTokens()) {
            String s2 = str.nextToken();
            ServiceTree temp = (ServiceTree)at.children.get(s2);
            if (temp == null) {
                at = new ServiceTree();
                at.children.put(s2, at);
                continue;
            }
            at = temp;
        }
        at.value = value;
    }

    public Object find(String s2) {
        StringTokenizer str = new StringTokenizer(s2, ".");
        ServiceTree at = this;
        while (str.countTokens() != 0) {
            at = (ServiceTree)at.children.get(str.nextToken());
            if (at != null) continue;
            return null;
        }
        return at.value;
    }

    public Object[] findprefix(String s2) {
        StringTokenizer str = new StringTokenizer(s2, ".");
        ServiceTree at = this;
        while (str.countTokens() != 0) {
            at = (ServiceTree)at.children.get(str.nextToken());
            if (at != null) continue;
            return null;
        }
        ArrayList<Object> V = new ArrayList<Object>();
        if (at.value != null) {
            V.add(at.value);
        }
        Object[] C2 = at.children.values().toArray();
        for (int i = 0; i < C2.length; ++i) {
            Object[] O = ((ServiceTree)C2[i]).findprefix("");
            if (O == null) continue;
            for (int j = 0; j < O.length; ++j) {
                if (O[j] == null) continue;
                V.add(O[j]);
            }
        }
        return V.size() > 0 ? V.toArray() : null;
    }

    public static void main(String[] args2) throws Exception {
        ServiceTree root = new ServiceTree();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        block0: while (true) {
            System.out.print("Enter a command (I, F, FP) : ");
            String s2 = br.readLine();
            if (s2 == null || s2.equals("")) break;
            if (!(s2 = s2.trim().toUpperCase()).equals("I") && !s2.equals("F") && !s2.equals("FP")) continue;
            System.out.print("Enter the key : ");
            String k = br.readLine();
            if (k == null) continue;
            if (s2.equals("F")) {
                System.out.println("RESULT: " + root.find(k));
                continue;
            }
            if (s2.equals("FP")) {
                Object[] O = root.findprefix(k);
                if (O == null) {
                    System.out.println("No entries found");
                    continue;
                }
                int i = 0;
                while (true) {
                    if (i >= O.length) continue block0;
                    System.out.println("[" + i + "] : " + O[i].toString());
                    ++i;
                }
            }
            if (!s2.equals("I")) continue;
            System.out.print("Enter the value for " + k + " : ");
            String v = br.readLine();
            root.setitem(k, v);
            System.out.println("Done");
        }
    }
}

