/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.util.iterators.EmptyIterator;
import org.eclipse.rdf4j.util.iterators.SingletonIterator;

public class DynamicModel
extends AbstractSet<Statement>
implements Model {
    private static final long serialVersionUID = -9162104133818983614L;
    private static final Resource[] NULL_CTX = new Resource[]{null};
    private Map<Statement, Statement> statements = new LinkedHashMap<Statement, Statement>();
    final Set<Namespace> namespaces = new LinkedHashSet<Namespace>();
    private volatile Model model = null;
    private final ModelFactory modelFactory;

    public DynamicModel(ModelFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    @Override
    public Model unmodifiable() {
        this.upgrade();
        return this.model.unmodifiable();
    }

    @Override
    public Optional<Namespace> getNamespace(String prefix) {
        for (Namespace nextNamespace : this.namespaces) {
            if (!prefix.equals(nextNamespace.getPrefix())) continue;
            return Optional.of(nextNamespace);
        }
        return Optional.empty();
    }

    @Override
    public Set<Namespace> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public Namespace setNamespace(String prefix, String name) {
        this.removeNamespace(prefix);
        SimpleNamespace result = new SimpleNamespace(prefix, name);
        this.namespaces.add(result);
        return result;
    }

    @Override
    public void setNamespace(Namespace namespace) {
        this.removeNamespace(namespace.getPrefix());
        this.namespaces.add(namespace);
    }

    @Override
    public Optional<Namespace> removeNamespace(String prefix) {
        Optional<Namespace> result = this.getNamespace(prefix);
        result.ifPresent(this.namespaces::remove);
        return result;
    }

    @Override
    public boolean contains(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        this.upgrade();
        return this.model.contains(subj, pred, obj, contexts);
    }

    @Override
    public boolean add(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (contexts.length == 0) {
            contexts = NULL_CTX;
        }
        if (this.model == null) {
            boolean added = false;
            for (Resource context : contexts) {
                Statement statement = SimpleValueFactory.getInstance().createStatement(subj, pred, obj, context);
                added |= this.statements.put(statement, statement) == null;
            }
            return added;
        }
        return this.model.add(subj, pred, obj, contexts);
    }

    @Override
    public boolean clear(Resource ... context) {
        this.upgrade();
        return this.model.clear(context);
    }

    @Override
    public boolean remove(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (subj == null || pred == null || obj == null || contexts.length == 0) {
            this.upgrade();
        }
        if (this.model == null) {
            boolean removed = false;
            for (Resource context : contexts) {
                removed |= this.statements.remove(SimpleValueFactory.getInstance().createStatement(subj, pred, obj, context)) != null;
            }
            return removed;
        }
        return this.model.remove(subj, pred, obj, contexts);
    }

    @Override
    public Model filter(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        this.upgrade();
        return this.model.filter(subj, pred, obj, contexts);
    }

    @Override
    public Set<Resource> subjects() {
        this.upgrade();
        return this.model.subjects();
    }

    @Override
    public Set<IRI> predicates() {
        this.upgrade();
        return this.model.predicates();
    }

    @Override
    public Set<Value> objects() {
        this.upgrade();
        return this.model.objects();
    }

    @Override
    public Set<Resource> contexts() {
        this.upgrade();
        return this.model.contexts();
    }

    @Override
    public int size() {
        if (this.model == null) {
            return this.statements.size();
        }
        return this.model.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.model == null) {
            return this.statements.isEmpty();
        }
        return this.model.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (this.model == null) {
            return this.statements.containsKey(o);
        }
        return this.model.contains(o);
    }

    @Override
    public Iterator<Statement> iterator() {
        if (this.model == null) {
            return this.statements.values().iterator();
        }
        return this.model.iterator();
    }

    @Override
    public Object[] toArray() {
        if (this.model == null) {
            return this.statements.values().toArray();
        }
        return this.model.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (this.model == null) {
            return this.statements.values().toArray(a);
        }
        return this.model.toArray(a);
    }

    @Override
    public boolean add(Statement statement) {
        Objects.requireNonNull(statement);
        if (this.model == null) {
            return this.statements.put(statement, statement) == null;
        }
        return this.model.add(statement);
    }

    @Override
    public boolean remove(Object o) {
        Objects.requireNonNull(o);
        if (this.model == null) {
            return this.statements.remove(o) != null;
        }
        return this.model.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Objects.requireNonNull(c);
        if (this.model == null) {
            return this.statements.keySet().containsAll(c);
        }
        return this.model.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Statement> c) {
        Objects.requireNonNull(c);
        if (this.model == null) {
            return c.stream().map(s2 -> {
                Objects.requireNonNull(s2);
                return this.statements.put((Statement)s2, (Statement)s2) == null;
            }).reduce((a, b) -> a != false || b != false).orElse(false);
        }
        return this.model.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.model == null) {
            return this.statements.keySet().retainAll(c);
        }
        return this.model.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.model == null) {
            return c.stream().map(this.statements::remove).map(Objects::nonNull).reduce((a, b) -> a != false || b != false).orElse(false);
        }
        return this.model.removeAll(c);
    }

    @Override
    public void clear() {
        if (this.model == null) {
            this.statements.clear();
        } else {
            this.model.clear();
        }
    }

    @Override
    public Iterable<Statement> getStatements(Resource subject, IRI predicate, Value object, Resource ... contexts) {
        if (this.model == null && subject != null && predicate != null && object != null && contexts != null && contexts.length == 1) {
            Statement statement = SimpleValueFactory.getInstance().createStatement(subject, predicate, object, contexts[0]);
            Statement foundStatement = this.statements.get(statement);
            if (foundStatement == null) {
                return EmptyIterator::new;
            }
            return () -> new SingletonIterator<Statement>(foundStatement);
        }
        if (this.model == null && subject == null && predicate == null && object == null && contexts != null && contexts.length == 0) {
            return this;
        }
        this.upgrade();
        return this.model.getStatements(subject, predicate, object, contexts);
    }

    private void upgrade() {
        if (this.model == null) {
            this.synchronizedUpgrade();
        }
    }

    private synchronized void synchronizedUpgrade() {
        if (this.model == null) {
            this.statements = Collections.unmodifiableMap(this.statements);
            Model tempModel = this.modelFactory.createEmptyModel();
            tempModel.addAll(this.statements.values());
            this.model = tempModel;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.model != null) {
            return this.model.equals(o);
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        if (this.model != null) {
            return this.model.hashCode();
        }
        return super.hashCode();
    }
}

