/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.GetStatementOptional;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.util.Statements;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class RDFCollections {
    public static <C extends Collection<Statement>> C asRDF(Iterable<?> values2, Resource head, C sink, Resource ... contexts) {
        Objects.requireNonNull(sink);
        RDFCollections.consumeCollection(values2, head, sink::add, contexts);
        return sink;
    }

    public static <C extends Collection<Statement>> C asRDF(Iterable<?> values2, Resource head, C sink, ValueFactory valueFactory, Resource ... contexts) {
        Objects.requireNonNull(sink);
        RDFCollections.consumeCollection(values2, head, (Statement st) -> sink.add(st), valueFactory, contexts);
        return sink;
    }

    public static <C extends Collection<Value>> C asValues(Model m3, Resource head, C collection, Resource ... contexts) throws ModelException {
        Objects.requireNonNull(collection, "collection may not be null");
        RDFCollections.consumeValues(m3, head, v -> collection.add(v), contexts);
        return collection;
    }

    public static void consumeCollection(Iterable<?> values2, Resource head, Consumer<Statement> consumer, Resource ... contexts) {
        RDFCollections.consumeCollection(values2, head, consumer, SimpleValueFactory.getInstance(), contexts);
    }

    public static void consumeCollection(Iterable<?> values2, Resource head, Consumer<Statement> consumer, ValueFactory vf, Resource ... contexts) {
        Objects.requireNonNull(values2, "input collection may not be null");
        Objects.requireNonNull(consumer, "consumer may not be null");
        Objects.requireNonNull(vf, "injected value factory may not be null");
        Resource current = head != null ? head : vf.createBNode();
        Statements.consume(vf, current, RDF.TYPE, RDF.LIST, consumer, contexts);
        Iterator<?> iter = values2.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            Value v = o instanceof Value ? (Value)o : Literals.createLiteralOrFail(vf, o);
            Statements.consume(vf, current, RDF.FIRST, v, consumer, contexts);
            if (iter.hasNext()) {
                BNode next = vf.createBNode();
                Statements.consume(vf, current, RDF.REST, next, consumer, contexts);
                current = next;
                continue;
            }
            Statements.consume(vf, current, RDF.REST, RDF.NIL, consumer, contexts);
        }
    }

    public static void consumeValues(Model m3, Resource head, Consumer<Value> consumer, Resource ... contexts) throws ModelException {
        Objects.requireNonNull(consumer, "consumer may not be null");
        Objects.requireNonNull(m3, "input model may not be null");
        GetStatementOptional statementSupplier = (s2, p, o, c) -> m3.filter(s2, p, o, c).stream().findAny();
        Function exceptionSupplier = Models::modelException;
        RDFCollections.extract(statementSupplier, head, (Statement st) -> {
            if (RDF.FIRST.equals(st.getPredicate())) {
                consumer.accept(st.getObject());
            }
        }, exceptionSupplier, contexts);
    }

    public static <C extends Collection<Statement>> C getCollection(Model sourceModel, Resource head, C sink, Resource ... contexts) {
        Objects.requireNonNull(sourceModel, "input model may not be null");
        RDFCollections.extract(sourceModel, head, (Statement st) -> sink.add(st), contexts);
        return sink;
    }

    public static void extract(Model sourceModel, Resource head, Consumer<Statement> consumer, Resource ... contexts) {
        Objects.requireNonNull(sourceModel, "source model may not be null");
        GetStatementOptional statementSupplier = (s2, p, o, c) -> sourceModel.filter(s2, p, o, c).stream().findAny();
        RDFCollections.extract(statementSupplier, head, consumer, Models::modelException, contexts);
    }

    public static <E extends RDF4JException> void extract(GetStatementOptional statementSupplier, Resource head, Consumer<Statement> collectionConsumer, Function<String, Supplier<E>> exceptionSupplier, Resource ... contexts) throws E {
        OpenRDFUtil.verifyContextNotNull(contexts);
        Objects.requireNonNull(head, "list head may not be null");
        Objects.requireNonNull(collectionConsumer, "collection consumer may not be null");
        Resource current = head;
        HashSet<Resource> visited = new HashSet<Resource>();
        while (!RDF.NIL.equals(current)) {
            if (visited.contains(current)) {
                throw (RDF4JException)exceptionSupplier.apply("list not well-formed: cycle detected").get();
            }
            statementSupplier.get(current, RDF.TYPE, RDF.LIST, contexts).ifPresent(collectionConsumer);
            collectionConsumer.accept(statementSupplier.get(current, RDF.FIRST, null, contexts).orElseThrow(exceptionSupplier.apply("list not wellformed: rdf:first statement missing.")));
            Statement next = statementSupplier.get(current, RDF.REST, null, contexts).orElseThrow(exceptionSupplier.apply("list not well-formed: rdf:rest statement missing."));
            collectionConsumer.accept(next);
            if (!(next.getObject() instanceof Resource)) {
                throw (RDF4JException)exceptionSupplier.apply("list not well-formed: value of rdf:rest should be one of (IRI, BNode).").get();
            }
            visited.add(current);
            current = (Resource)next.getObject();
        }
    }
}

