/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.GetStatementOptional;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.util.Statements;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;

public class RDFContainers {
    public static <C extends Collection<Statement>> C toRDF(IRI containerType, Iterable<?> values2, Resource container, C sink, Resource ... contexts) {
        Objects.requireNonNull(sink);
        RDFContainers.consumeContainer(containerType, values2, container, (Statement st) -> sink.add(st), contexts);
        return sink;
    }

    public static <C extends Collection<Statement>> C toRDF(IRI containerType, Iterable<?> values2, Resource container, C sink, ValueFactory vf, Resource ... contexts) {
        Objects.requireNonNull(sink);
        RDFContainers.consumeContainer(containerType, values2, container, (Statement st) -> sink.add(st), vf, contexts);
        return sink;
    }

    public static <C extends Collection<Value>> C toValues(IRI containerType, Model m3, Resource container, C collection, Resource ... contexts) throws ModelException {
        Objects.requireNonNull(collection, "collection may not be null");
        RDFContainers.consumeValues(m3, container, containerType, v -> collection.add(v), contexts);
        return collection;
    }

    public static void consumeContainer(IRI containerType, Iterable<?> values2, Resource container, Consumer<Statement> consumer, Resource ... contexts) {
        RDFContainers.consumeContainer(containerType, values2, container, consumer, SimpleValueFactory.getInstance(), contexts);
    }

    public static void consumeContainer(IRI containerType, Iterable<?> values2, Resource container, Consumer<Statement> consumer, ValueFactory vf, Resource ... contexts) {
        boolean validType;
        Objects.requireNonNull(values2, "input collection may not be null");
        Objects.requireNonNull(consumer, "consumer may not be null");
        Objects.requireNonNull(vf, "injected value factory may not be null");
        Resource current = container != null ? container : vf.createBNode();
        boolean bl = validType = Objects.equals(containerType, RDF.ALT) || Objects.equals(containerType, RDF.BAG) || Objects.equals(containerType, RDF.SEQ);
        if (!validType) {
            throw new ModelException("containerType should be one of ALT, BAG or SEQ");
        }
        Statements.consume(vf, current, RDF.TYPE, containerType, consumer, contexts);
        Iterator<?> iter = values2.iterator();
        int elementCounter = 1;
        while (iter.hasNext()) {
            Object o = iter.next();
            Value v = o instanceof Value ? (Value)o : Literals.createLiteralOrFail(vf, o);
            IRI elementCounterPredicate = RDFContainers.getAnnotatedMemberPredicate(vf, elementCounter);
            ++elementCounter;
            Statements.consume(vf, current, elementCounterPredicate, v, consumer, contexts);
            Statements.consume(vf, current, RDFS.MEMBER, v, consumer, contexts);
        }
    }

    private static IRI getAnnotatedMemberPredicate(ValueFactory vf, int elementCounter) {
        return vf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "_" + elementCounter);
    }

    public static void consumeValues(Model m3, Resource container, IRI containerType, Consumer<Value> consumer, Resource ... contexts) throws ModelException {
        Objects.requireNonNull(consumer, "consumer may not be null");
        Objects.requireNonNull(m3, "input model may not be null");
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        GetStatementOptional statementSupplier = (s2, p, o, c) -> m3.filter(s2, p, o, c).stream().findAny();
        Function exceptionSupplier = Models::modelException;
        Pattern annotatedMembershipPredicatePattern = Pattern.compile("^" + vf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "_") + "[1-9][0-9]*$");
        RDFContainers.extract(containerType, statementSupplier, container, (Statement st) -> {
            if (RDFS.MEMBER.equals(st.getPredicate()) || annotatedMembershipPredicatePattern.matcher(st.getPredicate().toString()).matches()) {
                consumer.accept(st.getObject());
            }
        }, exceptionSupplier, contexts);
    }

    public static <C extends Collection<Statement>> C getContainer(IRI containerType, Model sourceModel, Resource container, C sink, Resource ... contexts) {
        Objects.requireNonNull(sourceModel, "input model may not be null");
        RDFContainers.extract(containerType, sourceModel, container, (Statement st) -> sink.add(st), contexts);
        return sink;
    }

    public static void extract(IRI containerType, Model sourceModel, Resource container, Consumer<Statement> consumer, Resource ... contexts) {
        Objects.requireNonNull(sourceModel, "source model may not be null");
        GetStatementOptional statementSupplier = (s2, p, o, c) -> sourceModel.filter(s2, p, o, c).stream().findAny();
        RDFContainers.extract(containerType, statementSupplier, container, consumer, Models::modelException, contexts);
    }

    public static <E extends RDF4JException> void extract(IRI containerType, GetStatementOptional statementSupplier, Resource container, Consumer<Statement> collectionConsumer, Function<String, Supplier<E>> exceptionSupplier, Resource ... contexts) throws E {
        IRI annotatedMembershipPredicate;
        OpenRDFUtil.verifyContextNotNull(contexts);
        Objects.requireNonNull(container, "containter head may not be null");
        Objects.requireNonNull(collectionConsumer, "collection consumer may not be null");
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        Resource current = container;
        int annotatedMembershipPropertyCounter = 1;
        while (!statementSupplier.get(container, annotatedMembershipPredicate = RDFContainers.getAnnotatedMemberPredicate(vf, annotatedMembershipPropertyCounter), null, contexts).equals(Optional.empty())) {
            Statement statement = statementSupplier.get(container, annotatedMembershipPredicate, null, contexts).get();
            collectionConsumer.accept(statement);
            ++annotatedMembershipPropertyCounter;
        }
    }
}

