/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CheckedInputStream;
import org.eclipse.rdf4j.common.io.UncloseableInputStream;
import org.eclipse.rdf4j.rio.hdt.CRC32;
import org.eclipse.rdf4j.rio.hdt.HDTArray;

class HDTArrayLog64
extends HDTArray {
    private byte[] buffer;

    HDTArrayLog64() {
    }

    @Override
    protected int getType() {
        return HDTArray.Type.LOG64.getValue();
    }

    @Override
    protected int get(int i) {
        int bytePos = i * this.nrbits / 8;
        int bitPos = i * this.nrbits % 8;
        int tmplen = (bitPos + this.nrbits + 7) / 8;
        long val = 0L;
        for (int j = 0; j < tmplen; ++j) {
            val |= ((long)this.buffer[bytePos + j] & 0xFFL) << j * 8;
        }
        val >>= bitPos;
        return (int)(val &= -1L >>> 64 - this.nrbits);
    }

    @Override
    protected void parse(InputStream is) throws IOException {
        super.parse(is);
        try (UncloseableInputStream uis = new UncloseableInputStream(is);
             CheckedInputStream cis = new CheckedInputStream(uis, new CRC32());){
            long bytes = (this.nrbits * this.entries + 7) / 8;
            if (bytes > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Maximum number of bytes in array exceeded: " + bytes);
            }
            this.buffer = new byte[(int)bytes];
            cis.read(this.buffer);
            HDTArrayLog64.checkCRC(cis, is, 4);
        }
    }
}

