/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CheckedInputStream;
import org.eclipse.rdf4j.common.io.UncloseableInputStream;
import org.eclipse.rdf4j.rio.hdt.CRC32;
import org.eclipse.rdf4j.rio.hdt.CRC8;
import org.eclipse.rdf4j.rio.hdt.HDTPart;
import org.eclipse.rdf4j.rio.hdt.VByte;

class HDTBitmap
extends HDTPart {
    protected static final int BITMAP1 = 1;
    private int bits;
    private byte[] buffer;

    HDTBitmap() {
    }

    protected int get(int i) {
        int bytePos = i / 8;
        int bitPos = i % 8;
        byte b = this.buffer[bytePos];
        return (b & 0xFF) >> bitPos & 1;
    }

    protected int size() {
        return this.bits;
    }

    @Override
    protected void parse(InputStream is) throws IOException {
        Throwable throwable;
        CheckedInputStream cis;
        long bytes = 0L;
        try (UncloseableInputStream uis = new UncloseableInputStream(is);){
            cis = new CheckedInputStream(uis, new CRC8());
            throwable = null;
            try {
                int dtype = cis.read();
                if (dtype != 1) {
                    throw new UnsupportedOperationException("Bitmap encoding " + Long.toHexString(dtype) + ", but only bitmap v1 is supported");
                }
                long b = (int)VByte.decode(cis);
                if (b > Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Maximum number of entries in bitmap exceeded: " + b);
                }
                this.bits = (int)b;
                bytes = (this.bits + 7) / 8;
                HDTBitmap.checkCRC(cis, is, 1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cis != null) {
                    if (throwable != null) {
                        try {
                            cis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cis.close();
                    }
                }
            }
        }
        uis = new UncloseableInputStream(is);
        var5_4 = null;
        try {
            cis = new CheckedInputStream(uis, new CRC32());
            throwable = null;
            try {
                this.buffer = new byte[(int)bytes];
                cis.read(this.buffer);
                HDTBitmap.checkCRC(cis, is, 4);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (cis != null) {
                    if (throwable != null) {
                        try {
                            cis.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        cis.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var5_4 = throwable6;
            throw throwable6;
        }
        finally {
            if (uis != null) {
                if (var5_4 != null) {
                    try {
                        uis.close();
                    }
                    catch (Throwable throwable7) {
                        var5_4.addSuppressed(throwable7);
                    }
                } else {
                    uis.close();
                }
            }
        }
    }
}

