/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CheckedInputStream;
import org.eclipse.rdf4j.common.io.UncloseableInputStream;
import org.eclipse.rdf4j.rio.hdt.CRC32;
import org.eclipse.rdf4j.rio.hdt.CRC8;
import org.eclipse.rdf4j.rio.hdt.HDTArray;
import org.eclipse.rdf4j.rio.hdt.HDTArrayFactory;
import org.eclipse.rdf4j.rio.hdt.HDTDictionarySection;
import org.eclipse.rdf4j.rio.hdt.HDTPart;
import org.eclipse.rdf4j.rio.hdt.VByte;

class HDTDictionarySectionPFC
extends HDTDictionarySection {
    private byte[] buffer;
    private int totalStrings;
    private int stringsBlock;
    private HDTArray blockStarts;
    private final LinkedHashMap<Integer, ArrayList<byte[]>> cache = new LinkedHashMap<Integer, ArrayList<byte[]>>(100, 1.0f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 99;
        }
    };

    protected HDTDictionarySectionPFC(String name, long pos) {
        super(name, pos);
    }

    @Override
    protected int size() {
        return this.totalStrings;
    }

    @Override
    protected byte[] get(int i) throws IOException {
        int idx = i - 1;
        int block = idx / this.stringsBlock;
        ArrayList<byte[]> strings = this.cache.get(block);
        if (strings == null) {
            int blockStart = this.blockStarts.get(block);
            strings = this.decodeBlock(block, blockStart);
            this.cache.put(block, strings);
        }
        return strings.get(idx - block * this.stringsBlock);
    }

    @Override
    protected void parse(InputStream is) throws IOException {
        int buflen;
        Throwable throwable;
        CheckedInputStream cis;
        CRC8 crc8 = new CRC8();
        crc8.update((byte)HDTDictionarySection.Type.FRONT.getValue());
        try (UncloseableInputStream uis = new UncloseableInputStream(is);){
            cis = new CheckedInputStream(uis, crc8);
            throwable = null;
            try {
                long val = VByte.decode(cis);
                if (this.totalStrings > Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException(this.getDebugPartStr() + " max number of strings exceeded: " + val);
                }
                this.totalStrings = (int)val;
                val = VByte.decode(cis);
                if (val > Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException(this.getDebugPartStr() + " max buffer length exceeded: " + val);
                }
                buflen = (int)val;
                val = VByte.decode(cis);
                if (val > Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException(this.getDebugPartStr() + "max number of strings per exceeded: " + val);
                }
                this.stringsBlock = (int)val;
                HDTDictionarySectionPFC.checkCRC(cis, is, 1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cis != null) {
                    if (throwable != null) {
                        try {
                            cis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cis.close();
                    }
                }
            }
        }
        this.blockStarts = HDTArrayFactory.parse(is);
        this.blockStarts.parse(is);
        uis = new UncloseableInputStream(is);
        var5_4 = null;
        try {
            cis = new CheckedInputStream(uis, new CRC32());
            throwable = null;
            try {
                this.buffer = new byte[buflen];
                cis.read(this.buffer);
                HDTDictionarySectionPFC.checkCRC(cis, is, 4);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (cis != null) {
                    if (throwable != null) {
                        try {
                            cis.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        cis.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var5_4 = throwable6;
            throw throwable6;
        }
        finally {
            if (uis != null) {
                if (var5_4 != null) {
                    try {
                        uis.close();
                    }
                    catch (Throwable throwable7) {
                        var5_4.addSuppressed(throwable7);
                    }
                } else {
                    uis.close();
                }
            }
        }
    }

    private ArrayList<byte[]> decodeBlock(int block, int start) throws IOException {
        ArrayList<byte[]> arr = new ArrayList<byte[]>(this.stringsBlock);
        int idx = start;
        int end = HDTPart.countToNull(this.buffer, idx);
        byte[] str = Arrays.copyOfRange(this.buffer, idx, end);
        arr.add(str);
        idx = end + 1;
        int remaining = this.totalStrings - block * this.stringsBlock;
        for (int j = 1; j < this.stringsBlock && j < remaining; ++j) {
            int common = (int)VByte.decodeFrom(this.buffer, idx);
            end = HDTPart.countToNull(this.buffer, idx += VByte.encodedLength(common));
            byte[] suffix = Arrays.copyOfRange(this.buffer, idx, end);
            str = Arrays.copyOf(str, common + suffix.length);
            System.arraycopy(suffix, 0, str, common, suffix.length);
            arr.add(str);
            idx = end + 1;
        }
        return arr;
    }
}

