/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.CheckedInputStream;
import org.eclipse.rdf4j.common.io.UncloseableInputStream;
import org.eclipse.rdf4j.rio.hdt.CRC16;
import org.eclipse.rdf4j.rio.hdt.HDTPart;

class HDTGlobal
extends HDTPart {
    protected static final byte[] GLOBAL_FORMAT = "<http://purl.org/HDT/hdt#HDTv1>".getBytes(StandardCharsets.US_ASCII);
    protected static final String GLOBAL_BASEURI = "BaseUri";
    protected static final String GLOBAL_SOFTWARE = "Software";

    HDTGlobal() {
    }

    @Override
    protected void parse(InputStream is) throws IOException {
        try (UncloseableInputStream uis = new UncloseableInputStream(is);
             CheckedInputStream cis = new CheckedInputStream(uis, new CRC16());){
            HDTGlobal.checkControl(cis, HDTPart.Type.GLOBAL);
            HDTGlobal.checkFormat(cis, GLOBAL_FORMAT);
            this.properties = HDTGlobal.getProperties(cis);
            HDTGlobal.checkCRC(cis, is, 2);
        }
    }
}

