/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.hdt;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rdf4j.rio.hdt.HDTArray;
import org.eclipse.rdf4j.rio.hdt.HDTArrayFactory;
import org.eclipse.rdf4j.rio.hdt.HDTBitmap;
import org.eclipse.rdf4j.rio.hdt.HDTTriples;
import org.eclipse.rdf4j.rio.hdt.HDTTriplesSection;

class HDTTriplesSectionBitmap
extends HDTTriplesSection {
    private HDTBitmap bitmapY;
    private HDTBitmap bitmapZ;
    private HDTArray arrY;
    private HDTArray arrZ;
    private int sizeY = 0;
    private int sizeZ = 0;
    private int posX = 1;
    private int posY = 0;
    private int posZ = 0;

    HDTTriplesSectionBitmap() {
    }

    @Override
    public boolean hasNext() {
        return this.posZ < this.sizeZ;
    }

    @Override
    public int[] next() {
        int z = this.arrZ.get(this.posZ);
        int y = this.arrY.get(this.posY);
        int x = this.posX++;
        if (this.bitmapZ.get(this.posZ) == 1 && this.posZ < this.sizeZ) {
            if (this.bitmapY.get(this.posY) != 1 || this.posY < this.sizeY) {
                // empty if block
            }
            ++this.posY;
        }
        ++this.posZ;
        return new int[]{x, y, z};
    }

    @Override
    protected void parse(InputStream is) throws IOException {
        this.parse(is, HDTTriples.Order.SPO);
    }

    @Override
    protected void parse(InputStream is, HDTTriples.Order order) throws IOException {
        this.bitmapY = new HDTBitmap();
        this.bitmapY.parse(is);
        this.sizeY = this.bitmapY.size();
        this.bitmapZ = new HDTBitmap();
        this.bitmapZ.parse(is);
        this.sizeZ = this.bitmapZ.size();
        this.arrY = HDTArrayFactory.parse(is);
        this.arrY.parse(is);
        this.arrZ = HDTArrayFactory.parse(is);
        this.arrZ.parse(is);
    }
}

