/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.obolibrary.macro.AbstractDataVisitorEx;
import org.obolibrary.macro.AbstractMacroExpansionVisitor;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroExpansionVisitor {
    protected static final Logger LOG = LoggerFactory.getLogger(MacroExpansionVisitor.class);
    protected final OWLOntology inputOntology;
    protected final OWLOntologyManager manager;
    protected final Visitor visitor;
    protected final AbstractDataVisitorEx dataVisitor;
    protected final boolean shouldAddExpansionMarker;
    protected boolean shouldTransferAnnotations = false;
    protected Set<OWLAnnotation> extraAnnotations;

    public MacroExpansionVisitor(OWLOntology ontology) {
        this(ontology, AbstractMacroExpansionVisitor.EMPTY_ANNOTATIONS, false, false);
    }

    public MacroExpansionVisitor(OWLOntology ontology, boolean shouldAddExpansionMarker) {
        this(ontology, AbstractMacroExpansionVisitor.EMPTY_ANNOTATIONS, false, shouldAddExpansionMarker);
    }

    public MacroExpansionVisitor(OWLOntology ontology, boolean shouldTransferAnnotations, boolean shouldAddExpansionMarker) {
        this(ontology, AbstractMacroExpansionVisitor.EMPTY_ANNOTATIONS, shouldTransferAnnotations, shouldAddExpansionMarker);
    }

    public MacroExpansionVisitor(OWLOntology inputOntology, Set<OWLAnnotation> extraAnnotations, boolean shouldTransferAnnotations, boolean shouldAddExpansionMarker) {
        this.inputOntology = inputOntology;
        this.extraAnnotations = extraAnnotations;
        this.shouldTransferAnnotations = shouldTransferAnnotations;
        this.shouldAddExpansionMarker = shouldAddExpansionMarker;
        this.visitor = new Visitor(inputOntology, shouldAddExpansionMarker);
        this.visitor.rebuild(inputOntology);
        this.manager = inputOntology.getOWLOntologyManager();
        this.dataVisitor = new AbstractDataVisitorEx(this.manager.getOWLDataFactory());
    }

    public MacroExpansions getMacroExpansions() {
        return new MacroExpansions();
    }

    public OWLOntology expandAll() {
        MacroExpansions macroExpansions = new MacroExpansions();
        Set<OWLAxiom> newAxioms = macroExpansions.getNewAxioms();
        Set<OWLAxiom> rmAxioms = macroExpansions.getRmAxioms();
        this.inputOntology.add(newAxioms);
        this.inputOntology.remove(rmAxioms);
        return this.inputOntology;
    }

    public boolean shouldTransferAnnotations() {
        return this.shouldTransferAnnotations;
    }

    public void setShouldTransferAnnotations(boolean shouldTransferAnnotations) {
        this.shouldTransferAnnotations = shouldTransferAnnotations;
    }

    public void dispose() {
        this.visitor.getTool().dispose();
    }

    private class Visitor
    extends AbstractMacroExpansionVisitor {
        Visitor(OWLOntology inputOntology, boolean shouldAddExpansionMarker) {
            super(inputOntology, shouldAddExpansionMarker);
            this.rangeVisitor = MacroExpansionVisitor.this.dataVisitor;
            this.classVisitor = new AbstractMacroExpansionVisitor.AbstractClassExpressionVisitorEx(){

                @Override
                @Nullable
                protected OWLClassExpression expandOWLObjSomeVal(OWLClassExpression filler, OWLObjectPropertyExpression p) {
                    return Visitor.this.expandObject(filler, p);
                }

                @Override
                @Nullable
                protected OWLClassExpression expandOWLObjHasVal(OWLObjectHasValue desc, OWLIndividual filler, OWLObjectPropertyExpression p) {
                    OWLClassExpression result = Visitor.this.expandObject(filler, p);
                    if (result != null) {
                        result = Visitor.this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), result);
                    }
                    return result;
                }
            };
        }
    }

    private class MacroExpansions {
        private final Set<OWLAxiom> newAxioms = new HashSet<OWLAxiom>();
        private final Set<OWLAxiom> rmAxioms = new HashSet<OWLAxiom>();

        public MacroExpansions() {
            MacroExpansionVisitor.this.inputOntology.axioms(AxiomType.SUBCLASS_OF).forEach(axiom -> {
                OWLAxiom newAxiom = axiom.accept(MacroExpansionVisitor.this.visitor);
                this.replaceIfDifferent((OWLAxiom)axiom, newAxiom);
            });
            MacroExpansionVisitor.this.inputOntology.axioms(AxiomType.EQUIVALENT_CLASSES).forEach(axiom -> {
                OWLAxiom newAxiom = axiom.accept(MacroExpansionVisitor.this.visitor);
                this.replaceIfDifferent((OWLAxiom)axiom, newAxiom);
            });
            MacroExpansionVisitor.this.inputOntology.axioms(AxiomType.CLASS_ASSERTION).forEach(axiom -> {
                OWLAxiom newAxiom = axiom.accept(MacroExpansionVisitor.this.visitor);
                this.replaceIfDifferent((OWLAxiom)axiom, newAxiom);
            });
            OWLAPIStreamUtils.add(this.rmAxioms, MacroExpansionVisitor.this.inputOntology.axioms(AxiomType.ANNOTATION_ASSERTION).filter(this::expand));
        }

        private void replaceIfDifferent(OWLAxiom ax, OWLAxiom exAx) {
            if (!ax.equals(exAx)) {
                this.newAxioms.add(exAx);
                this.rmAxioms.add(ax);
            }
        }

        public Set<OWLAxiom> getNewAxioms() {
            return this.newAxioms;
        }

        public Set<OWLAxiom> getRmAxioms() {
            return this.rmAxioms;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean expand(OWLAnnotationAssertionAxiom axiom) {
            OWLAnnotationProperty prop = (OWLAnnotationProperty)axiom.getProperty();
            String expandTo = (String)MacroExpansionVisitor.this.visitor.expandAssertionToMap.get(prop.getIRI());
            HashSet<OWLDeclarationAxiom> declarations = new HashSet<OWLDeclarationAxiom>();
            AtomicBoolean expandedSomething = new AtomicBoolean(false);
            try {
                if (expandTo != null) {
                    IRI axValIRI;
                    OWLDataFactory dataFactory;
                    OWLClass axValClass;
                    HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>(MacroExpansionVisitor.this.extraAnnotations);
                    if (MacroExpansionVisitor.this.shouldAddExpansionMarker) {
                        annotations.add(MacroExpansionVisitor.this.visitor.getExpansionMarkerAnnotation());
                    }
                    if (MacroExpansionVisitor.this.shouldTransferAnnotations()) {
                        OWLAPIStreamUtils.add(annotations, axiom.annotations());
                    }
                    if (OWLAPIStreamUtils.asList(MacroExpansionVisitor.this.inputOntology.declarationAxioms(axValClass = (dataFactory = MacroExpansionVisitor.this.visitor.df).getOWLClass(axValIRI = (IRI)axiom.getValue()))).isEmpty()) {
                        OWLDeclarationAxiom declarationAxiom = dataFactory.getOWLDeclarationAxiom(axValClass, annotations);
                        declarations.add(declarationAxiom);
                        this.newAxioms.add(declarationAxiom);
                        MacroExpansionVisitor.this.manager.addAxiom(MacroExpansionVisitor.this.inputOntology, declarationAxiom);
                        MacroExpansionVisitor.this.visitor.rebuild(MacroExpansionVisitor.this.inputOntology);
                    }
                    LOG.info("Template to Expand {}", (Object)expandTo);
                    expandTo = expandTo.replaceAll("\\?X", MacroExpansionVisitor.this.visitor.getTool().getId((IRI)axiom.getSubject()));
                    expandTo = expandTo.replaceAll("\\?Y", MacroExpansionVisitor.this.visitor.getTool().getId(axValIRI));
                    LOG.info("Expanding {}", (Object)expandTo);
                    try {
                        this.expandAndAddAnnotations(expandTo, expandedSomething, annotations);
                    }
                    catch (Exception ex) {
                        LOG.error(ex.getMessage(), ex);
                    }
                }
            }
            finally {
                MacroExpansionVisitor.this.inputOntology.remove(declarations);
            }
            return expandedSomething.get();
        }

        protected void expandAndAddAnnotations(String expandTo, AtomicBoolean expandedSomething, Set<OWLAnnotation> annotations) {
            MacroExpansionVisitor.this.visitor.getTool().parseManchesterExpressionFrames(expandTo).stream().map(axp -> axp.getAxiom()).map(ax -> MacroExpansionVisitor.this.shouldTransferAnnotations() ? ax.getAnnotatedAxiom(annotations) : ax).forEach(expandedAxiom -> {
                this.newAxioms.add((OWLAxiom)expandedAxiom);
                expandedSomething.set(true);
            });
        }
    }
}

