/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.functional.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.AsOWLAnnotationProperty;
import org.semanticweb.owlapi.model.AsOWLClass;
import org.semanticweb.owlapi.model.AsOWLDataProperty;
import org.semanticweb.owlapi.model.AsOWLDatatype;
import org.semanticweb.owlapi.model.AsOWLObjectProperty;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLQuantifiedDataRestriction;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.ShortFormFromRDFSLabelAxiomListProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

public class FunctionalSyntaxObjectRenderer
implements OWLObjectVisitor {
    protected final Optional<OWLOntology> ont;
    private final Writer writer;
    private DefaultPrefixManager defaultPrefixManager;
    protected Optional<ShortFormProvider> labelMaker = Optional.empty();
    private Optional<PrefixManager> prefixManager = Optional.empty();
    private boolean writeEntitiesAsURIs = true;
    private boolean addMissingDeclarations = true;

    protected Stream<? extends OWLAxiom> retrieve(OWLEntity e, OWLOntology o) {
        if (e.isOWLClass()) {
            return o.axioms((OWLClass)e, Imports.EXCLUDED);
        }
        if (e.isOWLObjectProperty()) {
            return o.axioms((OWLObjectProperty)e, Imports.EXCLUDED);
        }
        if (e.isOWLDataProperty()) {
            return o.axioms((OWLDataProperty)e, Imports.EXCLUDED);
        }
        if (e.isOWLNamedIndividual()) {
            return o.axioms((OWLNamedIndividual)e, Imports.EXCLUDED);
        }
        if (e.isOWLDatatype()) {
            return o.axioms((OWLDatatype)e, Imports.EXCLUDED);
        }
        if (e.isOWLAnnotationProperty()) {
            return o.axioms((OWLAnnotationProperty)e, Imports.EXCLUDED);
        }
        return Stream.empty();
    }

    public FunctionalSyntaxObjectRenderer(@Nullable OWLOntology ontology, Writer writer) {
        this.ont = Optional.ofNullable(ontology);
        this.writer = writer;
        this.defaultPrefixManager = new DefaultPrefixManager();
        this.ont.ifPresent(o -> {
            OWLDocumentFormat ontologyFormat = o.getNonnullFormat();
            this.addMissingDeclarations = ontologyFormat.isAddMissingTypes();
            if (ontologyFormat instanceof PrefixDocumentFormat) {
                this.prefixManager = Optional.of(new DefaultPrefixManager());
                this.prefixManager.get().copyPrefixesFrom((PrefixDocumentFormat)ontologyFormat);
                this.prefixManager.get().setPrefixComparator(((PrefixDocumentFormat)ontologyFormat).getPrefixComparator());
                if (!o.isAnonymous() && this.prefixManager.get().getDefaultPrefix() == null) {
                    this.prefixManager.get().setDefaultPrefix(XMLUtils.iriWithTerminatingHash(o.getOntologyID().getOntologyIRI().get().toString()));
                }
            }
            OWLOntologyManager manager = o.getOWLOntologyManager();
            OWLDataFactory df = manager.getOWLDataFactory();
            this.labelMaker = Optional.of(new AnnotationValueShortFormProvider(Collections.singletonList(df.getRDFSLabel()), Collections.emptyMap(), manager, this.defaultPrefixManager));
        });
    }

    public void setAddMissingDeclarations(boolean flag) {
        this.addMissingDeclarations = flag;
    }

    public void setPrefixManager(PrefixManager prefixManager) {
        this.prefixManager = Optional.ofNullable(prefixManager);
        if (prefixManager instanceof DefaultPrefixManager) {
            this.defaultPrefixManager = (DefaultPrefixManager)prefixManager;
        }
    }

    protected void writePrefix(String prefix, String namespace) {
        this.write("Prefix");
        this.writeOpenBracket();
        this.write(prefix);
        this.write("=");
        this.write("<");
        this.write(namespace);
        this.write(">");
        this.writeCloseBracket();
        this.writeReturn();
    }

    protected void writePrefixes() {
        this.prefixManager.ifPresent(p -> p.getPrefixName2PrefixMap().forEach(this::writePrefix));
    }

    private void write(OWLXMLVocabulary v) {
        this.write(v.getShortForm());
    }

    private void write(String s2) {
        try {
            this.writer.write(s2);
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void write(IRI iri) {
        String qname = this.prefixManager.map(p -> p.getPrefixIRIIgnoreQName(iri)).orElse(null);
        if (qname != null) {
            boolean lastCharIsColon;
            boolean bl = lastCharIsColon = qname.charAt(qname.length() - 1) == ':';
            if (!lastCharIsColon) {
                this.write(qname);
                return;
            }
        }
        this.writeFullIRI(iri);
    }

    private void writeFullIRI(IRI iri) {
        this.write("<");
        this.write(iri.toString());
        this.write(">");
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.writePrefixes();
        this.writeReturn();
        this.writeReturn();
        this.write(OWLXMLVocabulary.ONTOLOGY);
        this.writeOpenBracket();
        if (!ontology.isAnonymous()) {
            this.writeFullIRI(ontology.getOntologyID().getOntologyIRI().get());
            Optional<IRI> versionIRI = ontology.getOntologyID().getVersionIRI();
            if (versionIRI.isPresent()) {
                this.writeReturn();
                this.writeFullIRI(versionIRI.get());
            }
            this.writeReturn();
        }
        ontology.importsDeclarations().forEach(decl -> {
            this.write(OWLXMLVocabulary.IMPORT);
            this.writeOpenBracket();
            this.writeFullIRI(decl.getIRI());
            this.writeCloseBracket();
            this.writeReturn();
        });
        ontology.annotations().forEach(this::acceptAndReturn);
        this.writeReturn();
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        Collection<IRI> illegals = OWLDocumentFormat.determineIllegalPunnings(this.addMissingDeclarations, ontology.unsortedSignature(), ontology.getPunnedIRIs(Imports.INCLUDED));
        ontology.signature().forEach(e -> this.writeDeclarations((OWLEntity)e, (Set<OWLAxiom>)writtenAxioms, illegals));
        this.writeSortedEntities("Annotation Properties", "Annotation Property", ontology.annotationPropertiesInSignature(Imports.EXCLUDED), writtenAxioms);
        this.writeSortedEntities("Object Properties", "Object Property", ontology.objectPropertiesInSignature(Imports.EXCLUDED), writtenAxioms);
        this.writeSortedEntities("Data Properties", "Data Property", ontology.dataPropertiesInSignature(Imports.EXCLUDED), writtenAxioms);
        this.writeSortedEntities("Datatypes", "Datatype", ontology.datatypesInSignature(Imports.EXCLUDED), writtenAxioms);
        this.writeSortedEntities("Classes", "Class", ontology.classesInSignature(Imports.EXCLUDED), writtenAxioms);
        this.writeSortedEntities("Named Individuals", "Individual", ontology.individualsInSignature(Imports.EXCLUDED), writtenAxioms);
        ontology.signature().forEach(e -> this.writeAxioms((OWLEntity)e, (Set<OWLAxiom>)writtenAxioms));
        ontology.axioms().filter(ax -> !writtenAxioms.contains(ax)).sorted().forEach(this::acceptAndReturn);
        this.writeCloseBracket();
        this.flush();
    }

    public String renderAxioms(Collection<OWLAxiom> axioms) {
        this.writePrefixes();
        this.writeReturn();
        this.writeReturn();
        this.write(OWLXMLVocabulary.ONTOLOGY);
        this.writeOpenBracket();
        this.writeReturn();
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        Set<OWLEntity> signature = OWLAPIStreamUtils.asSet(axioms.stream().flatMap(HasSignature::signature));
        Collection<IRI> illegals = FunctionalSyntaxObjectRenderer.illegalPunnings(this.addMissingDeclarations, signature);
        signature.forEach(e -> this.writeDeclarations((OWLEntity)e, (Set<OWLAxiom>)writtenAxioms, illegals));
        Function<IRI, Stream<OWLAnnotationAssertionAxiom>> o = this.annotations(axioms);
        this.writeSortedEntities(o, "Annotation Properties", "Annotation Property", signature.stream().filter(AsOWLAnnotationProperty::isOWLAnnotationProperty), writtenAxioms);
        this.writeSortedEntities(o, "Object Properties", "Object Property", signature.stream().filter(AsOWLObjectProperty::isOWLObjectProperty), writtenAxioms);
        this.writeSortedEntities(o, "Data Properties", "Data Property", signature.stream().filter(AsOWLDataProperty::isOWLDataProperty), writtenAxioms);
        this.writeSortedEntities(o, "Datatypes", "Datatype", signature.stream().filter(AsOWLDatatype::isOWLDatatype), writtenAxioms);
        this.writeSortedEntities(o, "Classes", "Class", signature.stream().filter(AsOWLClass::isOWLClass), writtenAxioms);
        this.writeSortedEntities(o, "Named Individuals", "Individual", signature.stream().filter(OWLObject::isIndividual), writtenAxioms);
        signature.forEach(e -> this.writeAxioms((OWLEntity)e, (Set<OWLAxiom>)writtenAxioms));
        axioms.stream().filter(ax -> !writtenAxioms.contains(ax)).sorted().forEach(this::acceptAndReturn);
        this.writeCloseBracket();
        try {
            this.writer.flush();
        }
        catch (IOException e1) {
            throw new OWLRuntimeException(e1);
        }
        return this.writer.toString();
    }

    static Collection<IRI> illegalPunnings(boolean add, Collection<OWLEntity> signature) {
        if (!add) {
            return Collections.emptySet();
        }
        HashMap punnings = new HashMap();
        Set<IRI> punnedEntities = FunctionalSyntaxObjectRenderer.getPunnedIRIs(signature.stream().distinct());
        signature.stream().distinct().filter(e -> !e.isOWLNamedIndividual() && punnedEntities.contains(e.getIRI())).forEach(e -> punnings.computeIfAbsent(e.getIRI(), x -> new ArrayList()).add(e.getEntityType()));
        return FunctionalSyntaxObjectRenderer.computeIllegals(punnings);
    }

    static Collection<IRI> computeIllegals(Map<IRI, List<EntityType<?>>> punnings) {
        HashSet<IRI> illegals = new HashSet<IRI>();
        punnings.forEach((i, puns) -> FunctionalSyntaxObjectRenderer.computeIllegal(illegals, i, puns));
        return illegals;
    }

    static void computeIllegal(Collection<IRI> illegals, IRI i, List<EntityType<?>> puns) {
        boolean hasObject = puns.contains(EntityType.OBJECT_PROPERTY);
        boolean hasAnnotation = puns.contains(EntityType.ANNOTATION_PROPERTY);
        boolean hasData = puns.contains(EntityType.DATA_PROPERTY);
        if (hasObject && hasAnnotation || hasData && hasAnnotation || hasData && hasObject || puns.contains(EntityType.DATATYPE) && puns.contains(EntityType.CLASS)) {
            illegals.add(i);
        }
    }

    static Set<IRI> getPunnedIRIs(Stream<OWLEntity> signature) {
        HashSet<IRI> punned = new HashSet<IRI>();
        HashSet test = new HashSet();
        Predicate<IRI> tested = e -> !test.add(e);
        signature.map(HasIRI::getIRI).filter(tested).forEach(punned::add);
        if (punned.isEmpty()) {
            return Collections.emptySet();
        }
        return punned;
    }

    protected Function<IRI, Stream<OWLAnnotationAssertionAxiom>> annotations(Collection<OWLAxiom> axioms) {
        return x -> axioms.stream().filter(ax -> this.annotations((OWLAxiom)ax, (IRI)x)).map(OWLAnnotationAssertionAxiom.class::cast);
    }

    boolean annotations(OWLAxiom ax, IRI i) {
        return ax instanceof OWLAnnotationAssertionAxiom && ((OWLAnnotationSubject)((OWLAnnotationAssertionAxiom)ax).getSubject()).equals(i);
    }

    private void writeSortedEntities(String bannerComment, String entityTypeName, Stream<? extends OWLEntity> entities, Set<OWLAxiom> writtenAxioms) {
        List<? extends OWLEntity> sortOptionally = OWLAPIStreamUtils.asList(entities.sorted());
        if (!sortOptionally.isEmpty()) {
            this.writeEntities(bannerComment, entityTypeName, sortOptionally, writtenAxioms);
            this.writeReturn();
        }
    }

    private void writeln(String s2) {
        this.write(s2);
        this.writeReturn();
    }

    private void writeEntities(String comment, String entityTypeName, List<? extends OWLEntity> entities, Set<OWLAxiom> writtenAxioms) {
        boolean haveWrittenBanner = false;
        for (OWLEntity oWLEntity : entities) {
            List<OWLAxiom> axiomsForEntity = OWLAPIStreamUtils.asList(this.retrieve(oWLEntity).filter(ax -> !writtenAxioms.contains(ax)));
            List<OWLAnnotationAssertionAxiom> list = OWLAPIStreamUtils.asList(this.ont.map(o -> o.annotationAssertionAxioms(owlEntity.getIRI()).filter(ax -> !writtenAxioms.contains(ax))).orElse(Stream.empty()));
            if (axiomsForEntity.isEmpty() && list.isEmpty()) continue;
            if (!haveWrittenBanner) {
                this.writeln("############################");
                this.writeln("#   " + comment);
                this.writeln("############################");
                this.writeReturn();
                haveWrittenBanner = true;
            }
            axiomsForEntity.sort(null);
            list.sort(null);
            this.writeEntity2(oWLEntity, entityTypeName, axiomsForEntity, list, writtenAxioms);
        }
    }

    private void writeSortedEntities(Function<IRI, Stream<OWLAnnotationAssertionAxiom>> annotations, String bannerComment, String entityTypeName, Stream<? extends OWLEntity> entities, Set<OWLAxiom> writtenAxioms) {
        List<? extends OWLEntity> sortOptionally = OWLAPIStreamUtils.asList(entities.sorted());
        if (!sortOptionally.isEmpty()) {
            this.writeEntities(annotations, bannerComment, entityTypeName, sortOptionally, writtenAxioms);
            this.writeReturn();
        }
    }

    private void writeEntities(Function<IRI, Stream<OWLAnnotationAssertionAxiom>> annotations, String comment, String entityTypeName, List<? extends OWLEntity> entities, Set<OWLAxiom> writtenAxioms) {
        boolean haveWrittenBanner = false;
        for (OWLEntity oWLEntity : entities) {
            List<OWLAxiom> axiomsForEntity = OWLAPIStreamUtils.asList(this.retrieve(oWLEntity).filter(ax -> !writtenAxioms.contains(ax)));
            List<OWLAnnotationAssertionAxiom> list = OWLAPIStreamUtils.asList(annotations.apply(oWLEntity.getIRI()).filter(ax -> !writtenAxioms.contains(ax)));
            if (axiomsForEntity.isEmpty() && list.isEmpty()) continue;
            if (!haveWrittenBanner) {
                this.write("############################\n#   " + comment + "\n############################\n\n");
                haveWrittenBanner = true;
            }
            axiomsForEntity.sort(null);
            list.sort(null);
            this.writeEntity2(oWLEntity, entityTypeName, axiomsForEntity, list, writtenAxioms);
        }
    }

    private Stream<? extends OWLAxiom> retrieve(OWLEntity entity) {
        return this.ont.map(o -> this.retrieve(entity, (OWLOntology)o)).orElse(Stream.empty());
    }

    protected Set<OWLAxiom> writeAxioms(OWLEntity entity) {
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        this.writeAxioms(entity, writtenAxioms);
        return writtenAxioms;
    }

    protected Set<OWLAxiom> writeEntity(OWLEntity entity) {
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        this.writeEntity(entity, writtenAxioms);
        return writtenAxioms;
    }

    protected void writeEntity(OWLEntity entity, Set<OWLAxiom> alreadyWrittenAxioms) {
        this.writeEntity2(entity, "", OWLAPIStreamUtils.asList(this.retrieve(entity).sorted()), OWLAPIStreamUtils.asList(this.ont.map(o -> o.annotationAssertionAxioms(entity.getIRI()).sorted()).orElse(Stream.empty())), alreadyWrittenAxioms);
    }

    protected void writeEntity2(OWLEntity entity, String entityTypeName, List<? extends OWLAxiom> axiomsForEntity, List<OWLAnnotationAssertionAxiom> annotationAssertionAxioms, Set<OWLAxiom> alreadyWrittenAxioms) {
        this.writeln("# " + entityTypeName + ": " + this.getIRIString(entity) + " (" + this.getEntityLabel(entity, annotationAssertionAxioms) + ")");
        this.writeReturn();
        annotationAssertionAxioms.stream().filter(alreadyWrittenAxioms::add).forEach(this::acceptAndReturn);
        axiomsForEntity.stream().filter(this::shouldWrite).filter(alreadyWrittenAxioms::add).forEach(this::acceptAndReturn);
        this.writeReturn();
    }

    private boolean shouldWrite(OWLAxiom ax) {
        if (ax.getAxiomType().equals(AxiomType.DIFFERENT_INDIVIDUALS)) {
            return false;
        }
        return !ax.getAxiomType().equals(AxiomType.DISJOINT_CLASSES) || ((OWLDisjointClassesAxiom)ax).classExpressions().count() <= 2L;
    }

    private String getIRIString(OWLEntity entity) {
        return this.defaultPrefixManager.getShortForm(entity);
    }

    private String getEntityLabel(OWLEntity entity, List<OWLAnnotationAssertionAxiom> axioms) {
        if (this.labelMaker.isPresent()) {
            return this.labelMaker.get().getShortForm(entity).replace("\n", "\n# ");
        }
        this.labelMaker = Optional.of(new ShortFormFromRDFSLabelAxiomListProvider(Collections.emptyList(), axioms));
        return this.labelMaker.get().getShortForm(entity).replace("\n", "\n# ");
    }

    private void writeAxioms(OWLEntity entity, Set<OWLAxiom> alreadyWrittenAxioms) {
        this.writeAnnotations(entity, alreadyWrittenAxioms);
        ArrayList writtenAxioms = new ArrayList();
        Stream<OWLAxiom> stream = this.retrieve(entity).filter(alreadyWrittenAxioms::contains).filter(ax -> ax.getAxiomType().equals(AxiomType.DIFFERENT_INDIVIDUALS)).filter(ax -> ax.getAxiomType().equals(AxiomType.DISJOINT_CLASSES) && ((OWLDisjointClassesAxiom)ax).classExpressions().count() > 2L).sorted();
        stream.forEach(ax -> {
            ax.accept(this);
            writtenAxioms.add(ax);
            this.writeReturn();
        });
        alreadyWrittenAxioms.addAll(writtenAxioms);
    }

    protected Set<OWLAxiom> writeDeclarations(OWLEntity entity) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        this.ont.map(o -> o.declarationAxioms(entity).sorted()).orElse(Stream.empty()).forEach(ax -> {
            ax.accept(this);
            axioms.add((OWLAxiom)ax);
            this.writeReturn();
        });
        return axioms;
    }

    private void writeDeclarations(OWLEntity entity, Set<OWLAxiom> alreadyWrittenAxioms, Collection<IRI> illegals) {
        this.ont.ifPresent(o -> {
            List<OWLDeclarationAxiom> axioms = OWLAPIStreamUtils.asList(o.declarationAxioms(entity).sorted());
            axioms.stream().filter(alreadyWrittenAxioms::add).forEach(this::acceptAndReturn);
            if (this.addMissingDeclarations && axioms.isEmpty() && !entity.isBuiltIn() && !illegals.contains(entity.getIRI()) && !o.isDeclared(entity, Imports.INCLUDED)) {
                OWLDeclarationAxiom declaration = o.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom(entity);
                this.acceptAndReturn(declaration);
            }
        });
    }

    protected void acceptAndReturn(OWLObject ax) {
        ax.accept(this);
        this.writeReturn();
    }

    protected void acceptAndSpace(OWLObject ax) {
        ax.accept(this);
        this.writeSpace();
    }

    protected void spaceAndAccept(OWLObject ax) {
        this.writeSpace();
        ax.accept(this);
    }

    protected void writeAnnotations(OWLEntity entity, Set<OWLAxiom> alreadyWrittenAxioms) {
        this.ont.ifPresent(o -> o.annotationAssertionAxioms(entity.getIRI()).sorted().filter(alreadyWrittenAxioms::add).forEach(this::acceptAndReturn));
    }

    protected void write(OWLXMLVocabulary v, OWLObject o) {
        this.write(v);
        this.writeOpenBracket();
        o.accept(this);
        this.writeCloseBracket();
    }

    private void write(Stream<? extends OWLObject> objects) {
        this.write(OWLAPIStreamUtils.asList(objects));
    }

    private void write(List<? extends OWLObject> objects) {
        for (int i = 0; i < objects.size(); ++i) {
            if (i > 0) {
                this.writeSpace();
            }
            objects.get(i).accept(this);
        }
    }

    protected void writeOpenBracket() {
        this.write("(");
    }

    protected void writeCloseBracket() {
        this.write(")");
    }

    protected void writeSpace() {
        this.write(" ");
    }

    protected void writeReturn() {
        this.write("\n");
    }

    protected void writeAnnotations(OWLAxiom ax) {
        ax.annotations().forEach(this::acceptAndSpace);
    }

    protected void writeAxiomStart(OWLXMLVocabulary v, OWLAxiom axiom) {
        this.write(v);
        this.writeOpenBracket();
        this.writeAnnotations(axiom);
    }

    protected void writeAxiomEnd() {
        this.writeCloseBracket();
    }

    protected void writePropertyCharacteristic(OWLXMLVocabulary v, OWLAxiom ax, OWLPropertyExpression prop) {
        this.writeAxiomStart(v, ax);
        prop.accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.ASYMMETRIC_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.CLASS_ASSERTION, axiom);
        this.acceptAndSpace(axiom.getClassExpression());
        axiom.getIndividual().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_ASSERTION, axiom);
        this.acceptAndSpace(axiom.getProperty());
        this.acceptAndSpace(axiom.getSubject());
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_DOMAIN, axiom);
        this.acceptAndSpace((OWLObject)axiom.getProperty());
        ((OWLClassExpression)axiom.getDomain()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_RANGE, axiom);
        this.acceptAndSpace((OWLObject)axiom.getProperty());
        ((OWLDataRange)axiom.getRange()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_DATA_PROPERTY_OF, axiom);
        this.acceptAndSpace((OWLObject)axiom.getSubProperty());
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DECLARATION, axiom);
        this.writeEntitiesAsURIs = false;
        axiom.getEntity().accept(this);
        this.writeEntitiesAsURIs = true;
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        List<OWLIndividual> individuals = OWLAPIStreamUtils.asList(axiom.individuals());
        if (individuals.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS, axiom);
        this.write(individuals);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        List<OWLClassExpression> classExpressions = OWLAPIStreamUtils.asList(axiom.classExpressions());
        if (classExpressions.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_CLASSES, axiom);
        this.write(classExpressions);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        List properties = OWLAPIStreamUtils.asList(axiom.properties());
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_DATA_PROPERTIES, axiom);
        this.write(properties);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        List properties = OWLAPIStreamUtils.asList(axiom.properties());
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_OBJECT_PROPERTIES, axiom);
        this.write(properties);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_UNION, axiom);
        this.acceptAndSpace(axiom.getOWLClass());
        this.write(axiom.classExpressions());
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_ASSERTION, axiom);
        this.acceptAndSpace((OWLObject)axiom.getProperty());
        this.acceptAndSpace((OWLObject)axiom.getSubject());
        axiom.getValue().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        List<OWLClassExpression> classExpressions = OWLAPIStreamUtils.asList(axiom.classExpressions());
        if (classExpressions.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_CLASSES, axiom);
        this.write(classExpressions);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        List properties = OWLAPIStreamUtils.asList(axiom.properties());
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_DATA_PROPERTIES, axiom);
        this.write(properties);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        List properties = OWLAPIStreamUtils.asList(axiom.properties());
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_OBJECT_PROPERTIES, axiom);
        this.write(properties);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.FUNCTIONAL_DATA_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.FUNCTIONAL_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTIES, axiom);
        this.acceptAndSpace(axiom.getFirstProperty());
        axiom.getSecondProperty().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.IRREFLEXIVE_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.NEGATIVE_DATA_PROPERTY_ASSERTION, axiom);
        this.acceptAndSpace(axiom.getProperty());
        this.acceptAndSpace(axiom.getSubject());
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.NEGATIVE_OBJECT_PROPERTY_ASSERTION, axiom);
        this.acceptAndSpace(axiom.getProperty());
        this.acceptAndSpace(axiom.getSubject());
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_ASSERTION, axiom);
        this.acceptAndSpace(axiom.getProperty());
        this.acceptAndSpace(axiom.getSubject());
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF, axiom);
        this.write(OWLXMLVocabulary.OBJECT_PROPERTY_CHAIN);
        this.writeOpenBracket();
        this.write(axiom.getPropertyChain());
        this.writeCloseBracket();
        this.spaceAndAccept(axiom.getSuperProperty());
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_DOMAIN, axiom);
        this.acceptAndSpace((OWLObject)axiom.getProperty());
        ((OWLClassExpression)axiom.getDomain()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_RANGE, axiom);
        this.acceptAndSpace((OWLObject)axiom.getProperty());
        ((OWLClassExpression)axiom.getRange()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF, axiom);
        this.acceptAndSpace((OWLObject)axiom.getSubProperty());
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.REFLEXIVE_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        List<OWLIndividual> individuals = axiom.getIndividualsAsList();
        if (individuals.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.SAME_INDIVIDUAL, axiom);
        this.write(individuals);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_CLASS_OF, axiom);
        this.acceptAndSpace(axiom.getSubClass());
        axiom.getSuperClass().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.SYMMETRIC_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.TRANSITIVE_OBJECT_PROPERTY, axiom, (OWLPropertyExpression)axiom.getProperty());
    }

    @Override
    public void visit(OWLClass ce) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.CLASS);
            this.writeOpenBracket();
        }
        ce.getIRI().accept(this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    private <F extends OWLPropertyRange> void writeRestriction(OWLXMLVocabulary v, OWLCardinalityRestriction<F> restriction, OWLPropertyExpression p) {
        this.write(v);
        this.writeOpenBracket();
        this.write(Integer.toString(restriction.getCardinality()));
        this.spaceAndAccept(p);
        if (restriction.isQualified()) {
            this.spaceAndAccept((OWLObject)restriction.getFiller());
        }
        this.writeCloseBracket();
    }

    private void writeRestriction(OWLXMLVocabulary v, OWLQuantifiedDataRestriction restriction) {
        this.writeRestriction(v, restriction.getProperty(), (OWLObject)restriction.getFiller());
    }

    private void writeRestriction(OWLXMLVocabulary v, OWLQuantifiedObjectRestriction restriction) {
        this.writeRestriction(v, restriction.getProperty(), (OWLObject)restriction.getFiller());
    }

    private void writeRestriction(OWLXMLVocabulary v, OWLPropertyExpression prop, OWLObject filler) {
        this.write(v);
        this.writeOpenBracket();
        this.acceptAndSpace(prop);
        filler.accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_ALL_VALUES_FROM, ce);
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_EXACT_CARDINALITY, ce, ce.getProperty());
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_MAX_CARDINALITY, ce, ce.getProperty());
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_MIN_CARDINALITY, ce, ce.getProperty());
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_SOME_VALUES_FROM, ce);
    }

    @Override
    public void visit(OWLDataHasValue ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_HAS_VALUE, ce.getProperty(), (OWLObject)ce.getFiller());
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_ALL_VALUES_FROM, ce);
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.write(OWLXMLVocabulary.OBJECT_COMPLEMENT_OF, ce.getOperand());
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_EXACT_CARDINALITY, ce, ce.getProperty());
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        if (ce.operands().count() == 1L) {
            ce.operands().forEach(x -> x.accept(this));
            return;
        }
        this.write(OWLXMLVocabulary.OBJECT_INTERSECTION_OF);
        this.writeOpenBracket();
        this.write(ce.operands());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_MAX_CARDINALITY, ce, ce.getProperty());
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_MIN_CARDINALITY, ce, ce.getProperty());
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.write(OWLXMLVocabulary.OBJECT_ONE_OF);
        this.writeOpenBracket();
        this.write(ce.individuals());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        this.write(OWLXMLVocabulary.OBJECT_HAS_SELF, ce.getProperty());
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_SOME_VALUES_FROM, ce);
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        if (ce.operands().count() == 1L) {
            ce.operands().forEach(x -> x.accept(this));
            return;
        }
        this.write(OWLXMLVocabulary.OBJECT_UNION_OF);
        this.writeOpenBracket();
        this.write(ce.operands());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectHasValue ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_HAS_VALUE, ce.getProperty(), (OWLObject)ce.getFiller());
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.write(OWLXMLVocabulary.DATA_COMPLEMENT_OF, node.getDataRange());
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.write(OWLXMLVocabulary.DATA_ONE_OF);
        this.writeOpenBracket();
        this.write(node.values());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDatatype node) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.DATATYPE);
            this.writeOpenBracket();
        }
        node.getIRI().accept(this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.write(OWLXMLVocabulary.DATATYPE_RESTRICTION);
        this.writeOpenBracket();
        node.getDatatype().accept(this);
        node.facetRestrictions().forEach(this::spaceAndAccept);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.write(node.getFacet().getIRI());
        this.spaceAndAccept(node.getFacetValue());
    }

    @Override
    public void visit(OWLLiteral node) {
        this.write("\"");
        this.write(EscapeUtils.escapeString(node.getLiteral()));
        this.write("\"");
        if (node.hasLang()) {
            this.write("@");
            this.write(node.getLang());
        } else if (!node.isRDFPlainLiteral() && !OWL2Datatype.XSD_STRING.matches(node.getDatatype())) {
            this.write("^^");
            this.write(node.getDatatype().getIRI());
        }
    }

    @Override
    public void visit(OWLDataProperty property) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.DATA_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept(this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(OWLObjectProperty property) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.OBJECT_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept(this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.write(OWLXMLVocabulary.OBJECT_INVERSE_OF);
        this.writeOpenBracket();
        property.getInverse().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.NAMED_INDIVIDUAL);
            this.writeOpenBracket();
        }
        individual.getIRI().accept(this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.HAS_KEY, axiom);
        this.acceptAndSpace(axiom.getClassExpression());
        this.writeOpenBracket();
        this.write(OWLAPIStreamUtils.asList(axiom.objectPropertyExpressions()));
        this.writeCloseBracket();
        this.writeSpace();
        this.writeOpenBracket();
        this.write(OWLAPIStreamUtils.asList(axiom.dataPropertyExpressions()));
        this.writeCloseBracket();
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_PROPERTY_DOMAIN, axiom);
        this.acceptAndSpace((OWLObject)axiom.getProperty());
        ((IRI)axiom.getDomain()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_PROPERTY_RANGE, axiom);
        this.acceptAndSpace((OWLObject)axiom.getProperty());
        ((IRI)axiom.getRange()).accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_ANNOTATION_PROPERTY_OF, axiom);
        this.acceptAndSpace(axiom.getSubProperty());
        axiom.getSuperProperty().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        if (node.operands().count() == 1L) {
            node.operands().forEach(x -> x.accept(this));
            return;
        }
        this.write(OWLXMLVocabulary.DATA_INTERSECTION_OF);
        this.writeOpenBracket();
        this.write(node.operands());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        if (node.operands().count() == 1L) {
            node.operands().forEach(x -> x.accept(this));
            return;
        }
        this.write(OWLXMLVocabulary.DATA_UNION_OF);
        this.writeOpenBracket();
        this.write(node.operands());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.ANNOTATION_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept(this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.write(individual.getID().toString());
    }

    @Override
    public void visit(IRI iri) {
        this.write(iri);
    }

    @Override
    public void visit(OWLAnnotation node) {
        this.write(OWLXMLVocabulary.ANNOTATION);
        this.writeOpenBracket();
        node.annotations().forEach(this::acceptAndSpace);
        this.acceptAndSpace(node.getProperty());
        node.getValue().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATATYPE_DEFINITION, axiom);
        this.acceptAndSpace(axiom.getDatatype());
        axiom.getDataRange().accept(this);
        this.writeAxiomEnd();
    }

    @Override
    public void visit(SWRLRule rule) {
        this.writeAxiomStart(OWLXMLVocabulary.DL_SAFE_RULE, rule);
        this.write(OWLXMLVocabulary.BODY);
        this.writeOpenBracket();
        this.write(rule.body());
        this.writeCloseBracket();
        this.write(OWLXMLVocabulary.HEAD);
        this.writeOpenBracket();
        this.write(rule.head());
        this.writeCloseBracket();
        this.writeAxiomEnd();
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLClassAtom node) {
        this.write(OWLXMLVocabulary.CLASS_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace(node.getPredicate());
        ((SWRLIArgument)node.getArgument()).accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        this.write(OWLXMLVocabulary.DATA_RANGE_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace(node.getPredicate());
        ((SWRLDArgument)node.getArgument()).accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        this.write(OWLXMLVocabulary.OBJECT_PROPERTY_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace(node.getPredicate());
        this.acceptAndSpace((OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        this.write(OWLXMLVocabulary.DATA_PROPERTY_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace(node.getPredicate());
        this.acceptAndSpace((OWLObject)node.getFirstArgument());
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.write(OWLXMLVocabulary.BUILT_IN_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace(node.getPredicate());
        this.write(node.getArguments());
        this.writeCloseBracket();
    }

    @Override
    public void visit(SWRLVariable node) {
        this.write(OWLXMLVocabulary.VARIABLE);
        this.writeOpenBracket();
        node.getIRI().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        this.write(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace((OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        this.write(OWLXMLVocabulary.SAME_INDIVIDUAL_ATOM);
        this.writeOpenBracket();
        this.acceptAndSpace((OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.writeCloseBracket();
    }
}

