/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.zip.GZIPOutputStream;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZipFileDocumentTarget
implements OWLOntologyDocumentTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(GZipFileDocumentTarget.class);
    private final File out;

    public GZipFileDocumentTarget(File os) {
        this.out = OWLAPIPreconditions.checkNotNull(os, "os cannot be null");
    }

    @Override
    public Optional<OutputStream> getOutputStream() {
        try {
            return OWLAPIPreconditions.optional(new GZIPOutputStream(new FileOutputStream(this.out)));
        }
        catch (IOException e) {
            LOGGER.error("Cannot create output stream", e);
            return OWLAPIPreconditions.emptyOptional();
        }
    }

    @Override
    public Optional<IRI> getDocumentIRI() {
        return OWLAPIPreconditions.optional(IRI.create(this.out));
    }
}

