/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZOutputStream;

public class XZFileDocumentTarget
implements OWLOntologyDocumentTarget,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(XZFileDocumentTarget.class);
    private final File out;
    private final FilterOptions[] filterOptions;
    @Nullable
    private OutputStream outputStream;

    public XZFileDocumentTarget(File os, FilterOptions ... filterOptions) {
        this.out = os;
        this.filterOptions = filterOptions;
    }

    public XZFileDocumentTarget(File os, int presetLevel) throws UnsupportedOptionsException {
        this(os, new LZMA2Options(presetLevel));
    }

    public XZFileDocumentTarget(File file) {
        this(file, new LZMA2Options());
    }

    @Override
    public Optional<OutputStream> getOutputStream() {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.out));
            this.outputStream = new XZOutputStream((OutputStream)bufferedOutputStream, this.filterOptions);
        }
        catch (IOException e) {
            LOGGER.error("Cannot create output stream", e);
            return OWLAPIPreconditions.emptyOptional();
        }
        return OWLAPIPreconditions.optional(this.outputStream);
    }

    @Override
    public Optional<IRI> getDocumentIRI() {
        return OWLAPIPreconditions.optional(IRI.create(this.out));
    }

    @Override
    public void close() throws Exception {
        OutputStream toReturn = this.outputStream;
        this.outputStream = null;
        if (toReturn != null) {
            toReturn.close();
        }
    }
}

