/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.model.parameters.ConfigurationOptions;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class IRI
implements OWLAnnotationSubject,
OWLAnnotationValue,
SWRLPredicate,
CharSequence,
OWLPrimitive,
HasShortForm,
org.apache.commons.rdf.api.IRI {
    private static final LoadingCache<String, String> CACHE = Caffeine.newBuilder().weakKeys().maximumSize(IRI.size()).build(k -> k);
    private static final AtomicLong COUNTER = new AtomicLong(System.nanoTime());
    private final String remainder;
    private final String namespace;

    protected static long size() {
        return ConfigurationOptions.CACHE_SIZE.getValue(Integer.class, Collections.emptyMap()).longValue();
    }

    protected IRI(String prefix, @Nullable String suffix) {
        this.namespace = CACHE.get(XMLUtils.getNCNamePrefix(prefix));
        this.remainder = suffix == null ? "" : suffix;
    }

    protected IRI(String s2) {
        this(XMLUtils.getNCNamePrefix(s2), XMLUtils.getNCNameSuffix(s2));
    }

    protected IRI(URI uri) {
        this(OWLAPIPreconditions.checkNotNull(uri, "uri cannot be null").toString());
    }

    public static IRI create(String str) {
        OWLAPIPreconditions.checkNotNull(str, "str cannot be null");
        int index = XMLUtils.getNCNameSuffixIndex(str);
        if (index < 0) {
            return new IRI(str, "");
        }
        return new IRI(str.substring(0, index), str.substring(index));
    }

    public static IRI create(@Nullable String prefix, @Nullable String suffix) {
        if (prefix == null && suffix == null) {
            throw new IllegalArgumentException("prefix and suffix cannot both be null");
        }
        if (prefix == null) {
            return IRI.create(OWLAPIPreconditions.verifyNotNull(suffix));
        }
        if (suffix == null) {
            return IRI.create(prefix);
        }
        int index = XMLUtils.getNCNameSuffixIndex(prefix);
        int test = XMLUtils.getNCNameSuffixIndex(suffix);
        if (index == -1 && test == 0) {
            return new IRI(prefix, suffix);
        }
        return IRI.create(prefix + suffix);
    }

    public static IRI create(File file) {
        OWLAPIPreconditions.checkNotNull(file, "file cannot be null");
        return new IRI(file.toURI());
    }

    public static IRI create(URI uri) {
        OWLAPIPreconditions.checkNotNull(uri, "uri cannot be null");
        return new IRI(uri);
    }

    public static IRI create(URL url) {
        OWLAPIPreconditions.checkNotNull(url, "url cannot be null");
        try {
            return new IRI(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public static IRI generateDocumentIRI() {
        return IRI.getNextDocumentIRI("owlapi:ontology");
    }

    public static IRI getNextDocumentIRI(String prefix) {
        return IRI.create(prefix + COUNTER.incrementAndGet());
    }

    @Override
    public int typeIndex() {
        return 0;
    }

    @Override
    public boolean isIRI() {
        return true;
    }

    public URI toURI() {
        return URI.create(this.namespace + this.remainder);
    }

    public boolean isAbsolute() {
        int colonIndex = this.namespace.indexOf(58);
        if (colonIndex == -1) {
            return false;
        }
        for (int i = 0; i < colonIndex; ++i) {
            char ch = this.namespace.charAt(i);
            if (!this.disallowed(ch)) continue;
            return false;
        }
        return true;
    }

    protected boolean disallowed(char ch) {
        return !Character.isLetter(ch) && !Character.isDigit(ch) && ch != '.' && ch != '+' && ch != '-';
    }

    @Nullable
    public String getScheme() {
        int colonIndex = this.namespace.indexOf(58);
        if (colonIndex == -1) {
            return null;
        }
        return this.namespace.substring(0, colonIndex);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public IRI resolve(String s2) {
        URI uri = URI.create(s2);
        if (uri.isAbsolute() || uri.isOpaque()) {
            return IRI.create(uri);
        }
        return IRI.create(this.toURI().resolve(uri));
    }

    public boolean isReservedVocabulary() {
        return Namespaces.OWL.inNamespace(this.namespace) || Namespaces.RDF.inNamespace(this.namespace) || Namespaces.RDFS.inNamespace(this.namespace) || Namespaces.XSD.inNamespace(this.namespace);
    }

    public boolean isBuiltinAnnotationProperty() {
        return OWLRDFVocabulary.BUILT_IN_AP_IRIS.contains(this);
    }

    public boolean isThing() {
        return this.equals(OWLRDFVocabulary.OWL_THING.getIRI());
    }

    public boolean isNothing() {
        return this.equals(OWLRDFVocabulary.OWL_NOTHING.getIRI());
    }

    public boolean isPlainLiteral() {
        return "PlainLiteral".equals(this.remainder) && Namespaces.RDF.inNamespace(this.namespace);
    }

    public String getFragment() {
        return this.remainder;
    }

    public Optional<String> getRemainder() {
        if (this.remainder.isEmpty()) {
            return OWLAPIPreconditions.emptyOptional();
        }
        return OWLAPIPreconditions.optional(this.remainder);
    }

    public String toQuotedString() {
        return this.ntriplesString();
    }

    protected Optional<String> asOptional(@Nullable String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return OWLAPIPreconditions.emptyOptional();
        }
        return OWLAPIPreconditions.optional(suffix);
    }

    @Override
    public int length() {
        return this.namespace.length() + this.remainder.length();
    }

    @Override
    public char charAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index < this.namespace.length()) {
            return this.namespace.charAt(index);
        }
        return this.remainder.charAt(index - this.namespace.length());
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        StringBuilder sb = new StringBuilder(this.namespace);
        sb.append(this.remainder);
        return sb.subSequence(start, end);
    }

    public String prefixedBy(String prefix) {
        OWLAPIPreconditions.checkNotNull(prefix, "prefix cannot be null");
        if (this.remainder.isEmpty()) {
            return prefix;
        }
        return prefix + this.remainder;
    }

    @Override
    public String getShortForm() {
        if (!this.remainder.isEmpty()) {
            return this.remainder;
        }
        int lastSlashIndex = this.namespace.lastIndexOf(47);
        if (lastSlashIndex != -1 && lastSlashIndex != this.namespace.length() - 1) {
            return this.namespace.substring(lastSlashIndex + 1);
        }
        return this.toQuotedString();
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationSubjectVisitor visitor) {
        visitor.visit(this);
    }

    public <E> E accept(OWLAnnotationSubjectVisitorEx<E> visitor) {
        return visitor.visit(this);
    }

    @Override
    public int compareTo(@Nullable OWLObject o) {
        OWLAPIPreconditions.checkNotNull(o);
        assert (o != null);
        if (o == this || this.equals(o)) {
            return 0;
        }
        if (!o.isIRI()) {
            return -1;
        }
        IRI other = (IRI)o;
        int diff = this.namespace.compareTo(other.namespace);
        if (diff != 0) {
            return diff;
        }
        return this.remainder.compareTo(other.remainder);
    }

    @Override
    public String toString() {
        return this.getIRIString();
    }

    @Override
    public int hashCode() {
        return this.namespace.hashCode() + this.remainder.hashCode();
    }

    @Override
    public int initHashCode() {
        return this.hashCode();
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Optional<IRI> asIRI() {
        return OWLAPIPreconditions.optional(this);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof IRI) {
            IRI other = (IRI)obj;
            return this.remainder.equals(other.remainder) && other.namespace.equals(this.namespace);
        }
        if (obj instanceof org.apache.commons.rdf.api.IRI) {
            org.apache.commons.rdf.api.IRI iri = (org.apache.commons.rdf.api.IRI)obj;
            return this.ntriplesString().equals(iri.ntriplesString());
        }
        return false;
    }

    @Override
    public String ntriplesString() {
        return '<' + this.namespace + this.remainder + '>';
    }

    @Override
    public String getIRIString() {
        if (this.remainder.isEmpty()) {
            return this.namespace;
        }
        return this.namespace + this.remainder;
    }

    @Override
    public Stream<?> components() {
        return Stream.empty();
    }

    @Override
    public int hashIndex() {
        return 863;
    }
}

