/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.modularity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasAxioms;
import org.semanticweb.owlapi.model.HasContainsAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.modularity.ModuleExtractor;
import org.semanticweb.owlapi.modularity.locality.LocalityClass;
import org.semanticweb.owlapi.modularity.locality.SyntacticLocalityModuleExtractor;

public final class AtomicDecomposition
implements HasAxioms {
    @Nonnull
    private final Map<OWLAxiom, Atom> atomOf;
    @Nonnull
    private final Set<OWLAxiom> axioms;
    @Nonnull
    private final ModuleExtractor moduleExtractor;
    @Nonnull
    private final Map<OWLAxiom, Set<OWLAxiom>> moduleToSignatureOf;

    public AtomicDecomposition(OWLOntology ontology) {
        this(ontology.axioms(Imports.INCLUDED));
    }

    public AtomicDecomposition(OWLOntology ontology, Function<Stream<OWLAxiom>, ? extends ModuleExtractor> function) {
        this(Objects.requireNonNull(ontology, "The given ontology may not be null").axioms(), function);
    }

    public AtomicDecomposition(Stream<OWLAxiom> axioms) {
        this(axioms, (Stream<OWLAxiom> stream) -> new SyntacticLocalityModuleExtractor(LocalityClass.STAR, (Stream<OWLAxiom>)stream));
    }

    public AtomicDecomposition(Stream<OWLAxiom> axioms, Function<Stream<OWLAxiom>, ? extends ModuleExtractor> function) {
        this.axioms = Objects.requireNonNull(axioms, "The given axioms may not be null").collect(Collectors.toSet());
        this.moduleExtractor = Objects.requireNonNull(function, "The given function may not be null").apply(this.axioms());
        Objects.requireNonNull(axioms, "The given function may not retrieve null");
        this.moduleToSignatureOf = new HashMap<OWLAxiom, Set<OWLAxiom>>();
        this.atomOf = new HashMap<OWLAxiom, Atom>();
        this.decompose();
    }

    @Nonnull
    public Atom atomOf(OWLAxiom axiom) {
        if (!this.containsAxiom(Objects.requireNonNull(axiom, "The given axiom may not be null"))) {
            throw new IllegalArgumentException("The given axiom must be contained in the axiom base of this atomic decomposition");
        }
        return this.atomOf.get(axiom);
    }

    public Stream<Atom> atoms() {
        return this.atomOf.values().stream().distinct();
    }

    @Override
    @Nonnull
    public Stream<OWLAxiom> axioms() {
        return this.axioms.stream();
    }

    @Nonnull
    private Optional<OWLAxiom> buildAtomsInModule(OWLAxiom alpha, Optional<OWLAxiom> beta) {
        if (this.atomOf.containsKey(alpha)) {
            return Optional.of(alpha);
        }
        Optional<OWLAxiom> delta = this.getAtomSeed(alpha, beta);
        Atom atomOfDelta = this.atomOf.computeIfAbsent(delta.orElse(null), d -> new Atom());
        atomOfDelta.axiomSet.add(alpha);
        this.atomOf.put(alpha, atomOfDelta);
        if (delta.equals(beta)) {
            return beta;
        }
        this.moduleToSignatureOf(alpha).filter(gamma -> !gamma.equals(alpha)).forEach(gamma -> this.updateDependencies(alpha, (OWLAxiom)gamma));
        return Optional.of(alpha);
    }

    protected void updateDependencies(OWLAxiom alpha, OWLAxiom gamma) {
        Atom second;
        Optional<OWLAxiom> axiom = this.buildAtomsInModule(gamma, Optional.of(alpha));
        Atom first = this.atomOf.get(axiom.get());
        if (first != (second = this.atomOf.get(alpha))) {
            second.dependencies.add(first);
            first.dependents.add(second);
        }
    }

    public boolean containsAxiom(OWLAxiom axiom) {
        return this.axioms.contains(axiom);
    }

    private void decompose() {
        for (OWLAxiom alpha : this.axioms) {
            this.buildAtomsInModule(alpha, Optional.empty());
        }
    }

    @Nonnull
    private Optional<OWLAxiom> getAtomSeed(OWLAxiom alpha, Optional<OWLAxiom> beta) {
        Set<OWLAxiom> moduleOfBeta;
        if (beta.isPresent()) {
            moduleOfBeta = this.moduleToSignatureOf.get(beta.get());
            this.moduleExtractor.extract(alpha.signature(), moduleOfBeta::contains).forEach(moduleAxiom -> this.moduleToSignatureOf.computeIfAbsent(alpha, x -> new HashSet()).add(moduleAxiom));
        } else {
            moduleOfBeta = this.axioms;
            this.moduleExtractor.extract(alpha.signature()).forEach(moduleAxiom -> this.moduleToSignatureOf.computeIfAbsent(alpha, x -> new HashSet()).add(moduleAxiom));
        }
        if (this.moduleToSignatureOf.get(alpha).size() == moduleOfBeta.size()) {
            return beta;
        }
        return Optional.of(alpha);
    }

    @Nonnull
    public Stream<OWLAxiom> moduleToSignatureOf(OWLAxiom axiom) {
        if (!this.containsAxiom(Objects.requireNonNull(axiom, "The given axiom may not be null"))) {
            throw new IllegalArgumentException("The given axiom must be contained in the axiom base of this atomic decomposition");
        }
        return this.moduleToSignatureOf.get(axiom).stream();
    }

    public final class Atom
    implements HasAxioms,
    HasContainsAxiom {
        @Nonnull
        protected final Set<OWLAxiom> axiomSet = new HashSet<OWLAxiom>();
        @Nonnull
        protected final Set<Atom> dependencies = new HashSet<Atom>();
        @Nonnull
        protected final Set<Atom> dependents = new HashSet<Atom>();

        protected Atom() {
        }

        @Override
        @Nonnull
        public Stream<OWLAxiom> axioms() {
            return this.axiomSet.stream();
        }

        @Override
        public boolean containsAxiom(OWLAxiom axiom) {
            return this.axiomSet.contains(axiom);
        }

        @Nonnull
        public Stream<Atom> dependencies() {
            return this.dependencies.stream();
        }

        @Nonnull
        public Stream<Atom> dependents() {
            return this.dependents.stream();
        }

        public boolean dependsOn(Atom atom) {
            return this.dependencies.contains(Objects.requireNonNull(atom));
        }

        @Nonnull
        public Stream<Atom> directDependencies() {
            return this.dependencies().filter(this::directlyDependsOn);
        }

        @Nonnull
        public Stream<Atom> directDependents() {
            return this.dependents().filter(this::isDirectDependencyOf);
        }

        public boolean directlyDependsOn(Atom atom) {
            return this.dependsOn(atom) && this.dependencies().noneMatch(next -> this.dependsOn(atom));
        }

        public int getAxiomCount() {
            return this.axiomSet.size();
        }

        public boolean isDependencyOf(Atom atom) {
            return this.dependents.contains(Objects.requireNonNull(atom));
        }

        public boolean isDirectDependencyOf(Atom atom) {
            return this.isDependencyOf(atom) && this.dependents().noneMatch(next -> this.isDependencyOf(atom));
        }
    }
}

