/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.AbstractRDFPrefixDocumentFormat;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingOntologyHeaderStrategy;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.rdf.rdfxml.parser.BuiltInTypeHandler;
import org.semanticweb.owlapi.rdf.rdfxml.parser.LiteralTripleHandler;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OptimisedListTranslator;
import org.semanticweb.owlapi.rdf.rdfxml.parser.ResourceTripleHandler;
import org.semanticweb.owlapi.rdf.rdfxml.parser.Translators;
import org.semanticweb.owlapi.rdf.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.rdf.rdfxml.parser.TypeMatcher;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SKOSVocabulary;
import org.semanticweb.owlapi.vocab.SWRLVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripleHandlers {
    static final Logger LOGGER = LoggerFactory.getLogger(TripleHandlers.class);

    private TripleHandlers() {
    }

    static class TypeTransitivePropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeTransitivePropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_TRANSITIVE_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.consumer.handlerAccessor.handle(s2, p, OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
            return !this.isAnon(s2);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.add(this.df.getOWLTransitiveObjectPropertyAxiom(this.op(s2), this.anns()));
            this.consume(s2, p, o);
        }
    }

    static class TypeSymmetricPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeSymmetricPropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_SYMMETRIC_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            boolean isIRI;
            boolean bl = isIRI = !this.isAnon(s2);
            if (isIRI) {
                this.consumer.handlerAccessor.handle(s2, p, OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
            }
            this.addOp(s2, false);
            return isIRI;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isOpLax(s2)) {
                this.add(this.df.getOWLSymmetricObjectPropertyAxiom(this.op(s2), this.anns()));
                this.consume(s2, p, o);
            }
        }
    }

    static class TypeSelfRestrictionHandler
    extends AbstractBuiltInTypeHandler {
        TypeSelfRestrictionHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_SELF_RESTRICTION.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
            this.addR(s2, false);
            this.consumer.addTriple(s2, OWLRDFVocabulary.OWL_HAS_SELF.getIRI(), this.df.getOWLLiteral(true));
        }
    }

    static class TypeSWRLVariableHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLVariableHandler(OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.VARIABLE.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consumer.addSWRLVariable(s2);
            this.consume(s2, p, o);
        }
    }

    static class TypeSWRLSameIndividualAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLSameIndividualAtomHandler(OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.SAME_INDIVIDUAL_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consumer.addSWRLSameAsAtom(s2);
            this.consume(s2, p, o);
        }
    }

    static class TypeSWRLIndividualPropertyAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLIndividualPropertyAtomHandler(OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.INDIVIDUAL_PROPERTY_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
            this.consumer.addSWRLIndividualPropertyAtom(s2);
        }
    }

    static class TypeSWRLImpHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLImpHandler(OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.IMP.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            IRI remapIRI = this.consumer.remapIRI(s2);
            this.consume(remapIRI, p, o);
            this.consumer.addSWRLRule(remapIRI);
        }
    }

    static class TypeSWRLDifferentIndividualsAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLDifferentIndividualsAtomHandler(OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.DIFFERENT_INDIVIDUALS_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consumer.addSWRLDifferentFromAtom(s2);
            this.consume(s2, p, o);
        }
    }

    static class TypeSWRLDataValuedPropertyAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLDataValuedPropertyAtomHandler(OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.DATAVALUED_PROPERTY_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
            this.consumer.addSWRLDataPropertyAtom(s2);
        }
    }

    static class TypeSWRLDataRangeAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLDataRangeAtomHandler(OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.DATA_RANGE_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consumer.addSWRLDataRangeAtom(s2);
            this.consume(s2, p, o);
        }
    }

    static class TypeSWRLClassAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLClassAtomHandler(OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.CLASS_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consumer.addSWRLClassAtom(s2);
            this.consume(s2, p, o);
        }
    }

    static class TypeSWRLBuiltInHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLBuiltInHandler(OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.BUILT_IN_CLASS.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
        }
    }

    static class TypeSWRLBuiltInAtomHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLBuiltInAtomHandler(OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.BUILT_IN_ATOM.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consumer.addSWRLBuiltInAtom(s2);
            this.consume(s2, p, o);
        }
    }

    static class TypeSWRLAtomListHandler
    extends AbstractBuiltInTypeHandler {
        TypeSWRLAtomListHandler(OWLRDFConsumer consumer) {
            super(consumer, SWRLVocabulary.ATOM_LIST.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
        }
    }

    static class TypeRestrictionHandler
    extends AbstractBuiltInTypeHandler {
        TypeRestrictionHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
            this.addR(s2, true);
            this.addCe(s2, false);
        }
    }

    static class TypeReflexivePropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeReflexivePropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_REFLEXIVE_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addOp(s2, false);
            return !this.isAnon(s2);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isOpLax(s2)) {
                this.add(this.df.getOWLReflexiveObjectPropertyAxiom(this.op(s2), this.anns()));
                this.consume(s2, p, o);
            }
        }
    }

    static class TypeRDFSClassHandler
    extends AbstractBuiltInTypeHandler {
        TypeRDFSClassHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDFS_CLASS.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.addCe(s2, false);
            this.consume(s2, p, o);
            if (!this.isStrict()) {
                this.consumer.handlerAccessor.handle(s2, p, OWLRDFVocabulary.OWL_CLASS.getIRI());
            }
        }
    }

    static class TypePropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypePropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDF_PROPERTY.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
            LOGGER.info("Usage of rdf vocabulary: {} -> {} -> {}", s2, p, o);
        }
    }

    static class TypeOntologyPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeOntologyPropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ONTOLOGY_PROPERTY.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
            this.consumer.handlerAccessor.handle(s2, p, OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI());
        }
    }

    static class TypeOntologyHandler
    extends AbstractBuiltInTypeHandler {
        TypeOntologyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ONTOLOGY.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
            this.consumer.addOntology(s2);
        }
    }

    static class TypeObjectPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeObjectPropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (!this.isAnon(s2)) {
                OWLObjectProperty op = this.df.getOWLObjectProperty(s2);
                this.add(this.df.getOWLDeclarationAxiom(op, this.anns()));
            }
            this.addOp(s2, true);
        }
    }

    static class TypeNegativePropertyAssertionHandler
    extends AbstractBuiltInTypeHandler {
        TypeNegativePropertyAssertionHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            IRI source = this.source(s2);
            IRI property = this.property(s2);
            OWLObject target = this.target(s2);
            this.anns(s2);
            if (target instanceof OWLLiteral && (!this.isStrict() || this.isDPLax(property))) {
                this.translateNegativeDataPropertyAssertion(s2, p, o, source, property, (OWLLiteral)target, this.anns());
            } else if (target.isIRI() && (!this.isStrict() || this.isOpLax(property))) {
                this.translateNegativeObjectPropertyAssertion(s2, p, o, source, property, (IRI)target, this.anns());
            }
        }

        OWLObject target(IRI s2) {
            OWLAnnotationValue target = this.getRO(s2, OWLRDFVocabulary.OWL_TARGET_INDIVIDUAL);
            if (target == null) {
                target = this.consumer.getLiteralObject(s2, OWLRDFVocabulary.OWL_TARGET_VALUE.getIRI(), true);
            }
            if (target == null) {
                target = this.getRO(s2, OWLRDFVocabulary.RDF_OBJECT);
            }
            if (target == null) {
                target = this.consumer.getLiteralObject(s2, OWLRDFVocabulary.RDF_OBJECT, true);
            }
            return OWLAPIPreconditions.verifyNotNull(target);
        }

        IRI property(IRI s2) {
            IRI property = this.getRO(s2, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY);
            if (property == null) {
                property = this.getRO(s2, OWLRDFVocabulary.RDF_PREDICATE);
            }
            return OWLAPIPreconditions.verifyNotNull(property);
        }

        IRI source(IRI s2) {
            IRI source = this.getRO(s2, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL);
            if (source == null) {
                source = this.getRO(s2, OWLRDFVocabulary.RDF_SUBJECT);
            }
            return OWLAPIPreconditions.verifyNotNull(source);
        }

        private void translateNegativeObjectPropertyAssertion(IRI s2, IRI p, IRI o, IRI source, IRI property, IRI target, Set<OWLAnnotation> annos) {
            OWLIndividual sourceInd = this.consumer.getOWLIndividual(source);
            OWLObjectPropertyExpression prop = this.op(property);
            OWLIndividual targetInd = this.consumer.getOWLIndividual(target);
            this.consume(s2, p, o);
            this.add(this.df.getOWLNegativeObjectPropertyAssertionAxiom(prop, sourceInd, targetInd, annos));
        }

        private void translateNegativeDataPropertyAssertion(IRI s2, IRI p, IRI o, IRI source, IRI property, OWLLiteral target, Set<OWLAnnotation> annos) {
            OWLIndividual sourceInd = this.consumer.getOWLIndividual(source);
            OWLDataPropertyExpression prop = this.dp(property);
            this.consume(s2, p, o);
            this.add(this.df.getOWLNegativeDataPropertyAssertionAxiom(prop, sourceInd, target, annos));
        }
    }

    static class TypeNegativeDataPropertyAssertionHandler
    extends AbstractBuiltInTypeHandler {
        TypeNegativeDataPropertyAssertionHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_NEGATIVE_DATA_PROPERTY_ASSERTION.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            IRI source = this.source(s2);
            IRI property = this.property(s2);
            OWLLiteral target = this.target(s2);
            OWLIndividual sourceInd = this.consumer.getOWLIndividual(source);
            OWLDataPropertyExpression prop = this.dp(property);
            this.consume(s2, p, o);
            this.anns(s2);
            this.add(this.df.getOWLNegativeDataPropertyAssertionAxiom(prop, sourceInd, target, this.anns()));
        }

        OWLLiteral target(IRI s2) {
            OWLLiteral target = this.consumer.getLiteralObject(s2, OWLRDFVocabulary.OWL_TARGET_VALUE.getIRI(), true);
            if (target == null) {
                target = this.consumer.getLiteralObject(s2, OWLRDFVocabulary.OWL_OBJECT.getIRI(), true);
            }
            if (target == null) {
                target = this.consumer.getLiteralObject(s2, OWLRDFVocabulary.RDF_OBJECT, true);
            }
            return OWLAPIPreconditions.verifyNotNull(target);
        }

        IRI property(IRI s2) {
            IRI property = this.getRO(s2, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY);
            if (property == null) {
                property = this.getRO(s2, OWLRDFVocabulary.OWL_PREDICATE);
            }
            if (property == null) {
                property = this.getRO(s2, OWLRDFVocabulary.RDF_PREDICATE);
            }
            return OWLAPIPreconditions.verifyNotNull(property);
        }

        IRI source(IRI s2) {
            IRI source = this.getRO(s2, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL);
            if (source == null) {
                source = this.getRO(s2, OWLRDFVocabulary.OWL_SUBJECT);
            }
            if (source == null) {
                source = this.getRO(s2, OWLRDFVocabulary.RDF_SUBJECT);
            }
            return OWLAPIPreconditions.verifyNotNull(source);
        }
    }

    static class TypeNamedIndividualHandler
    extends AbstractBuiltInTypeHandler {
        TypeNamedIndividualHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (!this.isAnon(s2)) {
                OWLNamedIndividual individual = this.df.getOWLNamedIndividual(s2);
                this.add(this.df.getOWLDeclarationAxiom(individual, this.anns()));
            }
            this.consumer.addOWLNamedIndividual(s2, true);
        }
    }

    static class TypeListHandler
    extends AbstractBuiltInTypeHandler {
        TypeListHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDF_LIST.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
        }
    }

    static class TypeIrreflexivePropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeIrreflexivePropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_IRREFLEXIVE_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addOp(s2, false);
            return !this.isAnon(s2);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isOpLax(s2)) {
                this.add(this.df.getOWLIrreflexiveObjectPropertyAxiom(this.op(s2), this.anns()));
                this.consume(s2, p, o);
            }
        }
    }

    static class TypeInverseFunctionalPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeInverseFunctionalPropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_INVERSE_FUNCTIONAL_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.consumer.handlerAccessor.handle(s2, p, OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
            return !this.isAnon(s2);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isOpLax(s2)) {
                OWLObjectPropertyExpression property = this.op(s2);
                this.add(this.df.getOWLInverseFunctionalObjectPropertyAxiom(property, this.anns()));
                this.consume(s2, p, o);
            }
        }
    }

    static class TypeFunctionalPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeFunctionalPropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isOpLax(s2)) {
                this.add(this.df.getOWLFunctionalObjectPropertyAxiom(this.op(s2), this.anns()));
                this.consume(s2, p, o);
            }
            if (this.isDPLax(s2)) {
                this.add(this.df.getOWLFunctionalDataPropertyAxiom(this.dp(s2), this.anns()));
                this.consume(s2, p, o);
            }
        }
    }

    static class TypeDeprecatedPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeDeprecatedPropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DEPRECATED_PROPERTY.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
            this.add(this.df.getDeprecatedOWLAnnotationAssertionAxiom(s2));
        }
    }

    static class TypeDeprecatedClassHandler
    extends AbstractBuiltInTypeHandler {
        TypeDeprecatedClassHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DEPRECATED_CLASS.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.addCe(s2, false);
            this.consume(s2, p, o);
            this.add(this.df.getDeprecatedOWLAnnotationAssertionAxiom(s2));
        }
    }

    static class TypeDatatypeHandler
    extends AbstractBuiltInTypeHandler {
        TypeDatatypeHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (!this.isAnon(s2)) {
                OWLDatatype dt = this.df.getOWLDatatype(s2);
                this.add(this.df.getOWLDeclarationAxiom(dt, this.anns()));
            }
            this.addDR(s2, true);
        }
    }

    static class TypeDataRangeHandler
    extends AbstractBuiltInTypeHandler {
        TypeDataRangeHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DATA_RANGE.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (!this.isAnon(s2)) {
                this.consume(s2, p, o);
            }
        }
    }

    static class TypeDataPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeDataPropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (!this.isAnon(s2)) {
                OWLDataProperty owlDataProperty = this.df.getOWLDataProperty(s2);
                this.add(this.df.getOWLDeclarationAxiom(owlDataProperty, this.anns()));
            }
            this.addDp(s2, true);
        }
    }

    static class TypeClassHandler
    extends AbstractBuiltInTypeHandler {
        TypeClassHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_CLASS.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (!this.isAnon(s2)) {
                OWLClass owlClass = this.df.getOWLClass(s2);
                this.add(this.df.getOWLDeclarationAxiom(owlClass, this.anns()));
            }
            this.addCe(s2, true);
        }
    }

    static class TypeAxiomHandler
    extends AbstractBuiltInTypeHandler {
        TypeAxiomHandler(OWLRDFConsumer consumer) {
            this(consumer, OWLRDFVocabulary.OWL_AXIOM.getIRI());
        }

        TypeAxiomHandler(OWLRDFConsumer consumer, IRI typeIRI) {
            super(consumer, typeIRI);
        }

        protected static OWLRDFVocabulary getTargetTriplePredicate() {
            return OWLRDFVocabulary.OWL_ANNOTATED_TARGET;
        }

        protected static OWLRDFVocabulary getPropertyTriplePredicate() {
            return OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY;
        }

        protected static OWLRDFVocabulary getSourceTriplePredicate() {
            return OWLRDFVocabulary.OWL_ANNOTATED_SOURCE;
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.consumer.addAxiom(s2);
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            IRI annotatedSource = this.getObjectOfSourceTriple(s2);
            IRI annotatedProperty = this.getObjectOfPropertyTriple(s2);
            IRI annotatedTarget = this.getObjectOfTargetTriple(s2);
            OWLLiteral annotatedTargetLiteral = null;
            if (annotatedTarget == null) {
                annotatedTargetLiteral = this.getTargetLiteral(s2);
            }
            if (annotatedSource != null && annotatedProperty != null) {
                this.anns(s2);
                Set<OWLAnnotation> annotations = this.anns();
                this.consumer.addPendingAnnotations(annotations);
                if (annotatedTarget != null) {
                    this.consumer.handlerAccessor.handle(annotatedSource, annotatedProperty, annotatedTarget);
                } else if (annotatedTargetLiteral != null) {
                    this.consumer.handlerAccessor.handle(annotatedSource, annotatedProperty, annotatedTargetLiteral);
                }
                if (!annotations.isEmpty()) {
                    OWLAxiom ax = this.consumer.getLastAddedAxiom();
                    this.consumer.removeAxiom((OWLAxiom)OWLAPIPreconditions.verifyNotNull(ax, "no axiom added yet by the consumer").getAxiomWithoutAnnotations());
                }
                this.consume(s2, p, o);
            }
        }

        @Nullable
        protected OWLAxiom handleAxiomTriples(IRI subjectTriple, IRI predicateTriple, IRI objectTriple, Set<OWLAnnotation> annotations) {
            return this.consumer.getLastAddedAxiom();
        }

        @Nullable
        protected OWLAxiom handleAxiomTriples(IRI subjectTripleObject, IRI predicateTripleObject, OWLLiteral con, Set<OWLAnnotation> annotations) {
            this.consumer.handlerAccessor.handle(subjectTripleObject, predicateTripleObject, con);
            return this.consumer.getLastAddedAxiom();
        }

        private OWLLiteral getTargetLiteral(IRI s2) {
            OWLLiteral con = this.consumer.getLiteralObject(s2, TypeAxiomHandler.getTargetTriplePredicate(), true);
            if (con == null) {
                con = this.consumer.getLiteralObject(s2, OWLRDFVocabulary.RDF_OBJECT, true);
            }
            return OWLAPIPreconditions.verifyNotNull(con);
        }

        @Nullable
        private IRI getObjectOfTargetTriple(IRI mainNode) {
            IRI objectTripleObject = this.consumer.getResourceObject(mainNode, TypeAxiomHandler.getTargetTriplePredicate(), true);
            if (objectTripleObject == null) {
                objectTripleObject = this.getRO(mainNode, OWLRDFVocabulary.RDF_OBJECT);
            }
            if (objectTripleObject == null) {
                objectTripleObject = this.getRO(mainNode, OWLRDFVocabulary.OWL_PROPERTY_CHAIN);
            }
            return objectTripleObject;
        }

        @Nullable
        private IRI getObjectOfPropertyTriple(IRI s2) {
            IRI predicateTripleObject = this.consumer.getResourceObject(s2, TypeAxiomHandler.getPropertyTriplePredicate(), true);
            if (predicateTripleObject == null) {
                predicateTripleObject = this.getRO(s2, OWLRDFVocabulary.RDF_PREDICATE);
            }
            return predicateTripleObject;
        }

        @Nullable
        private IRI getObjectOfSourceTriple(IRI mainNode) {
            IRI subjectTripleObject = this.consumer.getResourceObject(mainNode, TypeAxiomHandler.getSourceTriplePredicate(), true);
            if (subjectTripleObject == null) {
                subjectTripleObject = this.getRO(mainNode, OWLRDFVocabulary.RDF_SUBJECT);
            }
            return subjectTripleObject;
        }
    }

    static class TypeAsymmetricPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeAsymmetricPropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ASYMMETRIC_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addOp(s2, false);
            return !this.isAnon(s2);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isOpLax(s2)) {
                this.add(this.df.getOWLAsymmetricObjectPropertyAxiom(this.op(s2), this.anns()));
                this.consume(s2, p, o);
            }
        }
    }

    static class TypeAnnotationPropertyHandler
    extends AbstractBuiltInTypeHandler {
        TypeAnnotationPropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (!this.isAnon(s2)) {
                OWLAnnotationProperty property = this.df.getOWLAnnotationProperty(s2);
                this.add(this.df.getOWLDeclarationAxiom(property, this.anns()));
                this.consume(s2, p, o);
            }
            this.addAp(s2, true);
        }
    }

    static class TypeAnnotationHandler
    extends AbstractBuiltInTypeHandler {
        TypeAnnotationHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ANNOTATION.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consumer.addAnnotationIRI(s2);
        }
    }

    static class TypeAllDisjointPropertiesHandler
    extends AbstractBuiltInTypeHandler {
        TypeAllDisjointPropertiesHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
            IRI listNode = OWLAPIPreconditions.verifyNotNull(this.getRO(s2, OWLRDFVocabulary.OWL_MEMBERS));
            if (this.isOpLax(this.consumer.getFirstResource(listNode, false))) {
                Set<OWLObjectPropertyExpression> props = this.ops(listNode);
                this.anns(s2);
                this.consumer.addAxiom(this.df.getOWLDisjointObjectPropertiesAxiom(props, this.anns()));
            } else {
                Set<OWLDataPropertyExpression> props = this.dps(listNode);
                this.anns(s2);
                this.consumer.addAxiom(this.df.getOWLDisjointDataPropertiesAxiom(props, this.anns()));
            }
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return false;
        }
    }

    static class TypeAllDisjointClassesHandler
    extends AbstractBuiltInTypeHandler {
        TypeAllDisjointClassesHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ALL_DISJOINT_CLASSES.getIRI());
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return super.canHandle(s2, p, o) && this.isResourcePresent(s2, OWLRDFVocabulary.OWL_MEMBERS);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            IRI listNode = this.getRO(s2, OWLRDFVocabulary.OWL_MEMBERS);
            if (listNode != null) {
                Set<OWLClassExpression> desc = this.consumer.translatorAccessor.translateToClassExpressionSet(listNode);
                this.anns(s2);
                this.add(this.df.getOWLDisjointClassesAxiom(desc, this.anns()));
                this.consume(s2, p, o);
            }
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return false;
        }
    }

    static class TypeAllDifferentHandler
    extends AbstractBuiltInTypeHandler {
        TypeAllDifferentHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ALL_DIFFERENT.getIRI());
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return super.canHandle(s2, p, o) && (this.isResourcePresent(s2, OWLRDFVocabulary.OWL_MEMBERS) || this.isResourcePresent(s2, OWLRDFVocabulary.OWL_DISTINCT_MEMBERS));
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            IRI listNode = this.getRO(s2, OWLRDFVocabulary.OWL_MEMBERS);
            if (listNode != null) {
                Set<OWLIndividual> inds = this.consumer.translatorAccessor.translateToIndividualSet(listNode);
                this.anns(s2);
                this.add(this.df.getOWLDifferentIndividualsAxiom(inds, this.anns()));
                this.consume(s2, p, o);
            } else {
                listNode = this.getRO(s2, OWLRDFVocabulary.OWL_DISTINCT_MEMBERS);
                if (listNode != null) {
                    Set<OWLIndividual> inds = this.consumer.translatorAccessor.translateToIndividualSet(listNode);
                    this.anns(s2);
                    this.add(this.df.getOWLDifferentIndividualsAxiom(inds, this.anns()));
                    this.consume(s2, p, o);
                }
            }
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return false;
        }
    }

    static abstract class AbstractTriplePredicateHandler
    extends AbstractResourceTripleHandler
    implements TriplePredicateHandler {
        private final IRI predicateIRI;

        AbstractTriplePredicateHandler(OWLRDFConsumer consumer, IRI predicateIRI) {
            super(consumer);
            this.predicateIRI = predicateIRI;
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            this.inferTypes(s2, o);
            return p.equals(this.predicateIRI);
        }

        @Override
        public IRI getPredicateIRI() {
            return this.predicateIRI;
        }
    }

    static class TPVersionIRIHandler
    extends AbstractTriplePredicateHandler {
        TPVersionIRIHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_VERSION_IRI.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consumer.addVersionIRI(s2, o);
            this.consume(s2, p, o);
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return true;
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return p.equals(OWLRDFVocabulary.OWL_VERSION_IRI.getIRI());
        }
    }

    static class TPUnionOfHandler
    extends AbstractNamedEquivalentClassAxiomHandler {
        TPUnionOfHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_UNION_OF.getIRI());
        }

        @Override
        protected OWLClassExpression translateEquivalentClass(IRI mainNode) {
            return this.df.getOWLObjectUnionOf(this.consumer.translatorAccessor.translateToClassExpressionSet(mainNode));
        }
    }

    static class TPTypeHandler
    extends AbstractTriplePredicateHandler {
        TPTypeHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDF_TYPE.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addCe(o, false);
            if (this.isAnon(o)) {
                return false;
            }
            if (o.isReservedVocabulary()) {
                return o.isThing();
            }
            return true;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (OWLRDFVocabulary.BUILT_IN_VOCABULARY_IRIS.contains(o) && !o.isThing()) {
                LOGGER.info("Individual of builtin type {}", (Object)o);
            }
            this.add(this.df.getOWLClassAssertionAxiom(this.ce(o), this.ind(s2), this.anns()));
            this.consume(s2, p, o);
        }
    }

    static class TPSubPropertyOfHandler
    extends AbstractTriplePredicateHandler {
        TPSubPropertyOfHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            if (this.isOpLax(o)) {
                this.addOp(s2, false);
            } else if (this.isDPLax(o)) {
                this.addDp(o, false);
            } else if (this.isApLax(o)) {
                this.addAp(s2, false);
            } else if (this.isOpLax(s2)) {
                this.addOp(o, false);
            } else if (this.isDPLax(s2)) {
                this.addDp(o, false);
            } else if (this.isApLax(s2)) {
                this.addAp(o, false);
            }
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (!this.isStrict() && this.consumer.hasPredicate(s2, OWLRDFVocabulary.OWL_PROPERTY_CHAIN.getIRI())) {
                IRI chainList = this.getRO(s2, OWLRDFVocabulary.OWL_PROPERTY_CHAIN);
                List<OWLObjectPropertyExpression> properties = this.consumer.translatorAccessor.translateToObjectPropertyList(OWLAPIPreconditions.verifyNotNull(chainList));
                this.add(this.df.getOWLSubPropertyChainOfAxiom(properties, this.op(o), this.anns()));
                this.consume(s2, p, o);
            } else if (!this.isStrict() && this.consumer.hasPredicate(s2, OWLRDFVocabulary.RDF_FIRST.getIRI())) {
                List<OWLObjectPropertyExpression> properties = this.consumer.translatorAccessor.translateToObjectPropertyList(s2);
                this.add(this.df.getOWLSubPropertyChainOfAxiom(properties, this.op(o), this.anns()));
                this.consume(s2, p, o);
            } else if (this.isOpLax(s2) && this.isOpLax(o)) {
                this.translateSubObjectProperty(s2, p, o);
            } else if (this.isDPLax(s2) && this.isDPLax(o)) {
                this.translateSubDataProperty(s2, p, o);
            } else if (!this.isStrict()) {
                if (this.consumer.isObjectProperty(o)) {
                    this.translateSubObjectProperty(s2, p, o);
                } else if (this.consumer.isDataProperty(o)) {
                    this.translateSubDataProperty(s2, p, o);
                } else {
                    OWLAnnotationProperty subAnnoProp = this.df.getOWLAnnotationProperty(s2);
                    OWLAnnotationProperty superAnnoProp = this.df.getOWLAnnotationProperty(o);
                    this.add(this.df.getOWLSubAnnotationPropertyOfAxiom(subAnnoProp, superAnnoProp, this.anns()));
                }
                this.consume(s2, p, o);
            }
        }

        private void translateSubObjectProperty(IRI s2, IRI p, IRI o) {
            this.add(this.df.getOWLSubObjectPropertyOfAxiom(this.op(s2), this.op(o), this.anns()));
            this.consume(s2, p, o);
        }

        private void translateSubDataProperty(IRI s2, IRI p, IRI o) {
            this.add(this.df.getOWLSubDataPropertyOfAxiom(this.dp(s2), this.dp(o), this.anns()));
            this.consume(s2, p, o);
        }
    }

    static class TPSubClassOfHandler
    extends AbstractTriplePredicateHandler {
        TPSubClassOfHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI());
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return super.canHandle(s2, p, o) && this.isTyped(s2, o);
        }

        private boolean isTyped(IRI s2, IRI o) {
            return this.isCe(s2) && this.isCe(o);
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addCe(s2, false);
            this.addCe(o, false);
            return !this.isStrict() && !this.eitherAnon(s2, o);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isStrict()) {
                if (this.isClassExpressionStrict(s2) && this.isClassExpressionStrict(o)) {
                    this.translate(s2, p, o);
                }
            } else if (this.isCeLax(s2) && this.isCeLax(o)) {
                this.translate(s2, p, o);
            }
        }

        private void translate(IRI s2, IRI p, IRI o) {
            OWLClassExpression subClass = this.ce(s2);
            OWLClassExpression supClass = this.ce(o);
            OWLSubClassOfAxiom ax = this.df.getOWLSubClassOfAxiom(subClass, supClass, this.anns());
            this.add(ax);
            this.consume(s2, p, o);
        }
    }

    static class TPSomeValuesFromHandler
    extends AbstractTriplePredicateHandler {
        TPSomeValuesFromHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.handleTriple(s2, p, o);
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            IRI property;
            this.addR(s2, false);
            if (this.isDr(o) && (property = this.getResourceObject(s2, OWLRDFVocabulary.OWL_ON_PROPERTY)) != null) {
                this.addDp(property, false);
            }
        }
    }

    static class TPSameAsHandler
    extends AbstractTriplePredicateHandler {
        TPSameAsHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_SAME_AS.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return true;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.add(this.df.getOWLSameIndividualAxiom(Arrays.asList(this.ind(s2), this.ind(o)), this.anns()));
            this.consume(s2, p, o);
        }
    }

    static class TPRestHandler
    extends AbstractTriplePredicateHandler {
        TPRestHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDF_REST.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return true;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (!o.equals(OWLRDFVocabulary.RDF_NIL.getIRI())) {
                this.consumer.addRest(s2, o);
            }
            this.consume(s2, p, o);
        }
    }

    static class TPPropertyRangeHandler
    extends AbstractTriplePredicateHandler {
        TPPropertyRangeHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDFS_RANGE.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.inferTypes(s2, o);
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isStrict()) {
                if (this.isObjectPropertyStrict(s2) && this.isClassExpressionStrict(o)) {
                    this.translateAsObjectPropertyRange(s2, p, o);
                } else if (this.isDataPropertyStrict(s2) && this.isDataRangeStrict(o)) {
                    this.translateAsDataPropertyRange(s2, p, o);
                } else if (this.isApLax(s2) && !this.isAnon(o)) {
                    this.translateAsAnnotationPropertyRange(s2, p, o);
                }
            } else if (this.isObjectPropertyStrict(s2) && this.consumer.isClassExpression(o)) {
                this.translateAsObjectPropertyRange(s2, p, o);
            } else if (this.isDataPropertyStrict(s2) && this.consumer.isDataRange(o)) {
                this.translateAsDataPropertyRange(s2, p, o);
            } else if (this.consumer.isAnnotationProperty(s2) && !this.consumer.isAnonymousNode(o)) {
                this.translateAsAnnotationPropertyRange(s2, p, o);
            } else if (this.isAnnotationPropertyOnly(s2) && !this.isAnon(o)) {
                this.translateAsAnnotationPropertyRange(s2, p, o);
            } else if (this.isCeLax(o)) {
                this.addOp(s2, false);
                this.translateAsObjectPropertyRange(s2, p, o);
            } else if (this.isDrLax(o)) {
                this.addDp(s2, false);
                this.translateAsDataPropertyRange(s2, p, o);
            } else if (this.isOpLax(s2)) {
                this.addOp(s2, false);
                this.translateAsObjectPropertyRange(s2, p, o);
            } else if (this.isDPLax(s2)) {
                this.addDp(s2, false);
                this.translateAsDataPropertyRange(s2, p, o);
            } else {
                this.addAp(s2, false);
                this.translateAsAnnotationPropertyRange(s2, p, o);
            }
        }

        private void translateAsAnnotationPropertyRange(IRI s2, IRI p, IRI o) {
            OWLAnnotationProperty prop = this.df.getOWLAnnotationProperty(s2);
            this.add(this.df.getOWLAnnotationPropertyRangeAxiom(prop, o, this.anns()));
            this.consume(s2, p, o);
        }

        private void translateAsDataPropertyRange(IRI s2, IRI p, IRI o) {
            OWLDataPropertyExpression property = this.dp(s2);
            OWLDataRange dataRange = this.dr(o);
            this.add(this.df.getOWLDataPropertyRangeAxiom(property, dataRange, this.anns()));
            this.consume(s2, p, o);
        }

        private void translateAsObjectPropertyRange(IRI s2, IRI p, IRI o) {
            OWLObjectPropertyExpression property = this.op(s2);
            OWLClassExpression range = this.ce(o);
            this.add(this.df.getOWLObjectPropertyRangeAxiom(property, range, this.anns()));
            this.consume(s2, p, o);
        }
    }

    static class TPPropertyDomainHandler
    extends AbstractTriplePredicateHandler {
        TPPropertyDomainHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isOpLax(s2)) {
                if (!this.isCe(o)) {
                    this.addCe(o, false);
                }
                this.translateObjectPropertyDomain(s2, p, o);
            } else if (this.isDPLax(s2)) {
                if (!this.isCe(o)) {
                    this.addCe(o, false);
                }
                this.translateDataPropertyDomain(s2, p, o);
            } else if (this.isApLax(s2) && !this.isAnon(o)) {
                this.translateAnnotationPropertyDomain(s2, p, o);
            } else if (!this.isStrict()) {
                this.addAp(s2, false);
                this.translateAnnotationPropertyDomain(s2, p, o);
            }
        }

        private void translateAnnotationPropertyDomain(IRI s2, IRI p, IRI o) {
            OWLAnnotationProperty prop = this.df.getOWLAnnotationProperty(s2);
            this.add(this.df.getOWLAnnotationPropertyDomainAxiom(prop, o, this.anns()));
            this.consume(s2, p, o);
        }

        private void translateDataPropertyDomain(IRI s2, IRI p, IRI o) {
            this.add(this.df.getOWLDataPropertyDomainAxiom(this.dp(s2), this.ce(o), this.anns()));
            this.consume(s2, p, o);
        }

        private void translateObjectPropertyDomain(IRI s2, IRI p, IRI o) {
            this.add(this.df.getOWLObjectPropertyDomainAxiom(this.op(s2), this.ce(o), this.anns()));
            this.consume(s2, p, o);
        }
    }

    static class TPPropertyDisjointWithHandler
    extends AbstractTriplePredicateHandler {
        TPPropertyDisjointWithHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            this.inferTypes(s2, o);
            return super.canHandle(s2, p, o) && (this.isOpLax(s2) && this.isOpLax(o) || this.isDPLax(s2) && this.isDPLax(o));
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isDPLax(s2) && this.isDPLax(o)) {
                this.add(this.df.getOWLDisjointDataPropertiesAxiom(CollectionFactory.createSet(new OWLDataPropertyExpression[]{this.dp(s2), this.dp(o)}), this.anns()));
                this.consume(s2, p, o);
            }
            if (this.isOpLax(s2) && this.isOpLax(o)) {
                this.add(this.df.getOWLDisjointObjectPropertiesAxiom(CollectionFactory.createSet(new OWLObjectPropertyExpression[]{this.op(s2), this.op(o)}), this.anns()));
                this.consume(s2, p, o);
            }
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.inferTypes(s2, o);
            return false;
        }
    }

    static class TPPropertyChainAxiomHandler
    extends AbstractTriplePredicateHandler {
        TPPropertyChainAxiomHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_PROPERTY_CHAIN_AXIOM.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addOp(o, false);
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            OWLObjectPropertyExpression superProp = this.op(s2);
            List<OWLObjectPropertyExpression> chain = this.consumer.translatorAccessor.translateToObjectPropertyList(o);
            this.consume(s2, p, o);
            this.add(this.df.getOWLSubPropertyChainOfAxiom(chain, superProp, this.anns()));
        }
    }

    static class TPOneOfHandler
    extends AbstractNamedEquivalentClassAxiomHandler {
        TPOneOfHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ONE_OF.getIRI());
        }

        @Override
        protected OWLClassExpression translateEquivalentClass(IRI mainNode) {
            return this.df.getOWLObjectOneOf(this.consumer.translatorAccessor.translateToIndividualSet(mainNode));
        }
    }

    static class TPOnPropertyHandler
    extends AbstractTriplePredicateHandler {
        TPOnPropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addR(s2, false);
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
        }
    }

    static class TPOnDataRangeHandler
    extends AbstractTriplePredicateHandler {
        TPOnDataRangeHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return false;
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addDR(o, true);
            return false;
        }
    }

    static class TPOnClassHandler
    extends AbstractTriplePredicateHandler {
        TPOnClassHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addCe(o, false);
            return false;
        }
    }

    static class TPInverseOfHandler
    extends AbstractTriplePredicateHandler {
        private boolean axiomParsingMode = false;

        TPInverseOfHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_INVERSE_OF.getIRI());
        }

        public boolean isAxiomParsingMode() {
            return this.axiomParsingMode;
        }

        public void setAxiomParsingMode(boolean axiomParsingMode) {
            this.axiomParsingMode = axiomParsingMode;
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addOp(s2, false);
            this.addOp(o, false);
            return false;
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return super.canHandle(s2, p, o) && this.isOpLax(s2) && this.isOpLax(o);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.axiomParsingMode && this.isOpLax(s2) && this.isOpLax(o)) {
                this.add(this.df.getOWLInverseObjectPropertiesAxiom(this.op(s2), this.op(o), this.anns()));
                this.consume(s2, p, o);
            }
        }
    }

    static class TPIntersectionOfHandler
    extends AbstractNamedEquivalentClassAxiomHandler {
        TPIntersectionOfHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI());
        }

        @Override
        protected OWLClassExpression translateEquivalentClass(IRI mainNode) {
            return this.df.getOWLObjectIntersectionOf(this.consumer.translatorAccessor.translateToClassExpressionSet(mainNode));
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            if (this.isCe(s2)) {
                this.addCe(o, false);
            } else if (this.isCe(o)) {
                this.addCe(s2, false);
            } else if (this.isDr(s2)) {
                this.addDR(o, false);
            } else if (this.isDr(o)) {
                this.addDR(s2, false);
            }
            return super.canHandleStreaming(s2, p, o);
        }
    }

    static class TPImportsHandler
    extends AbstractTriplePredicateHandler {
        TPImportsHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_IMPORTS.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return true;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
            this.consumer.addOntology(s2);
            this.consumer.addOntology(o);
            OWLImportsDeclaration id = this.df.getOWLImportsDeclaration(o);
            this.consumer.addImport(id);
            if (!this.consumer.getConfiguration().isIgnoredImport(o)) {
                OWLOntologyManager man = this.consumer.getOWLOntologyManager();
                man.makeLoadImportRequest(id, this.consumer.getConfiguration());
                this.handleImportingRDFGraphRatherThanOntology(id, man, man.getImportedOntology(id));
                this.consumer.importsClosureChanged();
            }
        }

        protected void handleImportingRDFGraphRatherThanOntology(OWLImportsDeclaration id, OWLOntologyManager man, @Nullable OWLOntology io) {
            OWLDocumentFormat importedOntologyFormat;
            if (io != null && (importedOntologyFormat = io.getFormat()) instanceof AbstractRDFPrefixDocumentFormat && io.isAnonymous() && this.consumer.getConfiguration().getMissingOntologyHeaderStrategy() == MissingOntologyHeaderStrategy.INCLUDE_GRAPH) {
                man.applyChange(new RemoveImport(this.consumer.getOntology(), id));
                io.importsDeclarations().forEach(d -> this.addImport(man, (OWLImportsDeclaration)d));
                io.annotations().forEach(ann -> this.addOntAnn(man, (OWLAnnotation)ann));
                io.axioms().forEach(this::add);
                man.removeOntology(io);
            }
        }
    }

    static class TPHasValueHandler
    extends AbstractTriplePredicateHandler {
        TPHasValueHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addR(s2, false);
            return false;
        }
    }

    static class TPHasKeyHandler
    extends AbstractTriplePredicateHandler {
        private final OptimisedListTranslator<OWLPropertyExpression> listTranslator;

        TPHasKeyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_HAS_KEY.getIRI());
            this.listTranslator = Translators.getListTranslator(consumer);
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addCe(s2, false);
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isCe(s2)) {
                this.consume(s2, p, o);
                OWLClassExpression ce = this.ce(s2);
                Set<OWLPropertyExpression> props = this.listTranslator.translateToSet(o);
                this.add(this.df.getOWLHasKeyAxiom(ce, props, this.anns()));
            }
        }
    }

    static class TPFirstResourceHandler
    extends AbstractTriplePredicateHandler {
        TPFirstResourceHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.RDF_FIRST.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return true;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consumer.addFirst(s2, o);
            this.consume(s2, p, o);
        }
    }

    static class TPFirstLiteralHandler
    extends AbstractTripleHandler
    implements LiteralTripleHandler {
        TPFirstLiteralHandler(OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public boolean canHandle(IRI s2, @Nullable IRI p, OWLLiteral o) {
            return p != null && p.equals(OWLRDFVocabulary.RDF_FIRST.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, @Nullable IRI p, OWLLiteral o) {
            return p != null && p.equals(OWLRDFVocabulary.RDF_FIRST.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, OWLLiteral o) {
            this.consumer.addFirst(s2, o);
            this.consume(s2, p, o);
        }
    }

    static class TPEquivalentPropertyHandler
    extends AbstractTriplePredicateHandler {
        TPEquivalentPropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            Set<OWLAnnotation> anns = this.anns();
            if (this.isOpLax(s2) && this.isOpLax(o)) {
                this.add(this.df.getOWLEquivalentObjectPropertiesAxiom(Arrays.asList(this.op(s2), this.op(o)), anns));
                this.consume(s2, p, o);
            }
            if (this.isDPLax(s2) && this.isDPLax(o)) {
                this.add(this.df.getOWLEquivalentDataPropertiesAxiom(Arrays.asList(this.dp(s2), this.dp(o)), anns));
                this.consume(s2, p, o);
            }
        }
    }

    static class TPEquivalentClassHandler
    extends AbstractTriplePredicateHandler {
        TPEquivalentClassHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI());
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            this.inferTypes(s2, o);
            return super.canHandle(s2, p, o) && this.bothClassOrDataRange(s2, o);
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.inferTypes(s2, o);
            return !this.isStrict() && !this.eitherAnon(s2, o) && this.bothClassOrDataRange(s2, o);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isStrict()) {
                if (this.isClassExpressionStrict(s2) && this.isClassExpressionStrict(o)) {
                    this.translateEquivalentClasses(s2, p, o);
                } else if (this.isDataRangeStrict(s2) && this.isDataRangeStrict(o)) {
                    this.translateEquivalentDataRanges(s2, p, o);
                }
            } else if (this.isCeLax(s2) && this.isCeLax(o)) {
                this.translateEquivalentClasses(s2, p, o);
            } else if (this.isDrLax(s2) || this.isDrLax(o)) {
                this.translateEquivalentDataRanges(s2, p, o);
            }
        }

        private void translateEquivalentDataRanges(IRI s2, IRI p, IRI o) {
            OWLDatatype datatype = this.df.getOWLDatatype(s2);
            OWLDataRange dataRange = this.dr(o);
            OWLDatatypeDefinitionAxiom def = this.df.getOWLDatatypeDefinitionAxiom(datatype, dataRange, this.anns());
            this.add(def);
            this.consume(s2, p, o);
        }

        private void translateEquivalentClasses(IRI s2, IRI p, IRI o) {
            this.add(this.df.getOWLEquivalentClassesAxiom(Arrays.asList(this.ce(s2), this.ce(o)), this.anns()));
            this.consume(s2, p, o);
        }
    }

    static class TPDisjointWithHandler
    extends AbstractTriplePredicateHandler {
        TPDisjointWithHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addCe(s2, false);
            this.addCe(o, false);
            return !this.eitherAnon(s2, o) && this.bothCe(s2, o);
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return super.canHandle(s2, p, o) && this.bothCe(s2, o);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.add(this.df.getOWLDisjointClassesAxiom(Arrays.asList(this.ce(s2), this.ce(o)), this.anns()));
            this.consume(s2, p, o);
        }
    }

    static class TPDisjointUnionHandler
    extends AbstractTriplePredicateHandler {
        TPDisjointUnionHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DISJOINT_UNION_OF.getIRI());
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return super.canHandle(s2, p, o) && !this.isAnon(s2) && this.isCe(s2);
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addCe(s2, false);
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (!this.isAnon(s2)) {
                OWLClass cls = (OWLClass)this.ce(s2);
                Set<OWLClassExpression> classExpressions = this.consumer.translatorAccessor.translateToClassExpressionSet(o);
                this.add(this.df.getOWLDisjointUnionAxiom(cls, classExpressions, this.anns()));
                this.consume(s2, p, o);
            }
        }
    }

    static class TPDifferentFromHandler
    extends AbstractTriplePredicateHandler {
        TPDifferentFromHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DIFFERENT_FROM.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return true;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.add(this.df.getOWLDifferentIndividualsAxiom(Arrays.asList(this.ind(s2), this.ind(o)), this.anns()));
            this.consume(s2, p, o);
        }
    }

    static class TPDeclaredAsHandler
    extends AbstractTriplePredicateHandler {
        TPDeclaredAsHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DECLARED_AS.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return true;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (o.equals(OWLRDFVocabulary.OWL_CLASS.getIRI())) {
                this.add(this.df.getOWLDeclarationAxiom(this.df.getOWLClass(s2), this.anns()));
            } else if (o.equals(OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI())) {
                this.add(this.df.getOWLDeclarationAxiom(this.df.getOWLObjectProperty(s2), this.anns()));
            } else if (o.equals(OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI())) {
                this.add(this.df.getOWLDeclarationAxiom(this.df.getOWLDataProperty(s2), this.anns()));
            } else if (o.equals(OWLRDFVocabulary.OWL_DATATYPE.getIRI())) {
                this.add(this.df.getOWLDeclarationAxiom(this.df.getOWLDatatype(s2), this.anns()));
            }
        }
    }

    static class TPDatatypeComplementOfHandler
    extends AbstractTriplePredicateHandler {
        TPDatatypeComplementOfHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_DATATYPE_COMPLEMENT_OF.getIRI());
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addDR(s2, false);
            this.addDR(o, false);
            return false;
        }
    }

    static class TPComplementOfHandler
    extends AbstractNamedEquivalentClassAxiomHandler {
        TPComplementOfHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addCe(s2, false);
            this.addCe(o, false);
            return super.canHandleStreaming(s2, p, o);
        }

        @Override
        protected OWLClassExpression translateEquivalentClass(IRI mainNode) {
            return this.df.getOWLObjectComplementOf(this.ce(mainNode));
        }
    }

    static class TPAnnotatedTargetHandler
    extends AbstractTriplePredicateHandler {
        TPAnnotatedTargetHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.consumer.addAnnotatedSource(o, s2);
            this.consumer.checkForAndProcessAnnotatedDeclaration(s2);
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
        }
    }

    static class TPAnnotatedSourceHandler
    extends AbstractTriplePredicateHandler {
        TPAnnotatedSourceHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.consumer.addAnnotatedSource(o, s2);
            this.consumer.checkForAndProcessAnnotatedDeclaration(s2);
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
        }
    }

    static class TPAnnotatedPropertyHandler
    extends AbstractTriplePredicateHandler {
        TPAnnotatedPropertyHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.consumer.addAnnotatedSource(o, s2);
            this.consumer.checkForAndProcessAnnotatedDeclaration(s2);
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
        }
    }

    static class TPAllValuesFromHandler
    extends AbstractTriplePredicateHandler {
        TPAllValuesFromHandler(OWLRDFConsumer consumer) {
            super(consumer, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI());
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            this.addR(s2, false);
            IRI propIRI = this.getResourceObject(s2, OWLRDFVocabulary.OWL_ON_PROPERTY);
            if (!(propIRI == null || this.isAnon(o) && this.consumer.translatorAccessor.getClassExpressionIfTranslated(o) == null)) {
                if (this.isObjectPropertyStrict(propIRI)) {
                    this.addCe(o, false);
                    this.consumer.addTriple(s2, p, o);
                    this.ce(s2);
                    return true;
                }
                if (this.isDataPropertyStrict(propIRI)) {
                    // empty if block
                }
            }
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
        }
    }

    static class SKOSClassTripleHandler
    extends AbstractBuiltInTypeHandler {
        SKOSClassTripleHandler(OWLRDFConsumer consumer, SKOSVocabulary v) {
            super(consumer, v.getIRI());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            OWLNamedIndividual ind = this.df.getOWLNamedIndividual(s2);
            OWLClass skosConcept = this.df.getOWLClass(o);
            this.add(this.df.getOWLClassAssertionAxiom(skosConcept, ind));
        }
    }

    static class GTPResourceTripleHandler
    extends AbstractResourceTripleHandler {
        GTPResourceTripleHandler(OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return false;
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return false;
        }
    }

    static class GTPObjectPropertyAssertionHandler
    extends AbstractResourceTripleHandler {
        GTPObjectPropertyAssertionHandler(OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            if (this.isStrict()) {
                return this.isObjectPropertyStrict(p);
            }
            return this.isOpLax(p) && !this.isAnnotationPropertyOnly(p);
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            if (this.isOpLax(p)) {
                this.consume(s2, p, o);
                this.add(this.df.getOWLObjectPropertyAssertionAxiom(this.op(p), this.ind(s2), this.ind(o), this.anns()));
            }
        }
    }

    static class GTPLiteralTripleHandler
    extends AbstractTripleHandler
    implements LiteralTripleHandler {
        GTPLiteralTripleHandler(OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, OWLLiteral o) {
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, OWLLiteral o) {
            if (this.isStrict()) {
                return false;
            }
            return this.isApLax(p);
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, OWLLiteral o) {
            return this.isAnnotationPropertyOnly(p) || this.isDataPropertyStrict(p);
        }
    }

    static class GTPDataPropertyAssertionHandler
    extends AbstractTripleHandler
    implements LiteralTripleHandler {
        GTPDataPropertyAssertionHandler(OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, OWLLiteral o) {
            if (this.isStrict()) {
                return this.isDataPropertyStrict(p);
            }
            return this.isDPLax(p) && !this.isApLax(p);
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, OWLLiteral o) {
            return false;
        }

        @Override
        public void handleTriple(IRI s2, IRI p, OWLLiteral o) {
            this.add(this.df.getOWLDataPropertyAssertionAxiom(this.dp(p), this.ind(s2), o, this.anns()));
            this.consume(s2, p, o);
        }
    }

    static class GTPAnnotationResourceTripleHandler
    extends AbstractResourceTripleHandler {
        GTPAnnotationResourceTripleHandler(OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return false;
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return !this.consumer.isAxiom(s2) && !this.consumer.isAnnotation(s2) && (OWLRDFVocabulary.BUILT_IN_AP_IRIS.contains(p) || !p.isReservedVocabulary());
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            OWLAnnotationSubject value = this.isAnon(o) ? this.consumer.getOWLAnonymousIndividual(o.toString()) : o;
            OWLAnnotationSubject subject = this.getSubject(s2);
            OWLAnnotationProperty prop = this.df.getOWLAnnotationProperty(p);
            if (this.consumer.isOntology(s2)) {
                this.anns(s2);
                Set<OWLAnnotation> anns = this.anns();
                anns.forEach(this.consumer::addOntologyAnnotation);
                if (anns.isEmpty()) {
                    this.consumer.addOntologyAnnotation(this.df.getOWLAnnotation(prop, o));
                }
            } else {
                this.add(this.df.getOWLAnnotationAssertionAxiom(subject, this.df.getOWLAnnotation(prop, (OWLAnnotationValue)((Object)value), this.anns())));
            }
            this.consume(s2, p, o);
        }
    }

    static class GTPAnnotationLiteralHandler
    extends AbstractTripleHandler
    implements LiteralTripleHandler {
        GTPAnnotationLiteralHandler(OWLRDFConsumer consumer) {
            super(consumer);
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, OWLLiteral o) {
            return false;
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, OWLLiteral o) {
            if (this.isStrict()) {
                return this.isAnnotationPropertyOnly(p);
            }
            if (this.consumer.isAxiom(s2) || this.consumer.isAnnotation(s2)) {
                return false;
            }
            if (this.isApLax(p) || this.isAnon(s2)) {
                return true;
            }
            return this.isCeLax(s2) || this.isDrLax(s2) || this.isOpLax(s2) || this.isDPLax(s2);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, OWLLiteral o) {
            OWLAnnotationProperty prop = this.df.getOWLAnnotationProperty(p);
            if (this.consumer.isOntology(s2)) {
                this.anns(s2);
                Set<OWLAnnotation> anns = this.anns();
                anns.forEach(this.consumer::addOntologyAnnotation);
                if (anns.isEmpty()) {
                    this.consumer.addOntologyAnnotation(this.df.getOWLAnnotation(prop, o));
                }
            } else {
                this.add(this.df.getOWLAnnotationAssertionAxiom(prop, this.getSubject(s2), o, this.anns()));
            }
            this.consume(s2, p, o);
        }
    }

    static abstract class AbstractBuiltInTypeHandler
    extends AbstractTriplePredicateHandler
    implements BuiltInTypeHandler {
        private final IRI typeIRI;

        protected AbstractBuiltInTypeHandler(OWLRDFConsumer consumer, IRI typeIRI) {
            super(consumer, OWLRDFVocabulary.RDF_TYPE.getIRI());
            this.typeIRI = typeIRI;
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return true;
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return p.equals(OWLRDFVocabulary.RDF_TYPE.getIRI()) && o.equals(this.typeIRI);
        }

        @Override
        public IRI getTypeIRI() {
            return this.typeIRI;
        }
    }

    static class AbstractTripleHandler {
        protected final OWLRDFConsumer consumer;
        protected final OWLDataFactory df;
        private final TypeMatcher ceMatcher = this::isClassExpressionStrict;
        private final TypeMatcher drMatcher = this::isDataRangeStrict;
        private final TypeMatcher indMatcher = node -> true;

        protected AbstractTripleHandler(OWLRDFConsumer consumer) {
            this.consumer = consumer;
            this.df = consumer.getDataFactory();
        }

        public OWLAnnotationSubject getSubject(IRI s2) {
            if (this.isAnon(s2)) {
                return this.consumer.getOWLAnonymousIndividual(s2.toString());
            }
            return s2;
        }

        protected Set<OWLAnnotation> anns() {
            return this.consumer.getPendingAnnotations();
        }

        protected void consume(IRI s2, IRI p, IRI o) {
            this.consumer.consumeTriple(s2, p, o);
        }

        protected void consume(IRI s2, IRI p, OWLLiteral o) {
            this.consumer.consumeTriple(s2, p, o);
        }

        public Set<OWLDataPropertyExpression> dps(IRI listNode) {
            return new HashSet<OWLDataPropertyExpression>(this.consumer.translatorAccessor.translateToDataPropertyList(listNode));
        }

        public Set<OWLObjectPropertyExpression> ops(IRI listNode) {
            return new HashSet<OWLObjectPropertyExpression>(this.consumer.translatorAccessor.translateToObjectPropertyList(listNode));
        }

        protected boolean isStrict() {
            return this.consumer.getConfiguration().isStrict();
        }

        protected boolean isAnnotationPropertyOnly(IRI iri) {
            return this.consumer.isAnnotationPropertyOnly(iri);
        }

        protected boolean isApLax(IRI iri) {
            return this.consumer.isAnnotationProperty(iri);
        }

        protected boolean isCe(IRI iri) {
            return this.consumer.isClassExpression(iri);
        }

        protected boolean isDr(IRI iri) {
            return this.consumer.isDataRange(iri);
        }

        protected void addImport(OWLOntologyManager man, OWLImportsDeclaration i) {
            man.applyChange(new AddImport(this.consumer.getOntology(), i));
        }

        protected void addOntAnn(OWLOntologyManager man, OWLAnnotation ann) {
            man.applyChange(new AddOntologyAnnotation(this.consumer.getOntology(), ann));
        }

        protected void add(OWLAxiom axiom) {
            this.consumer.addAxiom(axiom);
        }

        protected void anns(IRI s2) {
            this.consumer.addPendingAnnotations(this.consumer.translateAnnotations(s2));
        }

        protected void addCe(IRI iri, boolean explicitlyTyped) {
            this.consumer.addClassExpression(iri, explicitlyTyped);
        }

        protected void addDR(IRI iri, boolean explicitlyTyped) {
            this.consumer.addDataRange(iri, explicitlyTyped);
        }

        protected void addAp(IRI iri, boolean explicitlyTyped) {
            this.consumer.addAnnotationProperty(iri, explicitlyTyped);
        }

        protected void addOp(IRI iri, boolean explicitlyTyped) {
            this.consumer.addObjectProperty(iri, explicitlyTyped);
        }

        protected void addDp(IRI iri, boolean explicitlyTyped) {
            this.consumer.addDataProperty(iri, explicitlyTyped);
        }

        protected void addR(IRI iri, boolean explicitlyTyped) {
            this.consumer.addOWLRestriction(iri, explicitlyTyped);
        }

        protected OWLClassExpression ce(IRI iri) {
            return this.consumer.translatorAccessor.translateClassExpression(iri);
        }

        protected OWLObjectPropertyExpression op(IRI iri) {
            return this.consumer.translateObjectPropertyExpression(iri);
        }

        protected OWLDataPropertyExpression dp(IRI iri) {
            return this.consumer.translateDataPropertyExpression(iri);
        }

        protected OWLDataRange dr(IRI iri) {
            return this.consumer.translateDataRange(iri);
        }

        protected OWLIndividual ind(IRI iri) {
            return this.consumer.translateIndividual(iri);
        }

        protected boolean isAnon(IRI node) {
            return this.consumer.isAnonymousNode(node);
        }

        protected boolean isResourcePresent(IRI mainNode, OWLRDFVocabulary p) {
            return this.getResourceObject(mainNode, p) != null;
        }

        @Nullable
        protected IRI getResourceObject(IRI mainNode, OWLRDFVocabulary p) {
            return this.consumer.getResourceObject(mainNode, p, false);
        }

        @Nullable
        protected IRI getRO(IRI mainNode, OWLRDFVocabulary p) {
            return this.consumer.getResourceObject(mainNode, p, true);
        }

        protected boolean isLiteralPresent(IRI mainNode, OWLRDFVocabulary p) {
            return this.consumer.getLiteralObject(mainNode, p, false) != null;
        }

        protected boolean isNonNegativeIntegerStrict(IRI mainNode, OWLRDFVocabulary p) {
            OWLLiteral literal = this.consumer.getLiteralObject(mainNode, p, false);
            if (literal == null) {
                return false;
            }
            return OWL2Datatype.XSD_NON_NEGATIVE_INTEGER.matches(literal.getDatatype()) && OWL2Datatype.XSD_NON_NEGATIVE_INTEGER.isInLexicalSpace(literal.getLiteral());
        }

        protected boolean isNonNegativeIntegerLax(IRI mainNode, OWLRDFVocabulary p) {
            OWLLiteral literal = this.consumer.getLiteralObject(mainNode, p, false);
            if (literal == null) {
                return false;
            }
            return OWL2Datatype.XSD_INTEGER.isInLexicalSpace(OWLAPIPreconditions.verifyNotNull(literal.getLiteral().trim()));
        }

        protected int integer(IRI mainNode, OWLRDFVocabulary p) {
            OWLLiteral literal = this.consumer.getLiteralObject(mainNode, p, true);
            if (literal == null) {
                return 0;
            }
            try {
                return Integer.parseInt(literal.getLiteral().trim());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        protected boolean isClassExpressionStrict(IRI node) {
            return this.isCe(node) && !this.isDr(node);
        }

        protected boolean isClassExpressionStrict(IRI mainNode, OWLRDFVocabulary p) {
            IRI o = this.getResourceObject(mainNode, p);
            return o != null && this.isClassExpressionStrict(o);
        }

        protected boolean isCeLax(IRI mainNode) {
            return this.isCe(mainNode) || this.consumer.isParsedAllTriples() && !this.isDr(mainNode);
        }

        protected boolean isClassExpressionLax(IRI mainNode, OWLRDFVocabulary p) {
            IRI o = this.getResourceObject(mainNode, p);
            return o != null && this.isCeLax(o);
        }

        protected boolean isObjectPropertyStrict(IRI node) {
            return this.consumer.isObjectPropertyOnly(node);
        }

        protected boolean isObjectPropertyStrict(IRI mainNode, OWLRDFVocabulary p) {
            IRI o = this.getResourceObject(mainNode, p);
            return o != null && this.isObjectPropertyStrict(o);
        }

        protected boolean isOpLax(@Nullable IRI node) {
            if (node == null) {
                return false;
            }
            return this.consumer.isObjectProperty(node);
        }

        protected boolean isObjectPropertyLax(IRI mainNode, OWLRDFVocabulary p) {
            IRI o = this.getResourceObject(mainNode, p);
            return o != null && this.isOpLax(o);
        }

        protected boolean isDataPropertyStrict(IRI node) {
            return this.consumer.isDataPropertyOnly(node);
        }

        protected boolean isDataPropertyStrict(IRI mainNode, OWLRDFVocabulary p) {
            IRI o = this.getResourceObject(mainNode, p);
            return o != null && this.isDataPropertyStrict(o);
        }

        protected boolean isDPLax(IRI node) {
            return this.consumer.isDataProperty(node);
        }

        protected boolean isDPLax(IRI mainNode, OWLRDFVocabulary p) {
            IRI o = this.getResourceObject(mainNode, p);
            return o != null && this.isDPLax(o);
        }

        protected boolean isDataRangeStrict(@Nullable IRI node) {
            return node != null && this.isDr(node) && !this.isCe(node);
        }

        protected boolean isDataRangeStrict(IRI mainNode, OWLRDFVocabulary p) {
            IRI o = this.getResourceObject(mainNode, p);
            return this.isDataRangeStrict(o);
        }

        protected boolean isDrLax(IRI node) {
            return this.isDr(node);
        }

        protected boolean isDataRangeLax(IRI mainNode, OWLRDFVocabulary p) {
            IRI o = this.getResourceObject(mainNode, p);
            return o != null && this.isDrLax(mainNode);
        }

        protected boolean isClassExpressionListStrict(IRI mainNode, int minSize) {
            return this.isResourceListStrict(mainNode, this.ceMatcher, minSize);
        }

        protected boolean isDataRangeListStrict(IRI mainNode, int minSize) {
            return this.isResourceListStrict(mainNode, this.drMatcher, minSize);
        }

        protected boolean isIndividualListStrict(IRI mainNode, int minSize) {
            return this.isResourceListStrict(mainNode, this.indMatcher, minSize);
        }

        protected boolean isResourceListStrict(@Nullable IRI mainNode, TypeMatcher typeMatcher, int minSize) {
            if (mainNode == null) {
                return false;
            }
            IRI currentListNode = mainNode;
            HashSet<IRI> visitedListNodes = new HashSet<IRI>();
            int size = 0;
            IRI firstObject;
            while ((firstObject = this.getResourceObject(currentListNode, OWLRDFVocabulary.RDF_FIRST)) != null) {
                if (!typeMatcher.isTypeStrict(firstObject)) {
                    return false;
                }
                ++size;
                IRI restObject = this.getResourceObject(currentListNode, OWLRDFVocabulary.RDF_REST);
                if (visitedListNodes.contains(restObject)) {
                    return false;
                }
                if (restObject == null) {
                    return false;
                }
                if (restObject.equals(OWLRDFVocabulary.RDF_NIL.getIRI())) {
                    return size >= minSize;
                }
                visitedListNodes.add(restObject);
                currentListNode = restObject;
            }
            return false;
        }
    }

    static abstract class AbstractResourceTripleHandler
    extends AbstractTripleHandler
    implements ResourceTripleHandler {
        protected AbstractResourceTripleHandler(OWLRDFConsumer consumer) {
            super(consumer);
        }

        protected boolean eitherAnon(IRI s2, IRI o) {
            return this.isAnon(s2) || this.isAnon(o);
        }

        protected boolean bothClassOrDataRange(IRI s2, IRI o) {
            return this.bothCe(s2, o) || this.bothDataRange(s2, o);
        }

        protected boolean bothDataRange(IRI s2, IRI o) {
            return this.isDr(s2) && this.isDr(o);
        }

        protected boolean bothCe(IRI s2, IRI o) {
            return this.isCe(s2) && this.isCe(o);
        }

        protected void inferTypes(IRI s2, IRI o) {
            if (this.isCe(o)) {
                this.addCe(s2, false);
            } else if (this.isDr(o)) {
                this.addDR(s2, false);
            } else if (this.isCe(s2)) {
                this.addCe(o, false);
            } else if (this.isDr(s2)) {
                this.addDR(o, false);
            }
        }
    }

    static abstract class AbstractNamedEquivalentClassAxiomHandler
    extends AbstractTriplePredicateHandler {
        AbstractNamedEquivalentClassAxiomHandler(OWLRDFConsumer consumer, IRI predicateIRI) {
            super(consumer, predicateIRI);
        }

        @Override
        public boolean canHandleStreaming(IRI s2, IRI p, IRI o) {
            return false;
        }

        @Override
        public boolean canHandle(IRI s2, IRI p, IRI o) {
            return super.canHandle(s2, p, o) && !this.isAnon(s2);
        }

        @Override
        public void handleTriple(IRI s2, IRI p, IRI o) {
            this.consume(s2, p, o);
            this.add(this.df.getOWLEquivalentClassesAxiom(Arrays.asList(this.ce(s2), this.translateEquivalentClass(o))));
        }

        protected abstract OWLClassExpression translateEquivalentClass(IRI var1);
    }

    static class HandlerAccessor {
        protected final Map<IRI, BuiltInTypeHandler> axiomTypes;
        protected final Map<IRI, TriplePredicateHandler> predicates;
        protected final List<LiteralTripleHandler> literals;
        protected final List<ResourceTripleHandler> resources;
        protected final TPInverseOfHandler inverseOf;
        protected final OWLRDFConsumer consumer;
        private final Map<IRI, BuiltInTypeHandler> builtInTypes;
        private final TPTypeHandler nonBuiltInTypes;

        HandlerAccessor(OWLRDFConsumer r) {
            this.consumer = r;
            this.builtInTypes = HandlerAccessor.getBasicTypeHandlers(r, r.getConfiguration());
            this.axiomTypes = HandlerAccessor.getAxiomTypeHandlers(r);
            this.inverseOf = new TPInverseOfHandler(r);
            this.nonBuiltInTypes = new TPTypeHandler(r);
            this.predicates = this.getPredicateHandlers(r);
            this.literals = HandlerAccessor.getLiteralTripleHandlers(r);
            this.resources = HandlerAccessor.getResourceTripleHandlers(r);
        }

        private static List<ResourceTripleHandler> getResourceTripleHandlers(OWLRDFConsumer r) {
            return CollectionFactory.list(new ResourceTripleHandler[]{new GTPObjectPropertyAssertionHandler(r), new GTPAnnotationResourceTripleHandler(r)});
        }

        public static Map<IRI, BuiltInTypeHandler> getAxiomTypeHandlers(OWLRDFConsumer r) {
            ConcurrentHashMap<IRI, BuiltInTypeHandler> map = new ConcurrentHashMap<IRI, BuiltInTypeHandler>();
            HandlerAccessor.add(map, new TypeAxiomHandler(r));
            HandlerAccessor.add(map, new TypeAllDifferentHandler(r));
            HandlerAccessor.add(map, new TypeAllDisjointClassesHandler(r));
            HandlerAccessor.add(map, new TypeAllDisjointPropertiesHandler(r));
            HandlerAccessor.add(map, new TypeNegativePropertyAssertionHandler(r));
            return map;
        }

        public static List<LiteralTripleHandler> getLiteralTripleHandlers(OWLRDFConsumer r) {
            return CollectionFactory.list(new LiteralTripleHandler[]{new GTPDataPropertyAssertionHandler(r), new TPFirstLiteralHandler(r), new GTPAnnotationLiteralHandler(r)});
        }

        private static void add(Map<IRI, BuiltInTypeHandler> m3, BuiltInTypeHandler h2) {
            m3.put(h2.getTypeIRI(), h2);
        }

        private static void add(Map<IRI, TriplePredicateHandler> map, TriplePredicateHandler h2) {
            map.put(h2.getPredicateIRI(), h2);
        }

        public static Map<IRI, BuiltInTypeHandler> getBasicTypeHandlers(OWLRDFConsumer r, OWLOntologyLoaderConfiguration config) {
            ConcurrentHashMap<IRI, BuiltInTypeHandler> map = new ConcurrentHashMap<IRI, BuiltInTypeHandler>();
            HandlerAccessor.add(map, new TypeOntologyPropertyHandler(r));
            HandlerAccessor.add(map, new TypeAsymmetricPropertyHandler(r));
            HandlerAccessor.add(map, new TypeClassHandler(r));
            HandlerAccessor.add(map, new TypeObjectPropertyHandler(r));
            HandlerAccessor.add(map, new TypeDataPropertyHandler(r));
            HandlerAccessor.add(map, new TypeDatatypeHandler(r));
            HandlerAccessor.add(map, new TypeFunctionalPropertyHandler(r));
            HandlerAccessor.add(map, new TypeInverseFunctionalPropertyHandler(r));
            HandlerAccessor.add(map, new TypeIrreflexivePropertyHandler(r));
            HandlerAccessor.add(map, new TypeReflexivePropertyHandler(r));
            HandlerAccessor.add(map, new TypeSymmetricPropertyHandler(r));
            HandlerAccessor.add(map, new TypeTransitivePropertyHandler(r));
            HandlerAccessor.add(map, new TypeRestrictionHandler(r));
            HandlerAccessor.add(map, new TypeListHandler(r));
            HandlerAccessor.add(map, new TypeAnnotationPropertyHandler(r));
            HandlerAccessor.add(map, new TypeDeprecatedClassHandler(r));
            HandlerAccessor.add(map, new TypeDeprecatedPropertyHandler(r));
            HandlerAccessor.add(map, new TypeDataRangeHandler(r));
            HandlerAccessor.add(map, new TypeOntologyHandler(r));
            HandlerAccessor.add(map, new TypeNegativeDataPropertyAssertionHandler(r));
            HandlerAccessor.add(map, new TypeRDFSClassHandler(r));
            HandlerAccessor.add(map, new TypeSelfRestrictionHandler(r));
            HandlerAccessor.add(map, new TypePropertyHandler(r));
            HandlerAccessor.add(map, new TypeNamedIndividualHandler(r));
            HandlerAccessor.add(map, new TypeAnnotationHandler(r));
            if (!config.isStrict()) {
                HandlerAccessor.add(map, new TypeSWRLAtomListHandler(r));
                HandlerAccessor.add(map, new TypeSWRLBuiltInAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLBuiltInHandler(r));
                HandlerAccessor.add(map, new TypeSWRLClassAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLDataRangeAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLDataValuedPropertyAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLDifferentIndividualsAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLImpHandler(r));
                HandlerAccessor.add(map, new TypeSWRLIndividualPropertyAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLSameIndividualAtomHandler(r));
                HandlerAccessor.add(map, new TypeSWRLVariableHandler(r));
            }
            return map;
        }

        void apply(IRI s2, IRI p, OWLLiteral o) {
            if (OWLRDFConsumer.isGeneralPredicate(p)) {
                for (LiteralTripleHandler lhandler : this.literals) {
                    if (!lhandler.canHandle(s2, p, o)) continue;
                    lhandler.handleTriple(s2, p, o);
                    return;
                }
            }
        }

        void apply(IRI s2, IRI p, IRI o) {
            if (OWLRDFConsumer.isGeneralPredicate(p)) {
                for (ResourceTripleHandler handler : this.resources) {
                    if (!handler.canHandle(s2, p, o)) continue;
                    handler.handleTriple(s2, p, o);
                    return;
                }
            }
        }

        void applyAnns(IRI s2, IRI p, IRI o) {
            BuiltInTypeHandler handler = this.axiomTypes.get(o);
            if (handler != null && handler.canHandle(s2, p, o)) {
                handler.handleTriple(s2, p, o);
            }
        }

        public void consumeNonReservedPredicateTriples() {
            this.consumer.iterateResources(this::apply);
            this.consumer.iterateLiterals(this::apply);
        }

        public void consumeAnnotatedAxioms() {
            this.consumer.iterateResources(this::applyAnns);
        }

        public void handleStreaming(IRI s2, IRI p, IRI o) {
            boolean consumed;
            block4: {
                block6: {
                    block2: {
                        block5: {
                            block3: {
                                consumed = false;
                                if (!p.equals(OWLRDFVocabulary.RDF_TYPE.getIRI())) break block2;
                                BuiltInTypeHandler handler = this.builtInTypes.get(o);
                                if (handler == null) break block3;
                                if (!handler.canHandleStreaming(s2, p, o)) break block4;
                                handler.handleTriple(s2, p, o);
                                consumed = true;
                                break block4;
                            }
                            if (this.axiomTypes.get(o) != null) break block5;
                            this.consumer.addOWLNamedIndividual(s2, false);
                            if (!this.nonBuiltInTypes.canHandleStreaming(s2, p, o)) break block4;
                            this.nonBuiltInTypes.handleTriple(s2, p, o);
                            consumed = true;
                            break block4;
                        }
                        this.consumer.addAxiom(s2);
                        break block4;
                    }
                    ResourceTripleHandler handler = this.predicates.get(p);
                    if (handler == null) break block6;
                    if (!handler.canHandleStreaming(s2, p, o)) break block4;
                    handler.handleTriple(s2, p, o);
                    consumed = true;
                    break block4;
                }
                for (ResourceTripleHandler r : this.resources) {
                    if (!r.canHandleStreaming(s2, p, o)) continue;
                    r.handleTriple(s2, p, o);
                    consumed = true;
                    break;
                }
            }
            if (!consumed) {
                this.consumer.addTriple(s2, p, o);
            }
        }

        public void handleStreaming(IRI s2, IRI p, String literal, @Nullable IRI datatype, @Nullable String lang) {
            OWLLiteral con = this.consumer.getOWLLiteral(literal, datatype, lang);
            this.handleStreaming(s2, p, con);
        }

        private void handleStreaming(IRI s2, IRI p, OWLLiteral con) {
            for (LiteralTripleHandler handler : this.literals) {
                if (!handler.canHandleStreaming(s2, p, con)) continue;
                handler.handleTriple(s2, p, con);
                return;
            }
            this.consumer.addTriple(s2, p, con);
        }

        protected void handle(IRI s2, IRI p, IRI o) {
            block5: {
                block3: {
                    block4: {
                        if (!p.equals(OWLRDFVocabulary.RDF_TYPE.getIRI())) break block3;
                        BuiltInTypeHandler typeHandler = this.builtInTypes.get(o);
                        if (typeHandler == null) break block4;
                        typeHandler.handleTriple(s2, p, o);
                        break block5;
                    }
                    if (this.axiomTypes.get(o) != null) break block5;
                    OWLIndividual ind = this.consumer.translateIndividual(s2);
                    OWLClassExpression ce = this.consumer.translatorAccessor.translateClassExpression(o);
                    this.consumer.addAxiom(this.consumer.getDataFactory().getOWLClassAssertionAxiom(ce, ind, this.consumer.getPendingAnnotations()));
                    this.consumer.consumeTriple(s2, p, o);
                    break block5;
                }
                TriplePredicateHandler handler = this.predicates.get(p);
                if (handler != null && handler.canHandle(s2, p, o)) {
                    handler.handleTriple(s2, p, o);
                } else {
                    for (ResourceTripleHandler resHandler : this.resources) {
                        if (!resHandler.canHandle(s2, p, o)) continue;
                        resHandler.handleTriple(s2, p, o);
                        break;
                    }
                }
            }
        }

        protected void handle(IRI s2, IRI p, OWLLiteral o) {
            for (LiteralTripleHandler handler : this.literals) {
                if (!handler.canHandle(s2, p, o)) continue;
                handler.handleTriple(s2, p, o);
                break;
            }
        }

        public Set<RDFTriple> mopUp() {
            TriplePredicateHandler propertyRangeHandler = this.predicates.get(OWLRDFVocabulary.RDFS_RANGE.getIRI());
            this.consumer.iterateResources((s2, p, o) -> {
                if (propertyRangeHandler.canHandle(s2, p, o)) {
                    propertyRangeHandler.handleTriple(s2, p, o);
                }
            });
            this.consumeNonReservedPredicateTriples();
            this.consumeAnnotatedAxioms();
            this.consumer.iterateResources(this::handle);
            this.consumer.iterateLiterals(this::handle);
            this.inverseOf.setAxiomParsingMode(true);
            this.consumer.iterateResources((s2, p, o) -> {
                if (this.inverseOf.canHandle(s2, p, o)) {
                    this.inverseOf.handleTriple(s2, p, o);
                }
            });
            return this.getRemainingTriples();
        }

        private Set<RDFTriple> getRemainingTriples() {
            HashSet<RDFTriple> remaining = new HashSet<RDFTriple>();
            this.consumer.iterateResources((s2, p, o) -> remaining.add(new RDFTriple(s2, this.consumer.isAnonymousNode(s2), this.consumer.isAxiomIRI(s2), p, o, this.consumer.isAnonymousNode(o), this.consumer.isAxiomIRI(o))));
            this.consumer.iterateLiterals((s2, p, o) -> remaining.add(new RDFTriple(s2, this.consumer.isAnonymousNode(s2), this.consumer.isAxiomIRI(s2), p, o)));
            return remaining;
        }

        protected Map<IRI, TriplePredicateHandler> getPredicateHandlers(OWLRDFConsumer r) {
            ConcurrentHashMap<IRI, TriplePredicateHandler> predicateHandlers = new ConcurrentHashMap<IRI, TriplePredicateHandler>();
            HandlerAccessor.add(predicateHandlers, new TPDifferentFromHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPDisjointUnionHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPDisjointWithHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPEquivalentClassHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPEquivalentPropertyHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPPropertyDomainHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPPropertyRangeHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPSameAsHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPSubClassOfHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPSubPropertyOfHandler(r));
            HandlerAccessor.add(predicateHandlers, this.nonBuiltInTypes);
            HandlerAccessor.add(predicateHandlers, new TPImportsHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPIntersectionOfHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPUnionOfHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPComplementOfHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPOneOfHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPSomeValuesFromHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPAllValuesFromHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPRestHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPFirstResourceHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPDeclaredAsHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPHasKeyHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPVersionIRIHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPPropertyChainAxiomHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPAnnotatedSourceHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPAnnotatedPropertyHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPAnnotatedTargetHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPPropertyDisjointWithHandler(r));
            HandlerAccessor.add(predicateHandlers, this.inverseOf);
            HandlerAccessor.add(predicateHandlers, new TPOnPropertyHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPOnClassHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPOnDataRangeHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPComplementOfHandler(r));
            HandlerAccessor.add(predicateHandlers, new TPDatatypeComplementOfHandler(r));
            return predicateHandlers;
        }
    }
}

