/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;
import org.semanticweb.owlapi.util.StringAnnotationVisitor;

public class AnnotationValueShortFormProvider
implements ShortFormProvider {
    private final OWLOntologySetProvider ontologySetProvider;
    private final ShortFormProvider alternateShortFormProvider;
    private final IRIShortFormProvider alternateIRIShortFormProvider;
    private final List<OWLAnnotationProperty> annotationProperties;
    private final Map<OWLAnnotationProperty, List<String>> preferredLanguageMap;
    private StringAnnotationVisitor literalRenderer = new StringAnnotationVisitor();

    public AnnotationValueShortFormProvider(List<OWLAnnotationProperty> annotationProperties, Map<OWLAnnotationProperty, List<String>> preferredLanguageMap, OWLOntologySetProvider ontologySetProvider) {
        this(annotationProperties, preferredLanguageMap, ontologySetProvider, new SimpleShortFormProvider());
    }

    public AnnotationValueShortFormProvider(List<OWLAnnotationProperty> annotationProperties, Map<OWLAnnotationProperty, List<String>> preferredLanguageMap, OWLOntologySetProvider ontologySetProvider, ShortFormProvider alternateShortFormProvider) {
        this(ontologySetProvider, alternateShortFormProvider, new SimpleIRIShortFormProvider(), annotationProperties, preferredLanguageMap);
    }

    public AnnotationValueShortFormProvider(OWLOntologySetProvider ontologySetProvider, ShortFormProvider alternateShortFormProvider, IRIShortFormProvider alternateIRIShortFormProvider, List<OWLAnnotationProperty> annotationProperties, Map<OWLAnnotationProperty, List<String>> preferredLanguageMap) {
        this.ontologySetProvider = OWLAPIPreconditions.checkNotNull(ontologySetProvider, "ontologySetProvider cannot be null");
        this.alternateShortFormProvider = OWLAPIPreconditions.checkNotNull(alternateShortFormProvider, "alternateShortFormProvider cannot be null");
        this.alternateIRIShortFormProvider = OWLAPIPreconditions.checkNotNull(alternateIRIShortFormProvider, "alternateIRIShortFormProvider cannot be null");
        this.annotationProperties = OWLAPIPreconditions.checkNotNull(annotationProperties, "annotationProperties cannot be null");
        this.preferredLanguageMap = OWLAPIPreconditions.checkNotNull(preferredLanguageMap, "preferredLanguageMap cannot be null");
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        Stream<OWLOntology> onts = this.ontologySetProvider.ontologies();
        List flatMap2 = OWLAPIStreamUtils.asList(onts.flatMap(o -> o.annotationAssertionAxioms(entity.getIRI(), Imports.INCLUDED).sorted()));
        for (OWLAnnotationProperty prop : this.annotationProperties) {
            AnnotationLanguageFilter checker = new AnnotationLanguageFilter(prop, this.preferredLanguageMap.get(prop));
            flatMap2.forEach(ax -> ax.accept(checker));
            OWLObject match = checker.getMatch();
            if (match == null) continue;
            return this.getRendering(match);
        }
        return this.alternateShortFormProvider.getShortForm(entity);
    }

    private String getRendering(OWLObject object) {
        if (object instanceof OWLLiteral) {
            return this.literalRenderer.visit((OWLLiteral)object);
        }
        if (object.isIRI()) {
            return this.alternateIRIShortFormProvider.getShortForm((IRI)object);
        }
        return this.alternateShortFormProvider.getShortForm((OWLEntity)object);
    }

    public List<OWLAnnotationProperty> getAnnotationProperties() {
        return this.annotationProperties;
    }

    public Map<OWLAnnotationProperty, List<String>> getPreferredLanguageMap() {
        return this.preferredLanguageMap;
    }

    public void setLiteralRenderer(StringAnnotationVisitor literalRenderer) {
        this.literalRenderer = OWLAPIPreconditions.checkNotNull(literalRenderer);
    }

    private static class AnnotationLanguageFilter
    implements OWLObjectVisitor {
        private final OWLAnnotationProperty prop;
        private final List<String> preferredLanguages;
        @Nullable
        protected OWLObject candidateValue = null;
        int lastLangMatchIndex = Integer.MAX_VALUE;

        AnnotationLanguageFilter(OWLAnnotationProperty prop, @Nullable List<String> preferredLanguages) {
            this.prop = prop;
            this.preferredLanguages = preferredLanguages == null ? Collections.emptyList() : preferredLanguages;
        }

        @Nullable
        public OWLObject getMatch() {
            return this.candidateValue;
        }

        @Override
        public void visit(OWLAnnotationAssertionAxiom axiom) {
            if (this.lastLangMatchIndex > 0 && ((OWLAnnotationProperty)axiom.getProperty()).equals(this.prop)) {
                axiom.getValue().accept(this);
            }
        }

        @Override
        public void visit(OWLLiteral node) {
            if (this.preferredLanguages.isEmpty()) {
                this.lastLangMatchIndex = 0;
                this.candidateValue = node;
            } else {
                int index = this.preferredLanguages.indexOf(node.getLang());
                if (index >= 0 && index < this.lastLangMatchIndex) {
                    this.lastLangMatchIndex = index;
                    this.candidateValue = node;
                }
            }
        }

        @Override
        public void visit(IRI iri) {
            this.candidateValue = iri;
        }
    }
}

