/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.BidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public abstract class CachingBidirectionalShortFormProvider
implements BidirectionalShortFormProvider {
    private final Map<String, Set<OWLEntity>> shortForm2EntityMap = CollectionFactory.createSyncMap();
    private final Map<OWLEntity, String> entity2ShortFormMap = CollectionFactory.createSyncMap();

    protected CachingBidirectionalShortFormProvider() {
    }

    protected abstract String generateShortForm(OWLEntity var1);

    @Override
    public Stream<String> shortForms() {
        return this.shortForm2EntityMap.keySet().stream();
    }

    protected void rebuild(Stream<OWLEntity> entities) {
        this.shortForm2EntityMap.clear();
        this.entity2ShortFormMap.clear();
        entities.forEach(this::add);
    }

    public void add(OWLEntity entity) {
        String shortForm = this.generateShortForm(entity);
        this.entity2ShortFormMap.put(entity, shortForm);
        this.shortForm2EntityMap.computeIfAbsent(shortForm, s2 -> new HashSet(1)).add(entity);
    }

    protected void remove(OWLEntity entity) {
        String shortForm = this.entity2ShortFormMap.remove(entity);
        if (shortForm != null) {
            this.shortForm2EntityMap.remove(shortForm);
        }
    }

    @Override
    public Stream<OWLEntity> entities(String shortForm) {
        Set<OWLEntity> entities = this.shortForm2EntityMap.get(shortForm);
        if (entities != null && !entities.isEmpty()) {
            return entities.stream();
        }
        return OWLAPIStreamUtils.empty();
    }

    @Override
    @Nullable
    public OWLEntity getEntity(String shortForm) {
        Set<OWLEntity> entities = this.shortForm2EntityMap.get(shortForm);
        if (entities != null && !entities.isEmpty()) {
            return entities.iterator().next();
        }
        return null;
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        String sf = this.entity2ShortFormMap.get(entity);
        if (sf != null) {
            return sf;
        }
        return this.generateShortForm(entity);
    }

    @Override
    public void dispose() {
        this.shortForm2EntityMap.clear();
        this.entity2ShortFormMap.clear();
    }
}

