/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public final class OWLAPIPreconditions {
    private OWLAPIPreconditions() {
    }

    public static <T> T verifyNotNull(@Nullable T object) {
        return OWLAPIPreconditions.verifyNotNull(object, "value cannot be null at this stage");
    }

    public static <T> T verifyNotNull(@Nullable T object, String message) {
        if (object == null) {
            throw new IllegalStateException(message);
        }
        return object;
    }

    public static <T> T verifyNotNull(@Nullable T object, Supplier<String> message) {
        if (object == null) {
            throw new IllegalStateException(message.get());
        }
        return object;
    }

    public static <T> T checkNotNull(@Nullable T object) {
        return OWLAPIPreconditions.checkNotNull(object, () -> "this variable cannot be null");
    }

    public static <T> T checkNotNull(@Nullable T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    public static <Q, T extends Collection<Q>> T checkValidForNAryExpressions(@Nullable T object, String message) {
        if (object == null || object.isEmpty()) {
            throw new NullPointerException(message);
        }
        return object;
    }

    public static <T> T checkNotNull(@Nullable T object, Supplier<String> message) {
        if (object == null) {
            throw new NullPointerException(message.get());
        }
        return object;
    }

    public static void checkNotNegative(@Nonnegative long object) {
        OWLAPIPreconditions.checkNotNegative(object, () -> "this variable cannot be negative: " + object);
    }

    public static void checkNotNegative(@Nonnegative long object, String message) {
        OWLAPIPreconditions.checkNotNegative(object, () -> message);
    }

    public static void checkNotNegative(@Nonnegative long object, Supplier<String> message) {
        if (object < 0L) {
            throw new IllegalArgumentException(message.get());
        }
    }

    @Deprecated
    public static <T> T checkNotNull(@Nullable Optional<T> object, String message) {
        return OWLAPIPreconditions.checkNotNull(object, () -> message);
    }

    public static <T> T checkNotNull(@Nullable Optional<T> object, Supplier<String> message) {
        if (object == null || !object.isPresent()) {
            throw new IllegalArgumentException(message.get());
        }
        return OWLAPIPreconditions.verifyNotNull(object.get());
    }

    public static void checkIterableNotNull(@Nullable Collection<?> o, String name, boolean emptyAllowed) {
        OWLAPIPreconditions.checkNotNull(o, name);
        assert (o != null);
        if (!emptyAllowed && o.isEmpty()) {
            throw new IllegalArgumentException(name + " or empty");
        }
    }

    public static void checkIterableNotNull(Object[] o, String name, boolean emptyAllowed) {
        OWLAPIPreconditions.checkNotNull(o, name);
        if (!emptyAllowed && o.length == 0) {
            throw new IllegalArgumentException(name + " or empty");
        }
    }

    public static <T> Optional<T> emptyOptional() {
        return Optional.empty();
    }

    public static <T> Optional<T> emptyOptional(Class<T> t) {
        return Optional.empty();
    }

    public static <T> Optional<T> optional(@Nullable T t) {
        return Optional.ofNullable(t);
    }
}

