/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.model.providers.AnonymousIndividualByIdProvider;

public class RemappingIndividualProvider
implements AnonymousIndividualByIdProvider {
    private OWLDataFactory df;
    private boolean shouldRemapAllAnonymousIndividualsIds;
    private Map<String, OWLAnonymousIndividual> map;

    public RemappingIndividualProvider(OntologyConfigurator m3, OWLDataFactory df) {
        this(m3.buildWriterConfiguration().shouldRemapAllAnonymousIndividualsIds(), df);
    }

    public RemappingIndividualProvider(boolean remap, OWLDataFactory df) {
        this.df = df;
        this.shouldRemapAllAnonymousIndividualsIds = remap;
        this.map = this.shouldRemapAllAnonymousIndividualsIds ? new HashMap<String, OWLAnonymousIndividual>() : Collections.emptyMap();
    }

    @Override
    public OWLAnonymousIndividual getOWLAnonymousIndividual(String nodeId) {
        if (!this.shouldRemapAllAnonymousIndividualsIds) {
            return this.df.getOWLAnonymousIndividual(nodeId);
        }
        OWLAnonymousIndividual toReturn = this.map.get(nodeId);
        if (toReturn == null) {
            toReturn = this.df.getOWLAnonymousIndividual();
            this.map.put(nodeId, toReturn);
        }
        return toReturn;
    }
}

