/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;
import org.semanticweb.owlapi.util.StringAnnotationVisitor;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class ShortFormFromRDFSLabelAxiomListProvider
implements ShortFormProvider {
    private final ShortFormProvider alternateShortFormProvider;
    private final IRIShortFormProvider alternateIRIShortFormProvider;
    private final List<String> preferredLanguages;
    private final StringAnnotationVisitor literalRenderer = new StringAnnotationVisitor();
    private final List<OWLAnnotationAssertionAxiom> axioms;

    public ShortFormFromRDFSLabelAxiomListProvider(List<String> preferredLanguages, List<? extends OWLAxiom> axioms) {
        this(preferredLanguages, axioms, new SimpleShortFormProvider());
    }

    public ShortFormFromRDFSLabelAxiomListProvider(List<String> preferredLanguages, List<? extends OWLAxiom> axioms, ShortFormProvider alternateShortFormProvider) {
        this(axioms, alternateShortFormProvider, new SimpleIRIShortFormProvider(), preferredLanguages);
    }

    public ShortFormFromRDFSLabelAxiomListProvider(List<? extends OWLAxiom> axioms, ShortFormProvider alternateShortFormProvider, IRIShortFormProvider alternateIRIShortFormProvider, List<String> preferredLanguages) {
        this.axioms = OWLAPIStreamUtils.asList(OWLAPIPreconditions.checkNotNull(axioms, "axioms cannot be null").stream().filter(x -> x.getAxiomType().equals(AxiomType.ANNOTATION_ASSERTION)).map(x -> (OWLAnnotationAssertionAxiom)x).sorted());
        this.alternateShortFormProvider = OWLAPIPreconditions.checkNotNull(alternateShortFormProvider, "alternateShortFormProvider cannot be null");
        this.alternateIRIShortFormProvider = OWLAPIPreconditions.checkNotNull(alternateIRIShortFormProvider, "alternateIRIShortFormProvider cannot be null");
        this.preferredLanguages = OWLAPIPreconditions.checkNotNull(preferredLanguages, "preferredLanguages cannot be null");
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        List<OWLAnnotationAssertionAxiom> flatMap2 = OWLAPIStreamUtils.asList(this.axioms.stream().filter(x -> ((OWLAnnotationSubject)x.getSubject()).equals(entity.getIRI())));
        AnnotationLanguageFilter checker = new AnnotationLanguageFilter(this.preferredLanguages);
        flatMap2.forEach(ax -> ax.accept(checker));
        OWLObject match = checker.getMatch();
        if (match != null) {
            return this.getRendering(match);
        }
        return this.alternateShortFormProvider.getShortForm(entity);
    }

    private String getRendering(OWLObject object) {
        if (object instanceof OWLLiteral) {
            return this.literalRenderer.visit((OWLLiteral)object);
        }
        if (object.isIRI()) {
            return this.alternateIRIShortFormProvider.getShortForm((IRI)object);
        }
        return this.alternateShortFormProvider.getShortForm((OWLEntity)object);
    }

    private static class AnnotationLanguageFilter
    implements OWLObjectVisitor {
        private final IRI prop = OWLRDFVocabulary.RDFS_LABEL.getIRI();
        private final List<String> preferredLanguages;
        @Nullable
        protected OWLObject candidateValue = null;
        int lastLangMatchIndex = Integer.MAX_VALUE;

        AnnotationLanguageFilter(@Nullable List<String> preferredLanguages) {
            this.preferredLanguages = preferredLanguages == null ? Collections.emptyList() : preferredLanguages;
        }

        @Nullable
        public OWLObject getMatch() {
            return this.candidateValue;
        }

        @Override
        public void visit(OWLAnnotationAssertionAxiom axiom) {
            if (this.lastLangMatchIndex > 0 && ((OWLAnnotationProperty)axiom.getProperty()).getIRI().equals(this.prop)) {
                axiom.getValue().accept(this);
            }
        }

        @Override
        public void visit(OWLLiteral node) {
            if (this.preferredLanguages.isEmpty()) {
                this.lastLangMatchIndex = 0;
                this.candidateValue = node;
            } else {
                int index = this.preferredLanguages.indexOf(node.getLang());
                if (index >= 0 && index < this.lastLangMatchIndex) {
                    this.lastLangMatchIndex = index;
                    this.candidateValue = node;
                }
            }
        }

        @Override
        public void visit(IRI iri) {
            this.candidateValue = iri;
        }
    }
}

