/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.decomposition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.semanticweb.owlapi.util.CollectionFactory;

public class IdentityMultiMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 30402L;
    private final IdentityHashMap<K, Collection<V>> map = new IdentityHashMap();
    private int size = 0;

    public boolean put(K key, V value) {
        boolean toReturn;
        Collection<V> set = this.map.get(key);
        if (set == null) {
            set = this.createCollection();
            this.map.put(key, set);
        }
        if (toReturn = set.add(value)) {
            this.size = -1;
        }
        return toReturn;
    }

    private Collection<V> createCollection() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    public void setEntry(K key, Collection<V> values2) {
        this.map.put(key, values2);
        this.size = -1;
    }

    public Collection<V> get(K key) {
        Collection<V> collection = this.map.get(key);
        if (collection != null) {
            return collection;
        }
        return Collections.emptyList();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Set<V> getAllValues() {
        Set toReturn = CollectionFactory.createSet();
        for (Collection<V> s2 : this.map.values()) {
            toReturn.addAll(s2);
        }
        return toReturn;
    }

    public boolean remove(K key) {
        if (this.map.remove(key) != null) {
            this.size = -1;
            return true;
        }
        return false;
    }

    public boolean remove(K key, V value) {
        Collection<V> c = this.map.get(key);
        if (c != null) {
            boolean toReturn = c.remove(value);
            if (!toReturn) {
                return false;
            }
            this.size = -1;
            if (c.isEmpty()) {
                this.map.remove(key);
            }
            return true;
        }
        return false;
    }

    public int size() {
        if (this.size < 0) {
            this.size = this.getAllValues().size();
        }
        return this.size;
    }

    public boolean contains(K k, V v) {
        Collection<V> collection = this.map.get(k);
        if (collection == null) {
            return false;
        }
        return collection.contains(v);
    }

    public boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    public boolean containsValue(V v) {
        for (Collection<V> c : this.map.values()) {
            if (!c.contains(v)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    public String toString() {
        return "MultiMap " + this.size() + "\n" + this.map.toString();
    }

    public void putAll(IdentityMultiMap<K, V> otherMap) {
        for (K k : otherMap.keySet()) {
            this.putAll(k, otherMap.get(k));
        }
    }

    public void putAll(K k, Collection<V> v) {
        Collection<V> set = this.map.get(k);
        if (set == null) {
            set = this.createCollection();
            this.setEntry(k, set);
        }
        set.addAll(v);
        this.size = -1;
    }

    public boolean isValueSetsEqual() {
        if (this.map.size() < 2) {
            return true;
        }
        ArrayList<Collection<V>> list = new ArrayList<Collection<V>>(this.map.values());
        for (int i = 1; i < list.size(); ++i) {
            if (((Collection)list.get(0)).equals(list.get(i))) continue;
            return false;
        }
        return true;
    }
}

