/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.decomposition;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class Signature {
    private final Set<OWLEntity> set = new HashSet<OWLEntity>();
    private boolean topCLocality = false;
    private boolean topRLocality = false;

    public Signature() {
    }

    public Signature(Stream<OWLEntity> sig) {
        this.addAll(sig);
    }

    public boolean add(OWLEntity p) {
        return this.set.add(p);
    }

    public void addAll(Stream<OWLEntity> p) {
        OWLAPIStreamUtils.add(this.set, p);
    }

    public void setLocality(boolean top) {
        this.setLocality(top, top);
    }

    public void setLocality(boolean topC, boolean topR) {
        this.topCLocality = topC;
        this.topRLocality = topR;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Signature) {
            return this.set.equals(((Signature)obj).set);
        }
        return false;
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public boolean contains(OWLEntity p) {
        return this.set.contains(p);
    }

    public Set<OWLEntity> getSignature() {
        return this.set;
    }

    public boolean topCLocal() {
        return this.topCLocality;
    }

    public boolean topRLocal() {
        return this.topRLocality;
    }

    public List<OWLEntity> intersect(Signature s2) {
        ArrayList<OWLEntity> ret = new ArrayList<OWLEntity>();
        HashSet<OWLEntity> s3 = new HashSet<OWLEntity>(this.set);
        s3.retainAll(s2.set);
        ret.addAll(s3);
        return ret;
    }
}

