/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import org.semanticweb.owlapitools.decomposition.OntologyAtom;
import uk.ac.manchester.cs.factplusplusad.AOStructure;
import uk.ac.manchester.cs.factplusplusad.Modularizer;
import uk.ac.manchester.cs.factplusplusad.Signature;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

class AtomicDecomposer {
    AOStructure aos = null;
    Modularizer modularizer;
    Set<AxiomWrapper> tautologies;
    OntologyAtom rootAtom = null;
    ModuleType type;

    AtomicDecomposer(Modularizer m3) {
        this.modularizer = m3;
    }

    void restoreTautologies() {
        this.tautologies.forEach(p -> p.setUsed(true));
    }

    AOStructure getAOS() {
        return this.aos;
    }

    long getLocChekNumber() {
        return this.modularizer.getNChecks();
    }

    void removeTautologies(Collection<AxiomWrapper> o) {
        this.tautologies.clear();
        for (AxiomWrapper p : o) {
            if (!p.isUsed() || !this.modularizer.isTautology(p.getAxiom(), this.type)) continue;
            this.tautologies.add(p);
            p.setUsed(false);
        }
    }

    Optional<OntologyAtom> buildModule(Signature sig, OntologyAtom parent) {
        this.modularizer.extract(parent.getModule(), sig, this.type);
        Collection<AxiomWrapper> module = this.modularizer.getModule();
        if (module.isEmpty()) {
            return Optional.empty();
        }
        if (parent != this.rootAtom && module.size() == parent.getModule().size()) {
            return Optional.of(parent);
        }
        OntologyAtom atom = this.aos.newAtom();
        atom.setModule(module);
        return Optional.of(atom);
    }

    OntologyAtom createAtom(AxiomWrapper ax, OntologyAtom parent) {
        if (ax.getAtom().isPresent()) {
            return ax.getAtom().get();
        }
        Optional<OntologyAtom> atom = this.buildModule(new Signature(ax.signature()), parent);
        assert (atom.isPresent());
        atom.get().addAxiom(ax);
        if (atom.get() == parent) {
            return parent;
        }
        for (AxiomWrapper q : atom.get().getModule()) {
            if (q == ax) continue;
            atom.get().addDepAtom(this.createAtom(q, atom.get()));
        }
        return atom.get();
    }

    AOStructure getAOS(Collection<AxiomWrapper> o, ModuleType t) {
        this.type = t;
        this.aos = new AOStructure();
        this.modularizer.preprocessOntology(o);
        this.removeTautologies(o);
        this.rootAtom = new OntologyAtom();
        this.rootAtom.setModule(o);
        Optional<OntologyAtom> bottomAtom = this.buildModule(new Signature(), this.rootAtom);
        if (bottomAtom.isPresent()) {
            for (AxiomWrapper q : bottomAtom.get().getModule()) {
                bottomAtom.get().addAxiom(q);
            }
        }
        for (AxiomWrapper p : o) {
            if (!p.isUsed() || p.getAtom().isPresent()) continue;
            this.createAtom(p, this.rootAtom);
        }
        this.restoreTautologies();
        this.rootAtom = null;
        this.aos.reduceGraph();
        return this.aos;
    }
}

