/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import uk.ac.manchester.cs.factplusplusad.LowerBoundComplementEvaluator;
import uk.ac.manchester.cs.factplusplusad.LowerBoundDirectEvaluator;
import uk.ac.manchester.cs.factplusplusad.SigAccessor;
import uk.ac.manchester.cs.factplusplusad.Signature;
import uk.ac.manchester.cs.factplusplusad.UpperBoundComplementEvaluator;
import uk.ac.manchester.cs.factplusplusad.UpperBoundDirectEvaluator;

abstract class CardinalityEvaluatorBase
extends SigAccessor
implements OWLObjectVisitor {
    UpperBoundDirectEvaluator ubd;
    LowerBoundDirectEvaluator lbd;
    UpperBoundComplementEvaluator ubc;
    LowerBoundComplementEvaluator lbc;
    int value = 0;

    CardinalityEvaluatorBase(Signature s2) {
        super(s2);
    }

    int minUpperValue(int uv1, int uv2) {
        if (uv1 == this.noUpperValue()) {
            return uv2;
        }
        if (uv2 == this.noUpperValue()) {
            return uv1;
        }
        return Math.min(uv1, uv2);
    }

    int noUpperValue() {
        return -1;
    }

    int anyUpperValue() {
        return 0;
    }

    int getAllNoneUpper(boolean condition) {
        return condition ? this.anyUpperValue() : this.noUpperValue();
    }

    int noLowerValue() {
        return 0;
    }

    int anyLowerValue() {
        return -1;
    }

    int getOneNoneLower(boolean condition) {
        return condition ? 1 : this.noLowerValue();
    }

    int getAllValue() {
        return 0;
    }

    int getNoneValue() {
        return -1;
    }

    int getUpperBoundDirect(OWLObject expr) {
        return this.ubd.getValue(expr);
    }

    int getUpperBoundComplement(OWLObject expr) {
        return this.ubc.getValue(expr);
    }

    int getLowerBoundDirect(OWLObject expr) {
        return this.lbd.getValue(expr);
    }

    int getLowerBoundComplement(OWLObject expr) {
        return this.lbc.getValue(expr);
    }

    int getValue(OWLObject expr) {
        expr.accept(this);
        return this.value;
    }

    boolean isUpperLT(int v, int m3) {
        if (v == this.noUpperValue()) {
            return false;
        }
        return v == this.anyUpperValue() || v < m3;
    }

    boolean isUpperLE(int v, int m3) {
        return this.isUpperLT(v, m3 + 1);
    }

    boolean isLowerGE(int v, int m3) {
        if (v == this.noLowerValue()) {
            return false;
        }
        return v == this.anyLowerValue() || v >= m3;
    }

    boolean isLowerGT(int v, int m3) {
        return this.isLowerGE(v, m3 + 1);
    }

    boolean isBotEquivalent(OWLObject expr) {
        return this.isUpperLE(this.getUpperBoundDirect(expr), 0);
    }

    boolean isTopEquivalent(OWLObject expr) {
        return this.isUpperLE(this.getUpperBoundComplement(expr), 0);
    }

    abstract int getEntityValue(OWLEntity var1);

    abstract int getForallValue(OWLPropertyExpression var1, OWLPropertyRange var2);

    abstract int getMinValue(int var1, OWLPropertyExpression var2, OWLPropertyRange var3);

    abstract int getMaxValue(int var1, OWLPropertyExpression var2, OWLPropertyRange var3);

    abstract int getExactValue(int var1, OWLPropertyExpression var2, OWLPropertyRange var3);

    void setEvaluators(UpperBoundDirectEvaluator pUD, LowerBoundDirectEvaluator pLD, UpperBoundComplementEvaluator pUC, LowerBoundComplementEvaluator pLC) {
        this.ubd = pUD;
        this.lbd = pLD;
        this.ubc = pUC;
        this.lbc = pLC;
        assert (this.ubd == this || this.lbd == this || this.ubc == this || this.lbc == this);
    }

    int getUpperBoundDirect(OWLClassExpression expr) {
        return this.getUpperBoundDirect(expr);
    }

    int getUpperBoundComplement(OWLClassExpression expr) {
        return this.getUpperBoundComplement(expr);
    }

    int getLowerBoundDirect(OWLClassExpression expr) {
        return this.getLowerBoundDirect(expr);
    }

    int getLowerBoundComplement(OWLClassExpression expr) {
        return this.getLowerBoundComplement(expr);
    }

    @Override
    public void visit(OWLClass expr) {
        this.value = this.getEntityValue(expr);
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom expr) {
        this.value = this.getMinValue(1, expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLObjectAllValuesFrom expr) {
        this.value = this.getForallValue(expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLObjectMinCardinality expr) {
        this.value = this.getMinValue(expr.getCardinality(), expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLObjectMaxCardinality expr) {
        this.value = this.getMaxValue(expr.getCardinality(), expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLObjectExactCardinality expr) {
        this.value = this.getExactValue(expr.getCardinality(), expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLDataSomeValuesFrom expr) {
        this.value = this.getMinValue(1, expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLDataAllValuesFrom expr) {
        this.value = this.getForallValue(expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLDataMinCardinality expr) {
        this.value = this.getMinValue(expr.getCardinality(), expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLDataMaxCardinality expr) {
        this.value = this.getMaxValue(expr.getCardinality(), expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLDataExactCardinality expr) {
        this.value = this.getExactValue(expr.getCardinality(), expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLObjectProperty p) {
        this.value = this.getEntityValue(p);
    }

    @Override
    public void visit(OWLDataProperty expr) {
        this.value = this.getEntityValue(expr);
    }
}

