/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import org.semanticweb.owlapi.model.OWLObject;
import uk.ac.manchester.cs.factplusplusad.LowerBoundComplementEvaluator;
import uk.ac.manchester.cs.factplusplusad.LowerBoundDirectEvaluator;
import uk.ac.manchester.cs.factplusplusad.Signature;
import uk.ac.manchester.cs.factplusplusad.SyntacticLocalityChecker;
import uk.ac.manchester.cs.factplusplusad.UpperBoundComplementEvaluator;
import uk.ac.manchester.cs.factplusplusad.UpperBoundDirectEvaluator;

class ExtendedSyntacticLocalityChecker
extends SyntacticLocalityChecker {
    UpperBoundDirectEvaluator ubd;
    LowerBoundDirectEvaluator lbd;
    UpperBoundComplementEvaluator ubc;
    LowerBoundComplementEvaluator lbc;

    ExtendedSyntacticLocalityChecker(Signature s2) {
        super(s2);
        this.ubd = new UpperBoundDirectEvaluator(s2);
        this.lbd = new LowerBoundDirectEvaluator(s2);
        this.ubc = new UpperBoundComplementEvaluator(s2);
        this.lbc = new LowerBoundComplementEvaluator(s2);
        this.ubd.setEvaluators(this.ubd, this.lbd, this.ubc, this.lbc);
        this.lbd.setEvaluators(this.ubd, this.lbd, this.ubc, this.lbc);
        this.ubc.setEvaluators(this.ubd, this.lbd, this.ubc, this.lbc);
        this.lbc.setEvaluators(this.ubd, this.lbd, this.ubc, this.lbc);
    }

    @Override
    public boolean isTopEquivalent(OWLObject expr) {
        return this.ubc.getUpperBoundComplement(expr) == 0;
    }

    @Override
    public boolean isBotEquivalent(OWLObject expr) {
        return this.ubd.getUpperBoundDirect(expr) == 0;
    }
}

