/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import java.util.Iterator;
import org.semanticweb.owlapi.model.HasOperands;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import uk.ac.manchester.cs.factplusplusad.CardinalityEvaluatorBase;
import uk.ac.manchester.cs.factplusplusad.Signature;

class LowerBoundComplementEvaluator
extends CardinalityEvaluatorBase {
    LowerBoundComplementEvaluator(Signature s2) {
        super(s2);
    }

    @Override
    int getNoneValue() {
        return 0;
    }

    @Override
    int getAllValue() {
        return -1;
    }

    @Override
    int getOneNoneLower(boolean v) {
        return v ? 1 : this.getNoneValue();
    }

    @Override
    int getEntityValue(OWLEntity entity) {
        if (entity.isTopEntity()) {
            return this.noLowerValue();
        }
        if ((entity.isOWLObjectProperty() || entity.isOWLDataProperty() || entity.isOWLDatatype()) && entity.isBottomEntity()) {
            return this.anyLowerValue();
        }
        if (entity.isBottomEntity()) {
            return 1;
        }
        return this.getOneNoneLower(this.botCLocal() && this.nc(entity));
    }

    @Override
    int getForallValue(OWLPropertyExpression r, OWLPropertyRange c) {
        return this.getOneNoneLower(this.isTopEquivalent(r) && this.isLowerGE(this.getLowerBoundComplement(c), 1));
    }

    @Override
    int getMinValue(int m3, OWLPropertyExpression r, OWLPropertyRange c) {
        if (m3 <= 0) {
            return this.noLowerValue();
        }
        if (this.isBotEquivalent(r)) {
            return 1;
        }
        return this.getOneNoneLower(this.isUpperLT(this.getUpperBoundDirect(c), m3));
    }

    @Override
    int getMaxValue(int m3, OWLPropertyExpression r, OWLPropertyRange c) {
        if (!this.isTopEquivalent(r)) {
            return this.noLowerValue();
        }
        if (this.isLowerGT(this.getLowerBoundDirect(c), m3)) {
            return m3 + 1;
        }
        return this.noLowerValue();
    }

    @Override
    int getExactValue(int m3, OWLPropertyExpression r, OWLPropertyRange c) {
        return Math.max(this.getMinValue(m3, r, c), this.getMaxValue(m3, r, c));
    }

    <C extends OWLObject> int getAndValue(HasOperands<C> expr) {
        int max = this.getNoneValue();
        Iterator it = expr.operands().iterator();
        while (it.hasNext()) {
            OWLObject p = (OWLObject)it.next();
            int n = this.getLowerBoundComplement(p);
            if (n == this.anyLowerValue()) {
                return this.anyLowerValue();
            }
            max = Math.max(max, n);
        }
        return max;
    }

    <C extends OWLObject> int getOrValue(HasOperands<C> expr) {
        boolean foundC = false;
        int foundM = 0;
        int mMax = 0;
        int kMax = 0;
        int sumK = 0;
        Iterator it = expr.operands().iterator();
        while (it.hasNext()) {
            OWLObject p = (OWLObject)it.next();
            int m3 = this.getLowerBoundComplement(p);
            int k = this.getUpperBoundDirect(p);
            if (m3 == this.noLowerValue() && k == this.noUpperValue()) {
                return this.noLowerValue();
            }
            if (m3 == this.noLowerValue()) {
                sumK += k;
                continue;
            }
            if (k == this.noUpperValue()) {
                if (foundC) {
                    return this.noLowerValue();
                }
                foundC = true;
                foundM = m3;
                continue;
            }
            sumK += k;
            if (k + m3 <= kMax + mMax) continue;
            kMax = k;
            mMax = m3;
        }
        if (foundC) {
            return (foundM -= sumK) > 0 ? foundM : this.noLowerValue();
        }
        return (mMax -= (sumK -= kMax)) > 0 ? mMax : this.noLowerValue();
    }

    @Override
    public void visit(OWLObjectComplementOf expr) {
        this.value = this.getLowerBoundDirect(expr.getOperand());
    }

    @Override
    public void visit(OWLObjectIntersectionOf expr) {
        this.value = this.getAndValue(expr);
    }

    @Override
    public void visit(OWLObjectUnionOf expr) {
        this.value = this.getOrValue(expr);
    }

    @Override
    public void visit(OWLObjectOneOf o) {
        this.value = this.noLowerValue();
    }

    @Override
    public void visit(OWLObjectHasSelf expr) {
        this.value = this.getOneNoneLower(this.isBotEquivalent(expr.getProperty()));
    }

    @Override
    public void visit(OWLObjectHasValue expr) {
        this.value = this.getOneNoneLower(this.isBotEquivalent(expr.getProperty()));
    }

    @Override
    public void visit(OWLDataHasValue expr) {
        this.value = this.getOneNoneLower(this.isBotEquivalent(expr.getProperty()));
    }

    @Override
    public void visit(OWLObjectInverseOf expr) {
        this.value = this.getLowerBoundComplement(expr.getInverseProperty());
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom expr) {
        for (OWLObjectPropertyExpression p : expr.getPropertyChain()) {
            if (!this.isBotEquivalent(p)) continue;
            this.value = this.anyLowerValue();
            return;
        }
        this.value = this.noLowerValue();
    }

    @Override
    public void visit(OWLLiteral o) {
        this.value = 1;
    }

    @Override
    public void visit(OWLDataComplementOf expr) {
        this.value = this.getLowerBoundDirect(expr.getDataRange());
    }

    @Override
    public void visit(OWLDataIntersectionOf expr) {
        this.value = this.getAndValue(expr);
    }

    @Override
    public void visit(OWLDataUnionOf expr) {
        this.value = this.getOrValue(expr);
    }

    @Override
    public void visit(OWLDataOneOf o) {
        this.value = this.noLowerValue();
    }
}

