/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

class Signature {
    private final Set<OWLEntity> set = new HashSet<OWLEntity>();
    private boolean topCLocality = false;
    private boolean topRLocality = false;

    Signature(Signature copy) {
        this.set.addAll(copy.set);
        this.topCLocality = copy.topCLocality;
        this.topRLocality = copy.topRLocality;
    }

    Signature() {
    }

    public Signature(Stream<OWLEntity> sig) {
        this.addAll(sig);
    }

    public boolean add(OWLEntity p) {
        return this.set.add(p);
    }

    public void addAll(Stream<OWLEntity> p) {
        OWLAPIStreamUtils.add(this.set, p);
    }

    void add(Set<OWLEntity> aSet) {
        this.set.addAll(aSet);
    }

    void add(Signature sig) {
        this.add(sig.set);
    }

    void remove(OWLEntity p) {
        this.set.remove(p);
    }

    void setLocality(boolean top) {
        this.setLocality(top, top);
    }

    public void setLocality(boolean topC, boolean topR) {
        this.topCLocality = topC;
        this.topRLocality = topR;
    }

    void setSignature(Signature s2) {
        this.setSignature(s2.set.stream());
        this.topCLocality = s2.topCLocality;
        this.topRLocality = s2.topRLocality;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Signature) {
            return this.set.equals(((Signature)obj).set);
        }
        return false;
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    boolean contains(OWLEntity p) {
        return this.set.contains(p);
    }

    boolean contains(OWLObjectInverseOf p) {
        return this.set.contains(p.getNamedProperty());
    }

    int size() {
        return this.set.size();
    }

    void clear() {
        this.set.clear();
    }

    Stream<OWLEntity> getSignature() {
        return this.set.stream();
    }

    void setSignature(Stream<OWLEntity> s2) {
        this.set.clear();
        this.addAll(s2);
    }

    public boolean topCLocal() {
        return this.topCLocality;
    }

    boolean botCLocal() {
        return !this.topCLocality;
    }

    public boolean topRLocal() {
        return this.topRLocality;
    }

    boolean botRLocal() {
        return !this.topRLocality;
    }

    Set<OWLEntity> intersect(Signature s1, Signature s2) {
        HashSet<OWLEntity> ret = new HashSet<OWLEntity>(s1.set);
        ret.retainAll(s2.set);
        return ret;
    }
}

