/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.owlapi.model.HasOperands;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import uk.ac.manchester.cs.factplusplusad.CardinalityEvaluatorBase;
import uk.ac.manchester.cs.factplusplusad.Signature;

class UpperBoundComplementEvaluator
extends CardinalityEvaluatorBase {
    UpperBoundComplementEvaluator(Signature s2) {
        super(s2);
    }

    @Override
    int getEntityValue(OWLEntity entity) {
        if (entity.isTopEntity()) {
            return this.anyUpperValue();
        }
        if (entity.isBottomEntity()) {
            return this.noUpperValue();
        }
        return this.getAllNoneUpper(this.topCLocal() && this.nc(entity));
    }

    @Override
    int getForallValue(OWLPropertyExpression r, OWLPropertyRange c) {
        return this.getAllNoneUpper(this.isBotEquivalent(r) || this.isUpperLE(this.getUpperBoundComplement(c), 0));
    }

    @Override
    int getMinValue(int m3, OWLPropertyExpression r, OWLPropertyRange c) {
        if (m3 == 0) {
            return this.anyUpperValue();
        }
        if (!this.isTopEquivalent(r)) {
            return this.noUpperValue();
        }
        return this.getAllNoneUpper(this.isLowerGE(this.getLowerBoundDirect(c), m3));
    }

    @Override
    int getMaxValue(int m3, OWLPropertyExpression r, OWLPropertyRange c) {
        if (this.isBotEquivalent(r)) {
            return this.anyUpperValue();
        }
        return this.getAllNoneUpper(this.isUpperLE(this.getUpperBoundDirect(c), m3));
    }

    @Override
    int getExactValue(int m3, OWLPropertyExpression r, OWLPropertyRange c) {
        return Math.min(this.getMinValue(m3, r, c), this.getMaxValue(m3, r, c));
    }

    <C extends OWLObject> int getAndValue(HasOperands<C> expr) {
        int sum = 0;
        Iterator it = expr.operands().iterator();
        while (it.hasNext()) {
            OWLObject p = (OWLObject)it.next();
            int n = this.getUpperBoundComplement(p);
            if (n == this.noUpperValue()) {
                return this.noUpperValue();
            }
            sum += n;
        }
        return sum;
    }

    <C extends OWLObject> int getOrValue(HasOperands<C> expr) {
        AtomicInteger min2 = new AtomicInteger(this.noUpperValue());
        expr.operands().forEach(p -> min2.set(this.minUpperValue(min2.get(), this.getUpperBoundDirect((OWLObject)p))));
        return min2.get();
    }

    @Override
    public void visit(OWLObjectComplementOf expr) {
        this.value = this.getUpperBoundDirect(expr.getOperand());
    }

    @Override
    public void visit(OWLObjectIntersectionOf expr) {
        this.value = this.getAndValue(expr);
    }

    @Override
    public void visit(OWLObjectUnionOf expr) {
        this.value = this.getOrValue(expr);
    }

    @Override
    public void visit(OWLObjectOneOf o) {
        this.value = this.noUpperValue();
    }

    @Override
    public void visit(OWLObjectHasSelf expr) {
        this.value = this.getAllNoneUpper(this.isTopEquivalent(expr.getProperty()));
    }

    @Override
    public void visit(OWLObjectHasValue expr) {
        this.value = this.getAllNoneUpper(this.isTopEquivalent(expr.getProperty()));
    }

    @Override
    public void visit(OWLDataHasValue expr) {
        this.value = this.getAllNoneUpper(this.isTopEquivalent(expr.getProperty()));
    }

    @Override
    public void visit(OWLObjectInverseOf expr) {
        this.value = this.getUpperBoundComplement(expr.getInverseProperty());
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom expr) {
        for (OWLObjectPropertyExpression p : expr.getPropertyChain()) {
            if (this.isTopEquivalent(p)) continue;
            this.value = this.noUpperValue();
            return;
        }
        this.value = this.anyUpperValue();
    }

    @Override
    public void visit(OWLDatatype o) {
        this.value = this.noUpperValue();
    }

    @Override
    public void visit(OWLDatatypeRestriction o) {
        this.value = this.noUpperValue();
    }

    @Override
    public void visit(OWLLiteral o) {
        this.value = this.noUpperValue();
    }

    @Override
    public void visit(OWLDataComplementOf expr) {
        this.value = this.getUpperBoundDirect(expr.getDataRange());
    }

    @Override
    public void visit(OWLDataIntersectionOf expr) {
        this.value = this.getAndValue(expr);
    }

    @Override
    public void visit(OWLDataUnionOf expr) {
        this.value = this.getOrValue(expr);
    }

    @Override
    public void visit(OWLDataOneOf o) {
        this.value = this.noUpperValue();
    }
}

