/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.util.NNF;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public abstract class OWLAxiomImpl
extends OWLObjectImpl
implements OWLAxiom {
    protected final List<OWLAnnotation> annotations;

    public OWLAxiomImpl(Collection<OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull(annotations, "annotations cannot be null");
        this.annotations = OWLAPIStreamUtils.sorted(OWLAnnotation.class, annotations);
    }

    @Override
    public Stream<OWLAnnotation> annotations() {
        return OWLAPIStreamUtils.streamFromSorted(this.annotations);
    }

    @Override
    public List<OWLAnnotation> annotationsAsList() {
        return this.annotations;
    }

    @Override
    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    protected Collection<OWLAnnotation> mergeAnnos(Stream<OWLAnnotation> annos) {
        return OWLAPIStreamUtils.sorted(OWLAnnotation.class, Stream.concat(annos, this.annotations()));
    }

    @Override
    public OWLAxiom getNNF() {
        return this.accept(new NNF(new OWLDataFactoryImpl()));
    }
}

