/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collections;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.parameters.ConfigurationOptions;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternalsImplNoCache;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class OWLDataFactoryInternalsImpl
extends OWLDataFactoryInternalsImplNoCache {
    private static final LoadingCache<IRI, OWLAnnotationProperty> annotationProperties = OWLDataFactoryInternalsImpl.builder(OWLAnnotationPropertyImpl::new);
    private static final LoadingCache<OWLAnnotation, OWLAnnotation> annotations = OWLDataFactoryInternalsImpl.builder(OWLDataFactoryInternalsImpl::ann);
    private static final LoadingCache<IRI, OWLClass> classes = OWLDataFactoryInternalsImpl.builder(OWLClassImpl::new);
    private static final LoadingCache<IRI, OWLObjectProperty> objectProperties = OWLDataFactoryInternalsImpl.builder(OWLObjectPropertyImpl::new);
    private static final LoadingCache<IRI, OWLDataProperty> dataProperties = OWLDataFactoryInternalsImpl.builder(OWLDataPropertyImpl::new);
    private static final LoadingCache<IRI, OWLDatatype> datatypes = OWLDataFactoryInternalsImpl.builder(OWLDatatypeImpl::new);
    private static final LoadingCache<IRI, OWLNamedIndividual> individuals = OWLDataFactoryInternalsImpl.builder(OWLNamedIndividualImpl::new);

    public OWLDataFactoryInternalsImpl(boolean useCompression) {
        super(useCompression);
    }

    private static OWLAnnotation ann(OWLAnnotation o) {
        return o;
    }

    private static <F, T> LoadingCache<F, T> builder(CacheLoader<F, T> f) {
        return Caffeine.newBuilder().weakKeys().maximumSize(OWLDataFactoryInternalsImpl.size()).build(f);
    }

    protected static long size() {
        return ConfigurationOptions.CACHE_SIZE.getValue(Integer.class, Collections.emptyMap()).longValue();
    }

    @Override
    public OWLClass getOWLClass(IRI iri) {
        return classes.get(iri);
    }

    @Override
    public void purge() {
        classes.invalidateAll();
        objectProperties.invalidateAll();
        dataProperties.invalidateAll();
        datatypes.invalidateAll();
        individuals.invalidateAll();
        annotationProperties.invalidateAll();
        annotations.invalidateAll();
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return objectProperties.get(iri);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return dataProperties.get(iri);
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return individuals.get(iri);
    }

    @Override
    public OWLDatatype getOWLDatatype(IRI iri) {
        return datatypes.get(iri);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return annotationProperties.get(iri);
    }

    @Override
    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, Stream<OWLAnnotation> anns) {
        return annotations.get(new OWLAnnotationImpl(property, value, anns));
    }
}

