/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLDataOneOfImpl
extends OWLObjectImpl
implements OWLDataOneOf {
    private final List<OWLLiteral> values;

    public OWLDataOneOfImpl(Stream<? extends OWLLiteral> values2) {
        OWLAPIPreconditions.checkNotNull(values2, "values cannot be null");
        this.values = OWLAPIStreamUtils.sorted(OWLLiteral.class, values2);
    }

    public OWLDataOneOfImpl(Collection<? extends OWLLiteral> values2) {
        this(OWLAPIPreconditions.checkNotNull(values2, "values cannot be null").stream());
    }

    public OWLDataOneOfImpl(OWLLiteral value) {
        OWLAPIPreconditions.checkNotNull(value, "value cannot be null");
        this.values = Collections.singletonList(value);
    }

    @Override
    public Stream<OWLLiteral> values() {
        return OWLAPIStreamUtils.streamFromSorted(this.values);
    }

    @Override
    public Stream<OWLLiteral> operands() {
        return this.values();
    }

    @Override
    public List<OWLLiteral> getOperandsAsList() {
        return this.values;
    }
}

