/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;
import uk.ac.manchester.cs.owl.owlapi.SWRLAtomImpl;

public class SWRLBuiltInAtomImpl
extends SWRLAtomImpl
implements SWRLBuiltInAtom {
    private final List<SWRLDArgument> args;

    public SWRLBuiltInAtomImpl(IRI predicate, List<SWRLDArgument> args2) {
        super(predicate);
        this.args = Collections.unmodifiableList(new ArrayList(OWLAPIPreconditions.checkNotNull(args2, "args cannot be null")));
    }

    @Override
    public IRI getPredicate() {
        return (IRI)super.getPredicate();
    }

    @Override
    public boolean isCoreBuiltIn() {
        return SWRLBuiltInsVocabulary.getBuiltIn(this.getPredicate()) != null;
    }

    @Override
    public Stream<SWRLDArgument> arguments() {
        return this.args.stream();
    }

    @Override
    public Stream<SWRLArgument> allArguments() {
        return this.args.stream().map(x -> x);
    }

    @Override
    public List<SWRLDArgument> getArguments() {
        return this.args;
    }
}

