# Imandra CLI

This is python implementation of `imandra-cli` which is intended to be a lightweight client to `https://www.imandra.ai/api`, so users can interact with our APIs, spawn Imandra Core instances and submit IPL jobs without having to set up a full-blown OCaml installation on their machine.

It also supports Windows.

## Local installation

To install (built from the `release` branch):

- MacOS/Unix:
```sh
sh <(curl -s "https://storage.googleapis.com/imandra-do/install.sh")
```

- Windows:
```pwsh
(Invoke-WebRequest https://storage.googleapis.com/imandra-do/install.ps1).Content | powershell -
```

For the dev installer (built from the `master` branch):

- MacOS/Unix:
```sh
sh <(curl -s "https://storage.googleapis.com/imandra-do-dev/install.sh")
```

- Windows:
```pwsh
(Invoke-WebRequest https://storage.googleapis.com/imandra-do-dev/install.ps1).Content | powershell -
```

You can also test the installer for a specific commit, which is useful for testing changes from a branch once its build is complete. Note that when actually invoking `imandra` after installing from a specific commit, you'll need to pass `SKIP_UPDATE`, otherwise `imandra` will auto-update itself to the current `master` version (rather than the `release` version, as it is based from `imandra-do-dev`, rather than `imandra-do`).

```sh
sh <(curl -s "https://storage.googleapis.com/imandra-do-dev/install-4cbf479327f041ecbf543fa79969fcd94841e370.sh")
SKIP_UPDATE=true imandra --help
```

- To skip updates, `export SKIP_UPDATE=true`.
- To use the dev cluster, `export IMANDRA_ENV=dev`. You can use the dev or prod cluster from both the `release` and `master` versions of the CLI - by default it talks to the prod cluster from both.

## Local development

You can also test changes locally if you're not testing out the installer itself, and are only making changes to the library. To setup:

- MacOS/Unix
```
make install-deps
```
- Windows:
```
.\venv\Scripts\pip.exe install -r requirements.txt
```


This creates a `venv` at `./venv` which has an installed version of
`imandra-cli` in editable mode (i.e. changes to the library are reflected in the
venv), along with `imandra-cli`'s dependencies. You can invoke the `imandra-cli`
entrypoint once this setup is done using:

- MacOS/Unix
```
./venv/bin/imandra-cli
```
- Windows:
```
.\venv\Scripts\imandra-cli.exe
```


To run the tests:

```
make smoke-tests
```

## Regenerating imandra_http_api_client

`imandra_http_api_client` is generated from the `swagger.yaml` in the Imandra repo. If this has been updated, copy the new version into `docs/imandra/imandra_http_api_client/swagger.yaml` and then run:

```
make generate-imandra-http-api-client
```

This will generate the new version of the python library code in `src/imandra_http_api_client`, and documentation in `docs/imandra_http_api_client`.

## Regenerating python API docs

Docs for `imandra` are generated using `pdoc3`:

Docs for `imandra_http_api_client` are converted from `.md` files which are
stored in this repo:

- `docs/README.md` is a handwritten intro to the `imandra` package.
- `docs/imandra_http_api_client/**/*.md` are generated by the OpenAPI generator step above, and that generation process will overwrite these files.

You can run:

```
make generate-docs
```

to generate all `.html` files in the first structure, into `docs/_out`. This is
uploaded to the `imandra-docs` gh-pages as part of `imandra-cli`'s CI process.

### Github auth to avoid .md -> .html conversion rate limit

We use [`grip`](https://github.com/joeyespo/grip) to convert markdown into
Github style markdown-as-html.

Grip needs to talk to the github API to render the markdown for some reason.
You'll get a certain number of anonymous requests, and then any `.html` files
generated from `.md` files by `grip` will contain a rate limit error, rather
than the correct output.

To authenticate to get a much higher rate limit, configure your details at the top of `docs/Makefile`:
- `GH_USER`: your Github username
- `GH_TOKEN`: your Github access token. this can be read using `gh auth token` if you have the Github cli set up locally.


## Releasing to PyPi

### Test release

- Figure out the next test version by visiting https://test.pypi.org/project/imandra/
- Update the version in `pyproject.toml`, and commit the change.
- Release a test version to test.pypi.org with:

```
make test-pypi-release VERSION=X.X.X
```

### Main release

- Figure out the next live version by visiting https://pypi.org/project/imandra/
- Release a version to pypi.org with:

```
make pypi-release VERSION=X.X.X
```
