_by_resolution = {
    4: {
        "width": 0.5,
        "depth": 0.1,
        "dropout": 0.1
    },
    8: {
        "width": 0.5,
        "depth": 0.1,
        "dropout": 0.1
    },
    12: {
        "width": 0.5,
        "depth": 0.1,
        "dropout": 0.1
    },
    16: {
        "width": 0.5,
        "depth": 0.1,
        "dropout": 0.1
    },
    20: {
        "width": 0.5,
        "depth": 0.1,
        "dropout": 0.1
    },
    24: {
        "width": 0.5,
        "depth": 0.1,
        "dropout": 0.1
    },
    28: {
        "width": 0.5,
        "depth": 0.1,
        "dropout": 0.1
    },
    32: {
        "width": 0.5,
        "depth": 0.2,
        "dropout": 0.1
    },
    36: {
        "width": 0.5,
        "depth": 0.2,
        "dropout": 0.1
    },
    40: {
        "width": 0.6,
        "depth": 0.2,
        "dropout": 0.1
    },
    44: {
        "width": 0.6,
        "depth": 0.2,
        "dropout": 0.1
    },
    48: {
        "width": 0.6,
        "depth": 0.2,
        "dropout": 0.1
    },
    52: {
        "width": 0.6,
        "depth": 0.2,
        "dropout": 0.1
    },
    56: {
        "width": 0.6,
        "depth": 0.3,
        "dropout": 0.1
    },
    60: {
        "width": 0.6,
        "depth": 0.3,
        "dropout": 0.1
    },
    64: {
        "width": 0.6,
        "depth": 0.3,
        "dropout": 0.1
    },
    72: {
        "width": 0.6,
        "depth": 0.3,
        "dropout": 0.1
    },
    80: {
        "width": 0.7,
        "depth": 0.4,
        "dropout": 0.1
    },
    88: {
        "width": 0.7,
        "depth": 0.4,
        "dropout": 0.1
    },
    96: {
        "width": 0.7,
        "depth": 0.4,
        "dropout": 0.1
    },
    100: {
        "width": 0.7,
        "depth": 0.4,
        "dropout": 0.1
    },
    104: {
        "width": 0.7,
        "depth": 0.5,
        "dropout": 0.1
    },
    112: {
        "width": 0.7,
        "depth": 0.5,
        "dropout": 0.1
    },
    120: {
        "width": 0.7,
        "depth": 0.5,
        "dropout": 0.1
    },
    128: {
        "width": 0.7,
        "depth": 0.6,
        "dropout": 0.1
    },
    136: {
        "width": 0.7,
        "depth": 0.6,
        "dropout": 0.1
    },
    144: {
        "width": 0.7,
        "depth": 0.6,
        "dropout": 0.1
    },
    152: {
        "width": 0.9,
        "depth": 0.7,
        "dropout": 0.1
    },
    160: {
        "width": 0.9,
        "depth": 0.7,
        "dropout": 0.1
    },
    168: {
        "width": 0.9,
        "depth": 0.7,
        "dropout": 0.1
    },
    176: {
        "width": 0.9,
        "depth": 0.8,
        "dropout": 0.1
    },
    184: {
        "width": 0.9,
        "depth": 0.8,
        "dropout": 0.1
    },
    192: {
        "width": 1.0,
        "depth": 0.8,
        "dropout": 0.2
    },
    200: {
        "width": 1.0,
        "depth": 0.9,
        "dropout": 0.2
    },
    208: {
        "width": 1.0,
        "depth": 0.9,
        "dropout": 0.2
    },
    216: {
        "width": 1.0,
        "depth": 0.9,
        "dropout": 0.2
    },
    224: {
        "width": 1.0,
        "depth": 1.0,
        "dropout": 0.2
    },
    232: {
        "width": 1.1,
        "depth": 1.0,
        "dropout": 0.2
    },
    240: {
        "width": 1.1,
        "depth": 1.0,
        "dropout": 0.2
    },
    248: {
        "width": 1.1,
        "depth": 1.1,
        "dropout": 0.2
    },
    256: {
        "width": 1.1,
        "depth": 1.1,
        "dropout": 0.2
    },
    272: {
        "width": 1.2,
        "depth": 1.1,
        "dropout": 0.2
    },
    288: {
        "width": 1.2,
        "depth": 1.2,
        "dropout": 0.2
    },
    300: {
        "width": 1.2,
        "depth": 1.3,
        "dropout": 0.2
    },
    304: {
        "width": 1.2,
        "depth": 1.3,
        "dropout": 0.2
    },
    320: {
        "width": 1.2,
        "depth": 1.3,
        "dropout": 0.3
    },
    336: {
        "width": 1.2,
        "depth": 1.4,
        "dropout": 0.3
    },
    352: {
        "width": 1.4,
        "depth": 1.5,
        "dropout": 0.3
    },
    368: {
        "width": 1.4,
        "depth": 1.5,
        "dropout": 0.3
    },
    384: {
        "width": 1.5,
        "depth": 1.6,
        "dropout": 0.3
    },
    400: {
        "width": 1.5,
        "depth": 1.7,
        "dropout": 0.3
    },
    416: {
        "width": 1.6,
        "depth": 1.7,
        "dropout": 0.3
    },
    432: {
        "width": 1.6,
        "depth": 1.8,
        "dropout": 0.3
    },
    448: {
        "width": 1.6,
        "depth": 1.9,
        "dropout": 0.4
    },
    464: {
        "width": 1.7,
        "depth": 1.9,
        "dropout": 0.4
    },
    480: {
        "width": 1.7,
        "depth": 2.0,
        "dropout": 0.4
    },
    496: {
        "width": 1.8,
        "depth": 2.0,
        "dropout": 0.4
    },
    500: {
        "width": 1.8,
        "depth": 2.0,
        "dropout": 0.4
    },
    512: {
        "width": 1.8,
        "depth": 2.0,
        "dropout": 0.4
    },
    528: {
        "width": 1.8,
        "depth": 2.2,
        "dropout": 0.4
    },
    544: {
        "width": 1.9,
        "depth": 2.3,
        "dropout": 0.4
    },
    576: {
        "width": 2.0,
        "depth": 2.4,
        "dropout": 0.5
    },
    600: {
        "width": 2.0,
        "depth": 2.5,
        "dropout": 0.5
    },
    608: {
        "width": 2.1,
        "depth": 2.5,
        "dropout": 0.5
    },
    624: {
        "width": 2.1,
        "depth": 2.5,
        "dropout": 0.5
    },
    640: {
        "width": 2.1,
        "depth": 2.7,
        "dropout": 0.5
    },
    672: {
        "width": 2.2,
        "depth": 2.8,
        "dropout": 0.5
    },
    700: {
        "width": 2.3,
        "depth": 2.9,
        "dropout": 0.6
    },
    704: {
        "width": 2.3,
        "depth": 2.9,
        "dropout": 0.6
    },
    720: {
        "width": 2.4,
        "depth": 3.0,
        "dropout": 0.6
    },
    736: {
        "width": 2.4,
        "depth": 3.0,
        "dropout": 0.6
    },
    768: {
        "width": 2.5,
        "depth": 3.0,
        "dropout": 0.6
    },
    800: {
        "width": 2.5,
        "depth": 3.25,
        "dropout": 0.6
    },
    832: {
        "width": 2.5,
        "depth": 3.25,
        "dropout": 0.7
    },
    864: {
        "width": 2.5,
        "depth": 3.5,
        "dropout": 0.7
    },
    896: {
        "width": 2.75,
        "depth": 3.5,
        "dropout": 0.7
    },
    900: {
        "width": 2.75,
        "depth": 3.5,
        "dropout": 0.7
    },
    928: {
        "width": 2.75,
        "depth": 3.75,
        "dropout": 0.7
    },
    960: {
        "width": 3.0,
        "depth": 4.0,
        "dropout": 0.8
    },
    992: {
        "width": 3.0,
        "depth": 4.0,
        "dropout": 0.8
    },
    1024: {
        "width": 3.0,
        "depth": 4.0,
        "dropout": 0.8
    },
    1056: {
        "width": 3.0,
        "depth": 4.25,
        "dropout": 0.8
    },
    1088: {
        "width": 3.25,
        "depth": 4.5,
        "dropout": 0.8
    },
    1152: {
        "width": 3.5,
        "depth": 4.75,
        "dropout": 0.8
    },
    1216: {
        "width": 3.5,
        "depth": 5.0,
        "dropout": 0.8
    },
    1248: {
        "width": 3.5,
        "depth": 5.0,
        "dropout": 0.8
    },
    1280: {
        "width": 3.75,
        "depth": 5.0,
        "dropout": 0.8
    },
    1344: {
        "width": 4.0,
        "depth": 5.5,
        "dropout": 0.8
    },
    1408: {
        "width": 4.0,
        "depth": 5.5,
        "dropout": 0.8
    },
    1440: {
        "width": 4.0,
        "depth": 5.5,
        "dropout": 0.8
    },
    1472: {
        "width": 4.25,
        "depth": 6.0,
        "dropout": 0.8
    },
    1536: {
        "width": 4.5,
        "depth": 6.0,
        "dropout": 0.8
    },
    1600: {
        "width": 4.5,
        "depth": 6.5,
        "dropout": 0.8
    },
    1632: {
        "width": 4.75,
        "depth": 6.5,
        "dropout": 0.8
    },
    1664: {
        "width": 4.75,
        "depth": 6.5,
        "dropout": 0.8
    },
    1728: {
        "width": 5.0,
        "depth": 7.0,
        "dropout": 0.8
    },
    1792: {
        "width": 5.0,
        "depth": 7.0,
        "dropout": 0.8
    },
    1824: {
        "width": 5.0,
        "depth": 7.5,
        "dropout": 0.8
    },
    1856: {
        "width": 5.0,
        "depth": 7.5,
        "dropout": 0.8
    },
    1920: {
        "width": 5.5,
        "depth": 7.5,
        "dropout": 0.8
    },
    1984: {
        "width": 5.5,
        "depth": 8.0,
        "dropout": 0.8
    },
    2016: {
        "width": 5.5,
        "depth": 8.0,
        "dropout": 0.8
    },
    2048: {
        "width": 5.5,
        "depth": 8.0,
        "dropout": 0.8
    },
    2112: {
        "width": 6.0,
        "depth": 8.5,
        "dropout": 0.8
    },
    2208: {
        "width": 6.0,
        "depth": 9.0,
        "dropout": 0.8
    },
    2304: {
        "width": 6.5,
        "depth": 9.5,
        "dropout": 0.8
    },
    2400: {
        "width": 6.5,
        "depth": 9.5,
        "dropout": 0.8
    },
    2496: {
        "width": 7.0,
        "depth": 10.0,
        "dropout": 0.8
    },
    2592: {
        "width": 7.0,
        "depth": 10.0,
        "dropout": 0.8
    },
    2688: {
        "width": 7.5,
        "depth": 11.0,
        "dropout": 0.8
    },
    2784: {
        "width": 7.5,
        "depth": 11.0,
        "dropout": 0.8
    },
    2880: {
        "width": 8.0,
        "depth": 11.0,
        "dropout": 0.8
    },
    2976: {
        "width": 8.0,
        "depth": 12.0,
        "dropout": 0.8
    },
    3072: {
        "width": 8.5,
        "depth": 12.0,
        "dropout": 0.8
    },
    4096: {
        "width": 11.0,
        "depth": 16.0,
        "dropout": 0.8
    }
}


def get_params_for_resolution(resolution,
                              min_dropout=0.,
                              max_dropout=0.99):
    params = _by_resolution[resolution]
    return {'width': params['width'],
            'depth': params['depth'],
            'dropout': max(min_dropout, min(max_dropout, params['dropout']))}
