# generated by gen_server.py:
#   filename:  routes.py:
#   timestamp: 2025-10-01T16:12:51.474920

import fastapi

from gavicore.models import (
    ProcessRequest,
)
from gavicore.service import Service

from .app import app
from .provider import get_service


# noinspection PyPep8Naming
@app.get("/")
async def get_capabilities(
    request: fastapi.Request,
    response: fastapi.Response,
    service: Service = fastapi.Depends(get_service),
):
    return await service.get_capabilities(request=request, response=response)


# noinspection PyPep8Naming
@app.get("/conformance")
async def get_conformance(
    request: fastapi.Request,
    response: fastapi.Response,
    service: Service = fastapi.Depends(get_service),
):
    return await service.get_conformance(request=request, response=response)


# noinspection PyPep8Naming
@app.get("/processes")
async def get_processes(
    request: fastapi.Request,
    response: fastapi.Response,
    service: Service = fastapi.Depends(get_service),
):
    return await service.get_processes(request=request, response=response)


# noinspection PyPep8Naming
@app.get("/processes/{processID}")
async def get_process(
    processID: str,
    request: fastapi.Request,
    response: fastapi.Response,
    service: Service = fastapi.Depends(get_service),
):
    return await service.get_process(
        process_id=processID, request=request, response=response
    )


# noinspection PyPep8Naming
@app.post("/processes/{processID}/execution", status_code=201)
async def execute_process(
    processID: str,
    process_request: ProcessRequest,
    request: fastapi.Request,
    response: fastapi.Response,
    service: Service = fastapi.Depends(get_service),
):
    return await service.execute_process(
        process_id=processID,
        process_request=process_request,
        request=request,
        response=response,
    )


# noinspection PyPep8Naming
@app.get("/jobs")
async def get_jobs(
    request: fastapi.Request,
    response: fastapi.Response,
    service: Service = fastapi.Depends(get_service),
):
    return await service.get_jobs(request=request, response=response)


# noinspection PyPep8Naming
@app.get("/jobs/{jobId}")
async def get_job(
    jobId: str,
    request: fastapi.Request,
    response: fastapi.Response,
    service: Service = fastapi.Depends(get_service),
):
    return await service.get_job(job_id=jobId, request=request, response=response)


# noinspection PyPep8Naming
@app.delete("/jobs/{jobId}")
async def dismiss_job(
    jobId: str,
    request: fastapi.Request,
    response: fastapi.Response,
    service: Service = fastapi.Depends(get_service),
):
    return await service.dismiss_job(job_id=jobId, request=request, response=response)


# noinspection PyPep8Naming
@app.get("/jobs/{jobId}/results")
async def get_job_results(
    jobId: str,
    request: fastapi.Request,
    response: fastapi.Response,
    service: Service = fastapi.Depends(get_service),
):
    return await service.get_job_results(
        job_id=jobId, request=request, response=response
    )
