# -*- coding: utf-8 -*-
from typing import List, Union, Optional, Literal, Dict, Any

from openai.types import Embedding
from pydantic import BaseModel


class Usage(BaseModel):
    prompt_tokens: Optional[int] = None
    """The number of tokens used by the prompt."""

    total_tokens: Optional[int] = None
    """The total number of tokens used by the request."""

    input_tokens: Optional[int] = None

    text_count: Optional[int] = None

    image_count: Optional[int] = None

    video_count: Optional[int] = None

    duration: Optional[float] = None


class EmbeddingResponse(BaseModel):
    data: List[Embedding]
    """The list of embeddings generated by the model."""

    model: str
    """The name of the model used to generate the embedding."""

    object: Literal["list"]
    """The object type, which is always "list"."""

    usage: Usage
    """The usage information for the request."""
