"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTestAutoDiscoverBase = exports.AutoDiscoverBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const glob = require("fast-glob");
const internal_1 = require("./internal");
const component_1 = require("../component");
/**
 * Base class for auto-discovering and creating project subcomponents.
 */
class AutoDiscoverBase extends component_1.Component {
    constructor(project, options) {
        super(project);
        const cwd = path.posix.join(this.project.outdir, options.projectdir);
        this.entrypoints = glob
            .sync(`**/*${options.extension}`, { cwd })
            .map((p) => path.posix.join(options.projectdir, p));
    }
}
exports.AutoDiscoverBase = AutoDiscoverBase;
_a = JSII_RTTI_SYMBOL_1;
AutoDiscoverBase[_a] = { fqn: "projen.cdk.AutoDiscoverBase", version: "0.98.9" };
/**
 * Base class for locating integration tests in the project's test tree.
 */
class IntegrationTestAutoDiscoverBase extends AutoDiscoverBase {
    constructor(project, options) {
        super(project, {
            extension: internal_1.TYPESCRIPT_INTEG_EXT,
            projectdir: options.testdir,
        });
    }
}
exports.IntegrationTestAutoDiscoverBase = IntegrationTestAutoDiscoverBase;
_b = JSII_RTTI_SYMBOL_1;
IntegrationTestAutoDiscoverBase[_b] = { fqn: "projen.cdk.IntegrationTestAutoDiscoverBase", version: "0.98.9" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0by1kaXNjb3Zlci1iYXNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2Nkay9hdXRvLWRpc2NvdmVyLWJhc2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2QkFBNkI7QUFDN0Isa0NBQWtDO0FBQ2xDLHlDQUFrRDtBQUNsRCw0Q0FBeUM7QUFzQnpDOztHQUVHO0FBQ0gsTUFBc0IsZ0JBQWlCLFNBQVEscUJBQVM7SUFPdEQsWUFBWSxPQUFnQixFQUFFLE9BQWdDO1FBQzVELEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUVmLE1BQU0sR0FBRyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxFQUFFLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUVyRSxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUk7YUFDcEIsSUFBSSxDQUFDLE9BQU8sT0FBTyxDQUFDLFNBQVMsRUFBRSxFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUM7YUFDekMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDeEQsQ0FBQzs7QUFmSCw0Q0FnQkM7OztBQVlEOztHQUVHO0FBQ0gsTUFBYSwrQkFBZ0MsU0FBUSxnQkFBZ0I7SUFDbkUsWUFDRSxPQUFnQixFQUNoQixPQUErQztRQUUvQyxLQUFLLENBQUMsT0FBTyxFQUFFO1lBQ2IsU0FBUyxFQUFFLCtCQUFvQjtZQUMvQixVQUFVLEVBQUUsT0FBTyxDQUFDLE9BQU87U0FDNUIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFUSCwwRUFVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSBcInBhdGhcIjtcbmltcG9ydCAqIGFzIGdsb2IgZnJvbSBcImZhc3QtZ2xvYlwiO1xuaW1wb3J0IHsgVFlQRVNDUklQVF9JTlRFR19FWFQgfSBmcm9tIFwiLi9pbnRlcm5hbFwiO1xuaW1wb3J0IHsgQ29tcG9uZW50IH0gZnJvbSBcIi4uL2NvbXBvbmVudFwiO1xuaW1wb3J0IHsgUHJvamVjdCB9IGZyb20gXCIuLi9wcm9qZWN0XCI7XG5cbi8qKlxuICogT3B0aW9ucyBmb3IgYEF1dG9EaXNjb3ZlckJhc2VgXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQXV0b0Rpc2NvdmVyQmFzZU9wdGlvbnMge1xuICAvKipcbiAgICogTG9jYXRlIGZpbGVzIHdpdGggdGhlIGdpdmVuIGV4dGVuc2lvbi5cbiAgICpcbiAgICogQGV4YW1wbGUgXCIuaW50ZWcudHNcIlxuICAgKi9cbiAgcmVhZG9ubHkgZXh0ZW5zaW9uOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIExvY2F0ZSBlbnRyeXBvaW50cyBpbiB0aGUgZ2l2ZW4gcHJvamVjdCBkaXJlY3RvcnkuXG4gICAqXG4gICAqIEBleGFtcGxlIFwidGVzdFwiXG4gICAqL1xuICByZWFkb25seSBwcm9qZWN0ZGlyOiBzdHJpbmc7XG59XG5cbi8qKlxuICogQmFzZSBjbGFzcyBmb3IgYXV0by1kaXNjb3ZlcmluZyBhbmQgY3JlYXRpbmcgcHJvamVjdCBzdWJjb21wb25lbnRzLlxuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQXV0b0Rpc2NvdmVyQmFzZSBleHRlbmRzIENvbXBvbmVudCB7XG4gIC8qKlxuICAgKiBBdXRvLWRpc2NvdmVyZWQgZW50cnkgcG9pbnRzIHdpdGggcGF0aHMgcmVsYXRpdmUgdG8gdGhlIHByb2plY3RcbiAgICogZGlyZWN0b3J5LlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGVudHJ5cG9pbnRzOiBzdHJpbmdbXTtcblxuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBQcm9qZWN0LCBvcHRpb25zOiBBdXRvRGlzY292ZXJCYXNlT3B0aW9ucykge1xuICAgIHN1cGVyKHByb2plY3QpO1xuXG4gICAgY29uc3QgY3dkID0gcGF0aC5wb3NpeC5qb2luKHRoaXMucHJvamVjdC5vdXRkaXIsIG9wdGlvbnMucHJvamVjdGRpcik7XG5cbiAgICB0aGlzLmVudHJ5cG9pbnRzID0gZ2xvYlxuICAgICAgLnN5bmMoYCoqLyoke29wdGlvbnMuZXh0ZW5zaW9ufWAsIHsgY3dkIH0pXG4gICAgICAubWFwKChwKSA9PiBwYXRoLnBvc2l4LmpvaW4ob3B0aW9ucy5wcm9qZWN0ZGlyLCBwKSk7XG4gIH1cbn1cblxuLyoqXG4gKiBPcHRpb25zIGZvciBgSW50ZWdyYXRpb25UZXN0QXV0b0Rpc2NvdmVyQmFzZWBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJbnRlZ3JhdGlvblRlc3RBdXRvRGlzY292ZXJCYXNlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUZXN0IHNvdXJjZSB0cmVlLlxuICAgKi9cbiAgcmVhZG9ubHkgdGVzdGRpcjogc3RyaW5nO1xufVxuXG4vKipcbiAqIEJhc2UgY2xhc3MgZm9yIGxvY2F0aW5nIGludGVncmF0aW9uIHRlc3RzIGluIHRoZSBwcm9qZWN0J3MgdGVzdCB0cmVlLlxuICovXG5leHBvcnQgY2xhc3MgSW50ZWdyYXRpb25UZXN0QXV0b0Rpc2NvdmVyQmFzZSBleHRlbmRzIEF1dG9EaXNjb3ZlckJhc2Uge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcm9qZWN0OiBQcm9qZWN0LFxuICAgIG9wdGlvbnM6IEludGVncmF0aW9uVGVzdEF1dG9EaXNjb3ZlckJhc2VPcHRpb25zXG4gICkge1xuICAgIHN1cGVyKHByb2plY3QsIHtcbiAgICAgIGV4dGVuc2lvbjogVFlQRVNDUklQVF9JTlRFR19FWFQsXG4gICAgICBwcm9qZWN0ZGlyOiBvcHRpb25zLnRlc3RkaXIsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==