"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cdk8sPythonApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("..");
const cdk8s_deps_py_1 = require("./cdk8s-deps-py");
const python_project_1 = require("../python/python-project");
/**
 * CDK8s app in Python
 *
 *
 * @pjid cdk8s-app-py
 */
class Cdk8sPythonApp extends python_project_1.PythonProject {
    constructor(options) {
        super({ ...options, pytest: false, sample: false });
        this.cdk8sDeps = new cdk8s_deps_py_1.Cdk8sDepsPy(this, {
            dependencyType: __1.DependencyType.RUNTIME,
            cdk8sCliDependency: false,
            ...options,
        });
        if (!options.cdk8sVersion) {
            throw new Error("Required field cdk8sVersion is not specified.");
        }
        this.appEntrypoint = options.appEntrypoint ?? "app.py";
        const synth = this.addTask("synth", {
            description: "Synthesizes your cdk8s app into dist",
            exec: "cdk8s synth",
        });
        // add synth to the build
        this.postCompileTask.spawn(synth);
        const cdk8sImports = options.cdk8sImports ?? [];
        const k8sSpec = options.k8sSpecVersion
            ? `k8s@${options.k8sSpecVersion}`
            : "k8s";
        new __1.YamlFile(this, "cdk8s.yaml", {
            committed: true,
            editGitignore: true,
            obj: {
                language: "python",
                app: `python ${this.appEntrypoint}`,
                imports: [k8sSpec, ...cdk8sImports],
            },
        });
        if (options.sample ?? true) {
            new AppCode(this, this.appEntrypoint);
        }
    }
}
exports.Cdk8sPythonApp = Cdk8sPythonApp;
_a = JSII_RTTI_SYMBOL_1;
Cdk8sPythonApp[_a] = { fqn: "projen.cdk8s.Cdk8sPythonApp", version: "0.98.9" };
class AppCode extends __1.Component {
    constructor(project, filename) {
        super(project);
        new __1.SampleFile(project, filename, {
            contents: [
                "from constructs import Construct",
                "from cdk8s import App, Chart",
                "",
                "",
                "class MyChart(Chart):",
                "  def __init__(self, scope: Construct, id:str):",
                "    super().__init__(scope, id)",
                "",
                "",
                "app = App()",
                'MyChart(app, "${project.name}")',
                "",
                "app.synth()",
            ].join("\n"),
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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