"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cdk8sTypeScriptApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const auto_discover_1 = require("./auto-discover");
const cdk8s_deps_js_1 = require("./cdk8s-deps-js");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const typescript_1 = require("../typescript");
const yaml_1 = require("../yaml");
/**
 * CDK8s app in TypeScript
 *
 *
 * @pjid cdk8s-app-ts
 */
class Cdk8sTypeScriptApp extends typescript_1.TypeScriptAppProject {
    constructor(options) {
        super({
            ...options,
            sampleCode: false,
        });
        this.cdk8sDeps = new cdk8s_deps_js_1.Cdk8sDepsJs(this, {
            dependencyType: dependencies_1.DependencyType.RUNTIME,
            cdk8sCliDependency: true,
            ...options,
        });
        if (!options.cdk8sVersion) {
            throw new Error("Required field cdk8sVersion is not specified.");
        }
        // encode a hidden assumption further down the chain
        if (this.srcdir !== "src") {
            throw new Error('sources are expected under the "src" directory');
        }
        // encode a hidden assumption further down the chain
        if (this.testdir !== "test") {
            throw new Error('test sources are expected under the "test" directory');
        }
        this.appEntrypoint = options.appEntrypoint ?? "main.ts";
        const synth = this.addTask("synth", {
            description: 'Synthesizes your cdk8s app into dist (part of "yarn build")',
            exec: "cdk8s synth",
        });
        this.addTask("import", {
            description: "Imports API objects to your app by generating constructs.",
            exec: "cdk8s import -o src/imports",
        });
        // add synth to the build
        this.postCompileTask.spawn(synth);
        const cdk8sImports = options.cdk8sImports ?? [];
        const k8sSpec = options.k8sSpecVersion
            ? `k8s@${options.k8sSpecVersion}`
            : "k8s";
        const appEntrypointBaseName = path.basename(this.appEntrypoint, ".ts");
        new yaml_1.YamlFile(this, "cdk8s.yaml", {
            committed: true,
            editGitignore: true,
            obj: {
                language: "typescript",
                app: `node lib/${appEntrypointBaseName}.js`,
                imports: [k8sSpec, ...cdk8sImports],
            },
        });
        if (options.sampleCode ?? true) {
            new SampleCode(this);
        }
        new auto_discover_1.AutoDiscover(this, {
            testdir: this.testdir,
            tsconfigPath: this.tsconfigDev.fileName,
            integrationTestAutoDiscover: options.integrationTestAutoDiscover ?? true,
        });
    }
}
exports.Cdk8sTypeScriptApp = Cdk8sTypeScriptApp;
_a = JSII_RTTI_SYMBOL_1;
Cdk8sTypeScriptApp[_a] = { fqn: "projen.cdk8s.Cdk8sTypeScriptApp", version: "0.98.9" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        this.appProject = project;
    }
    synthesize() {
        const outdir = this.project.outdir;
        const srcdir = path.join(outdir, this.appProject.srcdir);
        if (fs.existsSync(srcdir) &&
            fs.readdirSync(srcdir).filter((x) => x.endsWith(".ts"))) {
            return;
        }
        const srcCode = `import { Construct } from 'constructs';
import { App, Chart, ChartProps, ApiObject } from 'cdk8s';

export class MyChart extends Chart {
  constructor(scope: Construct, id: string, props: ChartProps = { }) {
    super(scope, id, props);

    const label = { app: 'hello-k8s' };



    new ApiObject(this, 'deployment', {
      apiVersion: "v1",
      kind: "Pod",
      metadata: {
          namespace: "frontend",
          name: "nginx",
          labels: label,
      },
      spec: {
          containers: [{
              name: "nginx",
              image: "nginx:1.14-alpine",
              resources: {
                  limits: {
                      memory: "20Mi",
                      cpu: 0.2,
                  },
              },
          }],
      },
    });
  }
}

const app = new App();
new MyChart(app, 'hello');
app.synth();`;
        fs.mkdirSync(srcdir, { recursive: true });
        fs.writeFileSync(path.join(srcdir, this.appProject.appEntrypoint), srcCode);
    }
}
//# sourceMappingURL=data:application/json;base64,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