import { IConstruct } from "constructs";
import { AutoQueueOptions } from "./auto-queue";
import { Component } from "../component";
/**
 * Options for 'MergeQueue'
 */
export interface MergeQueueOptions {
    /**
     * Should pull requests be queued automatically to be merged once they pass required checks
     * @default true
     */
    readonly autoQueue?: boolean;
    /**
     * Configure auto-queue pull requests
     * @default - see AutoQueueOptions
     */
    readonly autoQueueOptions?: AutoQueueOptions;
    /**
     * The branches that can be merged into using MergeQueue
     *
     * @default - all branches
     */
    readonly targetBranches?: string[];
}
/**
 * Merge pull requests using a merge queue
 */
export declare class MergeQueue extends Component {
    private readonly options;
    constructor(scope: IConstruct, options?: MergeQueueOptions);
    preSynthesize(): void;
}
