"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectBuild = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
/**
 * Manages a standard build process for all projects.
 *
 * Build spawns these tasks in order:
 * 1. default
 * 2. pre-compile
 * 3. compile
 * 4. post-compile
 * 5. test
 * 6. package
 */
class ProjectBuild extends component_1.Component {
    constructor(project) {
        super(project);
        this.preCompileTask = project.tasks.addTask("pre-compile", {
            description: "Prepare the project for compilation",
        });
        this.compileTask = project.tasks.addTask("compile", {
            description: "Only compile",
        });
        this.postCompileTask = project.tasks.addTask("post-compile", {
            description: "Runs after successful compilation",
        });
        this.testTask = project.tasks.addTask("test", {
            description: "Run tests",
        });
        this.packageTask = project.tasks.addTask("package", {
            description: "Creates the distribution package",
        });
        this.buildTask = project.tasks.addTask("build", {
            description: "Full release build",
        });
        // if this is not subproject, execute the "default" task which will
        // synthesize project files.
        if (!this.project.parent && this.project.defaultTask) {
            this.buildTask.spawn(this.project.defaultTask);
        }
        this.buildTask.spawn(this.preCompileTask);
        this.buildTask.spawn(this.compileTask);
        this.buildTask.spawn(this.postCompileTask);
        this.buildTask.spawn(this.testTask);
        this.buildTask.spawn(this.packageTask);
        // do not allow additional build phases
        this.buildTask.lock();
    }
}
exports.ProjectBuild = ProjectBuild;
_a = JSII_RTTI_SYMBOL_1;
ProjectBuild[_a] = { fqn: "projen.ProjectBuild", version: "0.98.9" };
//# sourceMappingURL=data:application/json;base64,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