"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = exports.ProjenrcJson = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const projenrc_1 = require("./projenrc");
/**
 * Sets up a project to use JSON for projenrc.
 */
class ProjenrcJson extends projenrc_1.ProjenrcFile {
    constructor(project, options = {}) {
        super(project);
        this.filePath = options.filename ?? ".projenrc.json";
        // this is the task projen executes when running `projen`
        project.defaultTask?.env("FILENAME", this.filePath);
        project.defaultTask?.builtin("run-projenrc-json");
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = (0, path_1.resolve)(this.project.outdir, this.filePath);
        if ((0, fs_1.existsSync)(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const json = {
            type: bootstrap.fqn,
            ...bootstrap.args,
        };
        (0, fs_1.mkdirSync)((0, path_1.dirname)(rcfile), { recursive: true });
        (0, fs_1.writeFileSync)(rcfile, JSON.stringify(json, null, 2));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.ProjenrcJson = ProjenrcJson;
_a = JSII_RTTI_SYMBOL_1;
ProjenrcJson[_a] = { fqn: "projen.ProjenrcJson", version: "0.98.9" };
/**
 * @deprecated use `ProjenrcJson`
 */
class Projenrc extends ProjenrcJson {
}
exports.Projenrc = Projenrc;
_b = JSII_RTTI_SYMBOL_1;
Projenrc[_b] = { fqn: "projen.Projenrc", version: "0.98.9" };
//# sourceMappingURL=data:application/json;base64,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