"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Renovatebot = exports.RenovatebotScheduleInterval = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const dependencies_1 = require("./dependencies");
const json_1 = require("./json");
/**
 * How often to check for new versions and raise pull requests for version
 * updates.
 *
 * @see https://docs.renovatebot.com/presets-schedule/
 */
var RenovatebotScheduleInterval;
(function (RenovatebotScheduleInterval) {
    /**
     * Run at any time
     */
    RenovatebotScheduleInterval["ANY_TIME"] = "at any time";
    /**
     * Weekly schedule on early monday mornings
     */
    RenovatebotScheduleInterval["EARLY_MONDAYS"] = "before 3am on Monday";
    /**
     * Schedule daily
     */
    RenovatebotScheduleInterval["DAILY"] = "before 2am";
    /**
     * Schedule weekly
     */
    RenovatebotScheduleInterval["WEEKLY"] = "before 3am on Monday";
    /**
     * Schedule monthly
     */
    RenovatebotScheduleInterval["MONTHLY"] = "before 3am on the first day of the month";
    /**
     * Schedule quarterly
     */
    RenovatebotScheduleInterval["QUARTERLY"] = "every 3 months on the first day of the month";
    /**
     * Schedule for weekends
     */
    RenovatebotScheduleInterval["WEEKENDS"] = "every weekend";
    /**
     * Schedule for weekdays
     */
    RenovatebotScheduleInterval["WEEKDAYS"] = "every weekday";
})(RenovatebotScheduleInterval || (exports.RenovatebotScheduleInterval = RenovatebotScheduleInterval = {}));
/**
 * Defines renovatebot configuration for projen project.
 *
 * Ignores the versions controlled by Projen.
 */
class Renovatebot extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this._project = project;
        this.explicitIgnores = options.ignore ?? [];
        this.labels = options.labels;
        this.scheduleInterval = options.scheduleInterval ?? [
            RenovatebotScheduleInterval.ANY_TIME,
        ];
        (options.ignoreProjen ?? true) && this.explicitIgnores.push("projen");
        this.overrideConfig = options.overrideConfig ?? {};
        this.marker = options.marker ?? true;
        this.file = new json_1.JsonFile(this._project, "renovate.json5", {
            obj: () => this.createRenovateConfiguration(),
            committed: true,
            marker: this.marker,
        });
    }
    createRenovateConfiguration() {
        const renovateIgnore = [
            ...new Set(this._project.deps.all
                .filter((dep) => dep.version || dep.type === dependencies_1.DependencyType.OVERRIDE)
                .map((dep) => dep.name)
                .concat(this.explicitIgnores)),
        ];
        // Ignore GitHub Action updates in Projen created workspaces
        const github = this._project.github;
        if (github?.workflowsEnabled) {
            const actions = github.workflows
                .flatMap((workflow) => Object.values(workflow.jobs))
                .flatMap((job) => job.steps)
                .map((step) => step?.uses?.split("@")[0])
                .filter((actionName) => !!actionName);
            const reusableWorkflows = github.workflows
                .flatMap((workflow) => Object.values(workflow.jobs))
                .flatMap((job) => job.uses)
                .map((reusableWorkflow) => reusableWorkflow?.split("@")[0]);
            renovateIgnore.push(...new Set(actions));
            renovateIgnore.push(...new Set(reusableWorkflows));
        }
        return {
            labels: this.labels,
            schedule: this.scheduleInterval,
            extends: [
                ":preserveSemverRanges",
                "config:recommended",
                "group:allNonMajor",
                "group:recommended",
                "group:monorepos",
            ],
            packageRules: [
                {
                    matchDepTypes: ["devDependencies"],
                    matchUpdateTypes: ["patch", "minor"],
                    groupName: "devDependencies (non-major)",
                },
            ],
            ignoreDeps: renovateIgnore,
            ...this.overrideConfig,
        };
    }
}
exports.Renovatebot = Renovatebot;
_a = JSII_RTTI_SYMBOL_1;
Renovatebot[_a] = { fqn: "projen.Renovatebot", version: "0.98.9" };
//# sourceMappingURL=data:application/json;base64,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