"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevContainer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * Relative path of devcontainer file to generate
 */
const DEVCONTAINER_FILE = ".devcontainer.json";
/**
 * A development environment running VSCode in a container; used by GitHub
 * codespaces.
 */
class DevContainer extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this.postCreateTasks = new Array();
        this.ports = new Array();
        this.vscodeExtensions = new Array();
        this.features = new Array();
        this.dockerImage = options?.dockerImage;
        if (options?.tasks) {
            for (const task of options.tasks) {
                this.addTasks(task);
            }
        }
        if (options?.ports) {
            this.addPorts(...options.ports);
        }
        if (options?.vscodeExtensions) {
            this.addVscodeExtensions(...options.vscodeExtensions);
        }
        if (options.features) {
            this.addFeatures(...options.features);
        }
        this.config = {
            image: () => this.dockerImage?.image,
            build: {
                dockerfile: () => this.dockerImage?.dockerFile,
            },
            postCreateCommand: () => this.renderTasks(),
            forwardPorts: this.ports,
            extensions: this.vscodeExtensions,
            features: () => this.renderFeatures(),
        };
        new json_1.JsonFile(this.project, DEVCONTAINER_FILE, {
            obj: this.config,
            omitEmpty: true,
        });
    }
    addDockerImage(image) {
        if (this.dockerImage) {
            throw new Error("dockerImage cannot be redefined.");
        }
        this.dockerImage = image;
    }
    /**
     * Adds tasks to run when the container starts. Tasks will be run in sequence.
     *
     * @param tasks The new tasks
     */
    addTasks(...tasks) {
        this.postCreateTasks.push(...tasks);
    }
    /**
     * Adds ports that should be exposed (forwarded) from the container.
     *
     * @param ports The new ports
     */
    addPorts(...ports) {
        this.ports.push(...ports);
    }
    /**
     * Adds a list of VSCode extensions that should be automatically installed
     * in the container.
     *
     * @param extensions The extension IDs
     */
    addVscodeExtensions(...extensions) {
        this.vscodeExtensions.push(...extensions);
    }
    /**
     * Adds a list of VSCode features that should be automatically installed
     * in the container.
     *
     * @param features featureName and version(optional default: latest)
     */
    addFeatures(...features) {
        this.features.push(...features);
    }
    renderTasks() {
        if (this.postCreateTasks.length !== 0) {
            return this.postCreateTasks
                .map((task) => `( npx projen ${task.name} )`)
                .join(" && ");
        }
        else {
            return undefined;
        }
    }
    renderFeatures() {
        if (this.features.length === 0) {
            return undefined;
        }
        return this.features.reduce((pv, feature) => {
            pv[feature.name] = {
                version: feature.version ?? "latest",
            };
            return pv;
        }, {});
    }
}
exports.DevContainer = DevContainer;
_a = JSII_RTTI_SYMBOL_1;
DevContainer[_a] = { fqn: "projen.vscode.DevContainer", version: "0.98.9" };
//# sourceMappingURL=data:application/json;base64,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