from xdsl.ir import Dialect

from .attributes import LabelAttr
from .ops import (
    C_JaeOp,
    C_JaOp,
    C_JbeOp,
    C_JbOp,
    C_JcOp,
    C_JeOp,
    C_JgeOp,
    C_JgOp,
    C_JleOp,
    C_JlOp,
    C_JmpOp,
    C_JnaeOp,
    C_JnaOp,
    C_JnbeOp,
    C_JnbOp,
    C_JncOp,
    C_JneOp,
    C_JngeOp,
    C_JngOp,
    C_JnleOp,
    C_JnlOp,
    C_JnoOp,
    C_JnpOp,
    C_JnsOp,
    C_JnzOp,
    C_JoOp,
    C_JpeOp,
    C_JpoOp,
    C_JpOp,
    C_JsOp,
    C_JzOp,
    D_PopOp,
    DI_MovOp,
    DirectiveOp,
    DM_LeaOp,
    DM_MovOp,
    DM_VbroadcastsdOp,
    DM_VbroadcastssOp,
    DM_VmovupdOp,
    DM_VmovupsOp,
    DMI_ImulOp,
    DS_MovOp,
    DS_VmovapdOp,
    DS_VpbroadcastdOp,
    DS_VpbroadcastqOp,
    DSI_ImulOp,
    DSSI_ShufpsOp,
    GetAVXRegisterOp,
    GetRegisterOp,
    LabelOp,
    M_DecOp,
    M_IDivOp,
    M_ImulOp,
    M_IncOp,
    M_NegOp,
    M_NotOp,
    M_PopOp,
    M_PushOp,
    MI_AddOp,
    MI_AndOp,
    MI_CmpOp,
    MI_MovOp,
    MI_OrOp,
    MI_SubOp,
    MI_XorOp,
    MS_AddOp,
    MS_AndOp,
    MS_CmpOp,
    MS_MovOp,
    MS_OrOp,
    MS_SubOp,
    MS_VmovapdOp,
    MS_VmovupsOp,
    MS_XorOp,
    R_DecOp,
    R_IncOp,
    R_NegOp,
    R_NotOp,
    RI_AddOp,
    RI_AndOp,
    RI_OrOp,
    RI_SubOp,
    RI_XorOp,
    RM_AddOp,
    RM_AndOp,
    RM_ImulOp,
    RM_OrOp,
    RM_SubOp,
    RM_XorOp,
    RS_AddOp,
    RS_AndOp,
    RS_FAddOp,
    RS_FMulOp,
    RS_ImulOp,
    RS_OrOp,
    RS_SubOp,
    RS_XorOp,
    RSS_Vfmadd231pdOp,
    RSS_Vfmadd231psOp,
    S_IDivOp,
    S_ImulOp,
    S_PushOp,
    SI_CmpOp,
    SM_CmpOp,
    SS_CmpOp,
)
from .registers import (
    AVX2RegisterType,
    AVX512RegisterType,
    GeneralRegisterType,
    RFLAGSRegisterType,
    SSERegisterType,
)

X86 = Dialect(
    "x86",
    [
        C_JaeOp,
        C_JaOp,
        C_JbeOp,
        C_JbOp,
        C_JcOp,
        C_JeOp,
        C_JgeOp,
        C_JgOp,
        C_JleOp,
        C_JlOp,
        C_JmpOp,
        C_JnaeOp,
        C_JnaOp,
        C_JnbeOp,
        C_JnbOp,
        C_JncOp,
        C_JneOp,
        C_JngeOp,
        C_JngOp,
        C_JnleOp,
        C_JnlOp,
        C_JnoOp,
        C_JnpOp,
        C_JnsOp,
        C_JnzOp,
        C_JoOp,
        C_JpeOp,
        C_JpoOp,
        C_JpOp,
        C_JsOp,
        C_JzOp,
        D_PopOp,
        DI_MovOp,
        DirectiveOp,
        DM_LeaOp,
        DM_MovOp,
        DM_VbroadcastsdOp,
        DM_VbroadcastssOp,
        DM_VmovupdOp,
        DM_VmovupsOp,
        DMI_ImulOp,
        DS_MovOp,
        DS_VmovapdOp,
        DS_VpbroadcastdOp,
        DS_VpbroadcastqOp,
        DSI_ImulOp,
        DSSI_ShufpsOp,
        GetAVXRegisterOp,
        GetRegisterOp,
        LabelOp,
        M_DecOp,
        M_IDivOp,
        M_ImulOp,
        M_IncOp,
        M_NegOp,
        M_NotOp,
        M_PopOp,
        M_PushOp,
        MI_AddOp,
        MI_AndOp,
        MI_CmpOp,
        MI_MovOp,
        MI_OrOp,
        MI_SubOp,
        MI_XorOp,
        MS_AddOp,
        MS_AndOp,
        MS_CmpOp,
        MS_MovOp,
        MS_OrOp,
        MS_SubOp,
        MS_VmovapdOp,
        MS_VmovupsOp,
        MS_XorOp,
        R_DecOp,
        R_IncOp,
        R_NegOp,
        R_NotOp,
        RI_AddOp,
        RI_AndOp,
        RI_OrOp,
        RI_SubOp,
        RI_XorOp,
        RM_AddOp,
        RM_AndOp,
        RM_ImulOp,
        RM_OrOp,
        RM_SubOp,
        RM_XorOp,
        RS_AddOp,
        RS_AndOp,
        RS_FAddOp,
        RS_FMulOp,
        RS_ImulOp,
        RS_OrOp,
        RS_SubOp,
        RS_XorOp,
        RSS_Vfmadd231pdOp,
        RSS_Vfmadd231psOp,
        S_IDivOp,
        S_ImulOp,
        S_PushOp,
        SI_CmpOp,
        SM_CmpOp,
        SS_CmpOp,
    ],
    [
        GeneralRegisterType,
        RFLAGSRegisterType,
        SSERegisterType,
        AVX2RegisterType,
        AVX512RegisterType,
        LabelAttr,
    ],
)
