# OpenMAS

[![PyPI version](https://img.shields.io/pypi/v/openmas.svg)](https://pypi.org/project/openmas/)
[![Python Version](https://img.shields.io/badge/python-3.10-blue.svg)](https://www.python.org/downloads/)
[![License: MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)
[![Poetry](https://img.shields.io/endpoint?url=https://python-poetry.org/badge/v0.json)](https://python-poetry.org/)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![CI/CD](https://github.com/openmas-ai/openmas/actions/workflows/ci-cd.yml/badge.svg)](https://github.com/openmas-ai/openmas/actions)
[![codecov](https://codecov.io/gh/openmas-ai/openmas/graph/badge.svg)](https://codecov.io/gh/openmas-ai/openmas)

**Easily Build Smart Multi-Agent Systems**

**OpenMAS** streamlines asynchronous Multi-Agent System (MAS) development in Python. By providing a lightweight **framework**, standardized structure, and helpful CLI tools, it handles the foundational setup, freeing you to concentrate on what matters most: designing and implementing sophisticated agent behaviors.

Inspired by modern development ecosystems and driven by real-world use cases like coding and gaming agents, OpenMAS aims to streamline the entire MAS lifecycle, with particular attention to integrating communication protocols like the **Model Context Protocol (MCP)** alongside standard web protocols.

**Full Documentation:** [**https://docs.openmas.ai**](https://docs.openmas.ai)

## Key Features

* **Simplified Agent Development:** Build agents inheriting from `BaseAgent` with a clear asynchronous lifecycle (`setup`, `run`, `shutdown`).
* **Flexible Communication:** Pluggable communicators for HTTP, Model Context Protocol (SSE & Stdio), gRPC, MQTT, with **lazy loading** to keep dependencies minimal. Easily extend with custom communicators. See [Communication](https://docs.openmas.ai/guides/communication).
* **Structured Projects:** Standardized directory layout (`agents/`, `shared/`, `extensions/`, `packages/`) generated by `openmas init` promotes modularity and maintainability. See [Project Structure](https://docs.openmas.ai/project_structure).
* **Layered Configuration:** Robust system loading configuration from files (`openmas_project.yml`, `config/*.yml`), `.env`, and environment variables. See [Configuration Guide](https://docs.openmas.ai/guides/configuration).
* **Agent Reasoning Agnosticism:** While `BaseAgent` inherently supports heuristic-based logic, OpenMAS facilitates integrating diverse reasoning mechanisms. Follow guides for [LLM Integration](https://docs.openmas.ai/guides/llm_integration) (using official LLM client libraries like OpenAI, Anthropic, Google Gemini) or explore built-in support for [BDI Patterns](https://docs.openmas.ai/guides/reasoning_integration) (including `BdiAgent` and [SPADE-BDI](https://pypi.org/project/spade-bdi/) integration examples).
* **Workflow Implementation:** Implement various agent interaction patterns (see [Building Effective Agents](https://docs.openmas.ai/https://www.anthropic.com/engineering/building-effective-agents)). While specific helpers exist for the [Orchestrator-Worker pattern](https://docs.openmas.ai/guides/patterns), the core framework enables building custom workflows like **prompt chaining, routing, and parallel execution**, with more helpers planned for future releases. See [Agent Patterns](https://docs.openmas.ai/guides/patterns).
* **Developer Workflow Tools:** Use the `openmas` CLI tool for initializing projects (`openmas init`), validating configuration (`openmas validate`), running agents locally (`openmas run`), managing dependencies (`openmas deps`), and generating deployment artifacts (`openmas generate-dockerfile`, `openmas generate-compose`). See [CLI Docs](https://docs.openmas.ai/cli/index).
* **Extensibility:** Design encourages local project extensions (`extensions/`) and shareable external packages (`packages/`).
* **Testing Utilities:** Includes `MockCommunicator` and `AgentTestHarness` to facilitate unit and integration testing. See [Testing Your Agents](https://docs.openmas.ai/guides/testing-utilities).


## Installation

```bash
pip install openmas
```

OpenMAS has optional extras for different communication protocols (`[mcp]`, `[grpc]`, `[mqtt]`, `[all]`).

See the full [Installation Guide](https://docs.openmas.ai/guides/installation/) for details on prerequisites, virtual environments, and optional dependencies.

## Quick Start

The best way to get started with OpenMAS is by following our detailed tutorial, which guides you through creating and running your first agent using the standard project structure:

* [**Getting Started Guide**](https://docs.openmas.ai/guides/getting_started/)

This guide uses the `openmas init` command to set up a project with the proper directory structure and `openmas run` to execute the agent.

## Contributing

Contributions are welcome! Please see the [Contributing Guide](https://docs.openmas.ai/contributing/contributing/) for details on how to get involved, set up your development environment, run tests (`tox`), and submit pull requests.

## License

OpenMAS is licensed under the [MIT License](https://github.com/openmas-ai/openmas?tab=MIT-1-ov-file).
