# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthorizationExceptionRuleArgs', 'AuthorizationExceptionRule']

@pulumi.input_type
class AuthorizationExceptionRuleArgs:
    def __init__(__self__, *,
                 policy_set_id: pulumi.Input[_builtins.str],
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationExceptionRuleChildrenArgs']]]] = None,
                 command_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_is_negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 condition_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 rank: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AuthorizationExceptionRule resource.
        :param pulumi.Input[_builtins.str] policy_set_id: Policy set ID
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationExceptionRuleChildrenArgs']]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] command_sets: Command sets enforce the specified list of commands that can be executed by a device administrator
        :param pulumi.Input[_builtins.str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[_builtins.str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[_builtins.str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[_builtins.str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[_builtins.str] condition_id: UUID for condition
        :param pulumi.Input[_builtins.bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[_builtins.str] condition_operator: Equality operator
                 - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        :param pulumi.Input[_builtins.str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
                 - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[_builtins.bool] default: Indicates if this rule is the default one
        :param pulumi.Input[_builtins.str] name: Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[_builtins.str] profile: Device admin profiles control the initial login session of the device administrator
        :param pulumi.Input[_builtins.int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[_builtins.str] state: The state that the rule is in. A disabled rule cannot be matched.
                 - Choices: `disabled`, `enabled`, `monitor`
        """
        pulumi.set(__self__, "policy_set_id", policy_set_id)
        if childrens is not None:
            pulumi.set(__self__, "childrens", childrens)
        if command_sets is not None:
            pulumi.set(__self__, "command_sets", command_sets)
        if condition_attribute_name is not None:
            pulumi.set(__self__, "condition_attribute_name", condition_attribute_name)
        if condition_attribute_value is not None:
            pulumi.set(__self__, "condition_attribute_value", condition_attribute_value)
        if condition_dictionary_name is not None:
            pulumi.set(__self__, "condition_dictionary_name", condition_dictionary_name)
        if condition_dictionary_value is not None:
            pulumi.set(__self__, "condition_dictionary_value", condition_dictionary_value)
        if condition_id is not None:
            pulumi.set(__self__, "condition_id", condition_id)
        if condition_is_negate is not None:
            pulumi.set(__self__, "condition_is_negate", condition_is_negate)
        if condition_operator is not None:
            pulumi.set(__self__, "condition_operator", condition_operator)
        if condition_type is not None:
            pulumi.set(__self__, "condition_type", condition_type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if rank is not None:
            pulumi.set(__self__, "rank", rank)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="policySetId")
    def policy_set_id(self) -> pulumi.Input[_builtins.str]:
        """
        Policy set ID
        """
        return pulumi.get(self, "policy_set_id")

    @policy_set_id.setter
    def policy_set_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_set_id", value)

    @_builtins.property
    @pulumi.getter
    def childrens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationExceptionRuleChildrenArgs']]]]:
        """
        List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        """
        return pulumi.get(self, "childrens")

    @childrens.setter
    def childrens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationExceptionRuleChildrenArgs']]]]):
        pulumi.set(self, "childrens", value)

    @_builtins.property
    @pulumi.getter(name="commandSets")
    def command_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Command sets enforce the specified list of commands that can be executed by a device administrator
        """
        return pulumi.get(self, "command_sets")

    @command_sets.setter
    def command_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "command_sets", value)

    @_builtins.property
    @pulumi.getter(name="conditionAttributeName")
    def condition_attribute_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dictionary attribute name
        """
        return pulumi.get(self, "condition_attribute_name")

    @condition_attribute_name.setter
    def condition_attribute_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_attribute_name", value)

    @_builtins.property
    @pulumi.getter(name="conditionAttributeValue")
    def condition_attribute_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute value for condition. Value type is specified in dictionary object.
        """
        return pulumi.get(self, "condition_attribute_value")

    @condition_attribute_value.setter
    def condition_attribute_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_attribute_value", value)

    @_builtins.property
    @pulumi.getter(name="conditionDictionaryName")
    def condition_dictionary_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dictionary name
        """
        return pulumi.get(self, "condition_dictionary_name")

    @condition_dictionary_name.setter
    def condition_dictionary_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_dictionary_name", value)

    @_builtins.property
    @pulumi.getter(name="conditionDictionaryValue")
    def condition_dictionary_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dictionary value
        """
        return pulumi.get(self, "condition_dictionary_value")

    @condition_dictionary_value.setter
    def condition_dictionary_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_dictionary_value", value)

    @_builtins.property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID for condition
        """
        return pulumi.get(self, "condition_id")

    @condition_id.setter
    def condition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_id", value)

    @_builtins.property
    @pulumi.getter(name="conditionIsNegate")
    def condition_is_negate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whereas this condition is in negate mode
        """
        return pulumi.get(self, "condition_is_negate")

    @condition_is_negate.setter
    def condition_is_negate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "condition_is_negate", value)

    @_builtins.property
    @pulumi.getter(name="conditionOperator")
    def condition_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Equality operator
          - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        """
        return pulumi.get(self, "condition_operator")

    @condition_operator.setter
    def condition_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_operator", value)

    @_builtins.property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
          - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_type", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if this rule is the default one
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Device admin profiles control the initial login session of the device administrator
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter
    def rank(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The rank (priority) in relation to other rules. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rank", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state that the rule is in. A disabled rule cannot be matched.
          - Choices: `disabled`, `enabled`, `monitor`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _AuthorizationExceptionRuleState:
    def __init__(__self__, *,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationExceptionRuleChildrenArgs']]]] = None,
                 command_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_is_negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 condition_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 rank: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthorizationExceptionRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationExceptionRuleChildrenArgs']]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] command_sets: Command sets enforce the specified list of commands that can be executed by a device administrator
        :param pulumi.Input[_builtins.str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[_builtins.str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[_builtins.str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[_builtins.str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[_builtins.str] condition_id: UUID for condition
        :param pulumi.Input[_builtins.bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[_builtins.str] condition_operator: Equality operator
                 - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        :param pulumi.Input[_builtins.str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
                 - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[_builtins.bool] default: Indicates if this rule is the default one
        :param pulumi.Input[_builtins.str] name: Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[_builtins.str] policy_set_id: Policy set ID
        :param pulumi.Input[_builtins.str] profile: Device admin profiles control the initial login session of the device administrator
        :param pulumi.Input[_builtins.int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[_builtins.str] state: The state that the rule is in. A disabled rule cannot be matched.
                 - Choices: `disabled`, `enabled`, `monitor`
        """
        if childrens is not None:
            pulumi.set(__self__, "childrens", childrens)
        if command_sets is not None:
            pulumi.set(__self__, "command_sets", command_sets)
        if condition_attribute_name is not None:
            pulumi.set(__self__, "condition_attribute_name", condition_attribute_name)
        if condition_attribute_value is not None:
            pulumi.set(__self__, "condition_attribute_value", condition_attribute_value)
        if condition_dictionary_name is not None:
            pulumi.set(__self__, "condition_dictionary_name", condition_dictionary_name)
        if condition_dictionary_value is not None:
            pulumi.set(__self__, "condition_dictionary_value", condition_dictionary_value)
        if condition_id is not None:
            pulumi.set(__self__, "condition_id", condition_id)
        if condition_is_negate is not None:
            pulumi.set(__self__, "condition_is_negate", condition_is_negate)
        if condition_operator is not None:
            pulumi.set(__self__, "condition_operator", condition_operator)
        if condition_type is not None:
            pulumi.set(__self__, "condition_type", condition_type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_set_id is not None:
            pulumi.set(__self__, "policy_set_id", policy_set_id)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if rank is not None:
            pulumi.set(__self__, "rank", rank)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def childrens(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationExceptionRuleChildrenArgs']]]]:
        """
        List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        """
        return pulumi.get(self, "childrens")

    @childrens.setter
    def childrens(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationExceptionRuleChildrenArgs']]]]):
        pulumi.set(self, "childrens", value)

    @_builtins.property
    @pulumi.getter(name="commandSets")
    def command_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Command sets enforce the specified list of commands that can be executed by a device administrator
        """
        return pulumi.get(self, "command_sets")

    @command_sets.setter
    def command_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "command_sets", value)

    @_builtins.property
    @pulumi.getter(name="conditionAttributeName")
    def condition_attribute_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dictionary attribute name
        """
        return pulumi.get(self, "condition_attribute_name")

    @condition_attribute_name.setter
    def condition_attribute_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_attribute_name", value)

    @_builtins.property
    @pulumi.getter(name="conditionAttributeValue")
    def condition_attribute_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute value for condition. Value type is specified in dictionary object.
        """
        return pulumi.get(self, "condition_attribute_value")

    @condition_attribute_value.setter
    def condition_attribute_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_attribute_value", value)

    @_builtins.property
    @pulumi.getter(name="conditionDictionaryName")
    def condition_dictionary_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dictionary name
        """
        return pulumi.get(self, "condition_dictionary_name")

    @condition_dictionary_name.setter
    def condition_dictionary_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_dictionary_name", value)

    @_builtins.property
    @pulumi.getter(name="conditionDictionaryValue")
    def condition_dictionary_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dictionary value
        """
        return pulumi.get(self, "condition_dictionary_value")

    @condition_dictionary_value.setter
    def condition_dictionary_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_dictionary_value", value)

    @_builtins.property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID for condition
        """
        return pulumi.get(self, "condition_id")

    @condition_id.setter
    def condition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_id", value)

    @_builtins.property
    @pulumi.getter(name="conditionIsNegate")
    def condition_is_negate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whereas this condition is in negate mode
        """
        return pulumi.get(self, "condition_is_negate")

    @condition_is_negate.setter
    def condition_is_negate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "condition_is_negate", value)

    @_builtins.property
    @pulumi.getter(name="conditionOperator")
    def condition_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Equality operator
          - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        """
        return pulumi.get(self, "condition_operator")

    @condition_operator.setter
    def condition_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_operator", value)

    @_builtins.property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
          - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition_type", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if this rule is the default one
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policySetId")
    def policy_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy set ID
        """
        return pulumi.get(self, "policy_set_id")

    @policy_set_id.setter
    def policy_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_set_id", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Device admin profiles control the initial login session of the device administrator
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter
    def rank(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The rank (priority) in relation to other rules. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rank", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state that the rule is in. A disabled rule cannot be matched.
          - Choices: `disabled`, `enabled`, `monitor`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("ise:deviceadmin/authorizationExceptionRule:AuthorizationExceptionRule")
class AuthorizationExceptionRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationExceptionRuleChildrenArgs', 'AuthorizationExceptionRuleChildrenArgsDict']]]]] = None,
                 command_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_is_negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 condition_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 rank: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Device Admin Authorization Exception Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.deviceadmin.AuthorizationExceptionRule("example",
            policy_set_id="d82952cb-b901-4b09-b363-5ebf39bdbaf9",
            name="Rule1",
            default=False,
            rank=0,
            state="enabled",
            condition_type="ConditionAttributes",
            condition_is_negate=False,
            condition_attribute_name="Location",
            condition_attribute_value="All Locations",
            condition_dictionary_name="DEVICE",
            condition_operator="equals",
            command_sets=["DenyAllCommands"],
            profile="Default Shell Profile")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:deviceadmin/authorizationExceptionRule:AuthorizationExceptionRule example "76d24097-41c4-4558-a4d0-a8c07ac08470,76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationExceptionRuleChildrenArgs', 'AuthorizationExceptionRuleChildrenArgsDict']]]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] command_sets: Command sets enforce the specified list of commands that can be executed by a device administrator
        :param pulumi.Input[_builtins.str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[_builtins.str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[_builtins.str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[_builtins.str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[_builtins.str] condition_id: UUID for condition
        :param pulumi.Input[_builtins.bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[_builtins.str] condition_operator: Equality operator
                 - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        :param pulumi.Input[_builtins.str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
                 - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[_builtins.bool] default: Indicates if this rule is the default one
        :param pulumi.Input[_builtins.str] name: Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[_builtins.str] policy_set_id: Policy set ID
        :param pulumi.Input[_builtins.str] profile: Device admin profiles control the initial login session of the device administrator
        :param pulumi.Input[_builtins.int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[_builtins.str] state: The state that the rule is in. A disabled rule cannot be matched.
                 - Choices: `disabled`, `enabled`, `monitor`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthorizationExceptionRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Device Admin Authorization Exception Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.deviceadmin.AuthorizationExceptionRule("example",
            policy_set_id="d82952cb-b901-4b09-b363-5ebf39bdbaf9",
            name="Rule1",
            default=False,
            rank=0,
            state="enabled",
            condition_type="ConditionAttributes",
            condition_is_negate=False,
            condition_attribute_name="Location",
            condition_attribute_value="All Locations",
            condition_dictionary_name="DEVICE",
            condition_operator="equals",
            command_sets=["DenyAllCommands"],
            profile="Default Shell Profile")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:deviceadmin/authorizationExceptionRule:AuthorizationExceptionRule example "76d24097-41c4-4558-a4d0-a8c07ac08470,76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param AuthorizationExceptionRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizationExceptionRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 childrens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationExceptionRuleChildrenArgs', 'AuthorizationExceptionRuleChildrenArgsDict']]]]] = None,
                 command_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 condition_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_name: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_dictionary_value: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_is_negate: Optional[pulumi.Input[_builtins.bool]] = None,
                 condition_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 condition_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 rank: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizationExceptionRuleArgs.__new__(AuthorizationExceptionRuleArgs)

            __props__.__dict__["childrens"] = childrens
            __props__.__dict__["command_sets"] = command_sets
            __props__.__dict__["condition_attribute_name"] = condition_attribute_name
            __props__.__dict__["condition_attribute_value"] = condition_attribute_value
            __props__.__dict__["condition_dictionary_name"] = condition_dictionary_name
            __props__.__dict__["condition_dictionary_value"] = condition_dictionary_value
            __props__.__dict__["condition_id"] = condition_id
            __props__.__dict__["condition_is_negate"] = condition_is_negate
            __props__.__dict__["condition_operator"] = condition_operator
            __props__.__dict__["condition_type"] = condition_type
            __props__.__dict__["default"] = default
            __props__.__dict__["name"] = name
            if policy_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_set_id'")
            __props__.__dict__["policy_set_id"] = policy_set_id
            __props__.__dict__["profile"] = profile
            __props__.__dict__["rank"] = rank
            __props__.__dict__["state"] = state
        super(AuthorizationExceptionRule, __self__).__init__(
            'ise:deviceadmin/authorizationExceptionRule:AuthorizationExceptionRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            childrens: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationExceptionRuleChildrenArgs', 'AuthorizationExceptionRuleChildrenArgsDict']]]]] = None,
            command_sets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            condition_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
            condition_attribute_value: Optional[pulumi.Input[_builtins.str]] = None,
            condition_dictionary_name: Optional[pulumi.Input[_builtins.str]] = None,
            condition_dictionary_value: Optional[pulumi.Input[_builtins.str]] = None,
            condition_id: Optional[pulumi.Input[_builtins.str]] = None,
            condition_is_negate: Optional[pulumi.Input[_builtins.bool]] = None,
            condition_operator: Optional[pulumi.Input[_builtins.str]] = None,
            condition_type: Optional[pulumi.Input[_builtins.str]] = None,
            default: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            profile: Optional[pulumi.Input[_builtins.str]] = None,
            rank: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthorizationExceptionRule':
        """
        Get an existing AuthorizationExceptionRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationExceptionRuleChildrenArgs', 'AuthorizationExceptionRuleChildrenArgsDict']]]] childrens: List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] command_sets: Command sets enforce the specified list of commands that can be executed by a device administrator
        :param pulumi.Input[_builtins.str] condition_attribute_name: Dictionary attribute name
        :param pulumi.Input[_builtins.str] condition_attribute_value: Attribute value for condition. Value type is specified in dictionary object.
        :param pulumi.Input[_builtins.str] condition_dictionary_name: Dictionary name
        :param pulumi.Input[_builtins.str] condition_dictionary_value: Dictionary value
        :param pulumi.Input[_builtins.str] condition_id: UUID for condition
        :param pulumi.Input[_builtins.bool] condition_is_negate: Indicates whereas this condition is in negate mode
        :param pulumi.Input[_builtins.str] condition_operator: Equality operator
                 - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        :param pulumi.Input[_builtins.str] condition_type: Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
                 - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        :param pulumi.Input[_builtins.bool] default: Indicates if this rule is the default one
        :param pulumi.Input[_builtins.str] name: Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        :param pulumi.Input[_builtins.str] policy_set_id: Policy set ID
        :param pulumi.Input[_builtins.str] profile: Device admin profiles control the initial login session of the device administrator
        :param pulumi.Input[_builtins.int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[_builtins.str] state: The state that the rule is in. A disabled rule cannot be matched.
                 - Choices: `disabled`, `enabled`, `monitor`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorizationExceptionRuleState.__new__(_AuthorizationExceptionRuleState)

        __props__.__dict__["childrens"] = childrens
        __props__.__dict__["command_sets"] = command_sets
        __props__.__dict__["condition_attribute_name"] = condition_attribute_name
        __props__.__dict__["condition_attribute_value"] = condition_attribute_value
        __props__.__dict__["condition_dictionary_name"] = condition_dictionary_name
        __props__.__dict__["condition_dictionary_value"] = condition_dictionary_value
        __props__.__dict__["condition_id"] = condition_id
        __props__.__dict__["condition_is_negate"] = condition_is_negate
        __props__.__dict__["condition_operator"] = condition_operator
        __props__.__dict__["condition_type"] = condition_type
        __props__.__dict__["default"] = default
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_set_id"] = policy_set_id
        __props__.__dict__["profile"] = profile
        __props__.__dict__["rank"] = rank
        __props__.__dict__["state"] = state
        return AuthorizationExceptionRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def childrens(self) -> pulumi.Output[Optional[Sequence['outputs.AuthorizationExceptionRuleChildren']]]:
        """
        List of child conditions. `condition_type` must be one of `ConditionAndBlock` or `ConditionOrBlock`.
        """
        return pulumi.get(self, "childrens")

    @_builtins.property
    @pulumi.getter(name="commandSets")
    def command_sets(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Command sets enforce the specified list of commands that can be executed by a device administrator
        """
        return pulumi.get(self, "command_sets")

    @_builtins.property
    @pulumi.getter(name="conditionAttributeName")
    def condition_attribute_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Dictionary attribute name
        """
        return pulumi.get(self, "condition_attribute_name")

    @_builtins.property
    @pulumi.getter(name="conditionAttributeValue")
    def condition_attribute_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Attribute value for condition. Value type is specified in dictionary object.
        """
        return pulumi.get(self, "condition_attribute_value")

    @_builtins.property
    @pulumi.getter(name="conditionDictionaryName")
    def condition_dictionary_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Dictionary name
        """
        return pulumi.get(self, "condition_dictionary_name")

    @_builtins.property
    @pulumi.getter(name="conditionDictionaryValue")
    def condition_dictionary_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Dictionary value
        """
        return pulumi.get(self, "condition_dictionary_value")

    @_builtins.property
    @pulumi.getter(name="conditionId")
    def condition_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        UUID for condition
        """
        return pulumi.get(self, "condition_id")

    @_builtins.property
    @pulumi.getter(name="conditionIsNegate")
    def condition_is_negate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whereas this condition is in negate mode
        """
        return pulumi.get(self, "condition_is_negate")

    @_builtins.property
    @pulumi.getter(name="conditionOperator")
    def condition_operator(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Equality operator
          - Choices: `contains`, `endsWith`, `equals`, `greaterOrEquals`, `greaterThan`, `in`, `ipEquals`, `ipGreaterThan`, `ipLessThan`, `ipNotEquals`, `lessOrEquals`, `lessThan`, `matches`, `notContains`, `notEndsWith`, `notEquals`, `notIn`, `notStartsWith`, `startsWith`, `macContains`, `macEndsWith`, `macEquals`, `macIn`, `macNotContains`, `macNotEndsWith`, `macNotEquals`, `macNotIn`, `macNotStartsWith`, `macStartsWith`
        """
        return pulumi.get(self, "condition_operator")

    @_builtins.property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether the record is the condition itself or a logical aggregation. Logical aggreation indicates that additional conditions are present under the children attribute.
          - Choices: `ConditionAndBlock`, `ConditionAttributes`, `ConditionOrBlock`, `ConditionReference`
        """
        return pulumi.get(self, "condition_type")

    @_builtins.property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if this rule is the default one
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Rule name, [Valid characters are alphanumerics, underscore, hyphen, space, period, parentheses]
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policySetId")
    def policy_set_id(self) -> pulumi.Output[_builtins.str]:
        """
        Policy set ID
        """
        return pulumi.get(self, "policy_set_id")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Device admin profiles control the initial login session of the device administrator
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter
    def rank(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The rank (priority) in relation to other rules. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The state that the rule is in. A disabled rule cannot be matched.
          - Choices: `disabled`, `enabled`, `monitor`
        """
        return pulumi.get(self, "state")

